/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBasicModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CamelContextElement
extends AbstractCamelModelElement {
    public static final String ATTR_Id = "id";
    public static final String ATTR_UseMDCLogging = "useMDCLogging";
    public static final String ATTR_UseBreadcrumb = "useBreadcrumb";
    private Map<String, AbstractCamelModelElement> endpointDefinitions = new HashMap<String, AbstractCamelModelElement>();
    private Map<String, AbstractCamelModelElement> dataformats = new HashMap<String, AbstractCamelModelElement>();

    public CamelContextElement(CamelFile camelFile, Node underlyingNode) {
        super(camelFile, underlyingNode);
    }

    public Map<String, AbstractCamelModelElement> getEndpointDefinitions() {
        return this.endpointDefinitions;
    }

    public void setEndpointDefinitions(Map<String, AbstractCamelModelElement> endpointDefinitions) {
        this.endpointDefinitions = endpointDefinitions;
    }

    public void addEndpointDefinition(AbstractCamelModelElement def) {
        if (this.endpointDefinitions.containsKey(def.getId())) {
            return;
        }
        this.endpointDefinitions.put(def.getId(), def);
        boolean childExists = false;
        int i = 0;
        while (i < this.getXmlNode().getChildNodes().getLength()) {
            if (def.getXmlNode() != null && this.getXmlNode().getChildNodes().item(i).isEqualNode(def.getXmlNode())) {
                childExists = true;
                break;
            }
            ++i;
        }
        if (def.getXmlNode() == null) {
            Element n = this.createElement("endpoint", this.getXmlNode() != null ? this.getXmlNode().getPrefix() : null);
            def.setXmlNode(n);
            def.updateXMLNode();
        }
        if (!childExists) {
            this.getXmlNode().insertBefore(def.getXmlNode(), this.getFirstChild(this.getXmlNode()));
        }
    }

    public void removeEndpointDefinition(AbstractCamelModelElement def) {
        if (this.endpointDefinitions.containsKey(def.getId())) {
            this.endpointDefinitions.remove(def.getId());
            boolean childExists = false;
            int i = 0;
            while (i < this.getXmlNode().getChildNodes().getLength()) {
                if (this.getXmlNode().getChildNodes().item(i).isEqualNode(def.getXmlNode())) {
                    childExists = true;
                    break;
                }
                ++i;
            }
            if (childExists) {
                this.getXmlNode().removeChild(def.getXmlNode());
            }
        }
    }

    public void clearEndpointDefinitions() {
        this.endpointDefinitions.clear();
    }

    public Map<String, AbstractCamelModelElement> getDataformats() {
        return this.dataformats;
    }

    public void setDataformats(Map<String, AbstractCamelModelElement> dataformats) {
        this.dataformats = dataformats;
    }

    public void addDataFormat(AbstractCamelModelElement df) {
        if (this.dataformats.containsKey(df.getId())) {
            return;
        }
        this.dataformats.put(df.getId(), df);
        boolean childExists = false;
        Node dataFormatsNode = null;
        int i = 0;
        while (i < this.getXmlNode().getChildNodes().getLength()) {
            Node n = this.getXmlNode().getChildNodes().item(i);
            if (n.getNodeType() == 1 && CamelUtils.getTranslatedNodeName((Node)n).equals("dataFormats")) {
                dataFormatsNode = n;
                break;
            }
            ++i;
        }
        if (dataFormatsNode == null) {
            dataFormatsNode = this.createElement("dataFormats", this != null && this.getXmlNode() != null ? this.getXmlNode().getPrefix() : null);
            Node firstNotEndpointNode = this.getFirstNotEndpointNode();
            if (firstNotEndpointNode != null) {
                this.getXmlNode().insertBefore(dataFormatsNode, firstNotEndpointNode);
            } else {
                this.getXmlNode().appendChild(dataFormatsNode);
            }
        }
        i = 0;
        while (i < dataFormatsNode.getChildNodes().getLength()) {
            if (df.getXmlNode() != null && dataFormatsNode.getChildNodes().item(i).isEqualNode(df.getXmlNode())) {
                childExists = true;
                break;
            }
            ++i;
        }
        if (df.getXmlNode() == null) {
            Element n = this.createElement(df.getUnderlyingMetaModelObject().getName(), this.getXmlNode() != null ? this.getXmlNode().getPrefix() : null);
            df.setXmlNode(n);
            df.updateXMLNode();
        }
        if (!childExists) {
            dataFormatsNode.appendChild(df.getXmlNode());
        }
    }

    private Node getFirstNotEndpointNode() {
        NodeList childNodes = this.getXmlNode().getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node currentNode = childNodes.item(i);
            if (currentNode instanceof Element && !"endpoint".equals(currentNode.getLocalName())) {
                return currentNode;
            }
            ++i;
        }
        return null;
    }

    public void removeDataFormat(AbstractCamelModelElement df) {
        if (this.dataformats.containsKey(df.getId())) {
            this.dataformats.remove(df.getId());
            Node dataFormatsNode = null;
            int i = 0;
            while (i < this.getXmlNode().getChildNodes().getLength()) {
                Node n = this.getXmlNode().getChildNodes().item(i);
                if (n.getNodeType() == 1 && CamelUtils.getTranslatedNodeName((Node)n).equals("dataFormats")) {
                    dataFormatsNode = n;
                    break;
                }
                ++i;
            }
            if (dataFormatsNode == null) {
                dataFormatsNode = df.getXmlNode().getParentNode();
            }
            Node nodeToDelete = null;
            if (dataFormatsNode != null) {
                int i2 = 0;
                while (i2 < dataFormatsNode.getChildNodes().getLength()) {
                    Node n = dataFormatsNode.getChildNodes().item(i2);
                    if (n.getNodeType() == 1 && n.isEqualNode(df.getXmlNode())) {
                        nodeToDelete = n;
                        break;
                    }
                    ++i2;
                }
                if (nodeToDelete != null) {
                    dataFormatsNode.removeChild(nodeToDelete);
                    if (nodeToDelete.getParentNode() != null) {
                        nodeToDelete.getParentNode().removeChild(nodeToDelete);
                    }
                    if (df.getXmlNode().getParentNode() != null) {
                        df.getXmlNode().getParentNode().removeChild(df.getXmlNode());
                    }
                    int cnt = 0;
                    int i3 = 0;
                    while (i3 < dataFormatsNode.getChildNodes().getLength()) {
                        Node n = dataFormatsNode.getChildNodes().item(i3);
                        if (n.getNodeType() == 1) {
                            ++cnt;
                        }
                        ++i3;
                    }
                    if (cnt == 0) {
                        dataFormatsNode.getParentNode().removeChild(dataFormatsNode);
                    }
                }
            }
        }
    }

    public void clearDataFormats() {
        this.dataformats.clear();
    }

    @Override
    protected void parseAttributes() {
        Node tmp = this.getXmlNode().getAttributes().getNamedItem(ATTR_Id);
        if (tmp != null && tmp.getNodeValue() != null && tmp.getNodeValue().trim().length() > 0) {
            this.setId(tmp.getNodeValue());
        }
        if ((tmp = this.getXmlNode().getAttributes().getNamedItem(ATTR_UseMDCLogging)) != null) {
            this.setParameter(ATTR_UseMDCLogging, tmp.getNodeValue());
        }
        if ((tmp = this.getXmlNode().getAttributes().getNamedItem(ATTR_UseBreadcrumb)) != null) {
            this.setParameter(ATTR_UseBreadcrumb, tmp.getNodeValue());
        }
    }

    @Override
    protected void parseChildren() {
        NodeList children = this.getXmlNode().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node tmp = children.item(i);
            if (tmp.getNodeType() == 1) {
                AbstractCamelModelElement cme;
                if (CamelUtils.getTranslatedNodeName((Node)tmp).equals("dataFormats")) {
                    NodeList dfs = tmp.getChildNodes();
                    int y = 0;
                    while (y < dfs.getLength()) {
                        Node tmp_df = dfs.item(y);
                        if (tmp_df.getNodeType() == 1) {
                            CamelBasicModelElement cme2 = new CamelBasicModelElement(this, tmp_df);
                            cme2.initialize();
                            this.dataformats.put(cme2.getId(), cme2);
                        }
                        ++y;
                    }
                } else if (CamelUtils.getTranslatedNodeName((Node)tmp).equals("endpoint")) {
                    cme = new CamelBasicModelElement(this, tmp);
                    cme.initialize();
                    this.endpointDefinitions.put(cme.getId(), cme);
                } else if (CamelUtils.getTranslatedNodeName((Node)tmp).equals("route")) {
                    cme = new CamelRouteElement(this, tmp);
                    cme.initialize();
                    this.addChildElement(cme);
                } else {
                    CamelModelServiceCoreActivator.pluginLog().logWarning("Unexpected child element of the context: " + CamelUtils.getTranslatedNodeName((Node)tmp));
                }
            }
            ++i;
        }
    }

    @Override
    public List<AbstractCamelModelElement> findAllNodesWithId(String nodeId) {
        List<AbstractCamelModelElement> result = super.findAllNodesWithId(nodeId);
        if (this.getDataformats().containsKey(nodeId)) {
            result.add(this.getDataformats().get(nodeId));
        }
        if (this.getEndpointDefinitions().containsKey(nodeId)) {
            result.add(this.getEndpointDefinitions().get(nodeId));
        }
        return result;
    }

    @Override
    public AbstractCamelModelElement findNode(String nodeId) {
        AbstractCamelModelElement res = super.findNode(nodeId);
        if (res != null) {
            return res;
        }
        if (this.getDataformats().containsKey(nodeId)) {
            return this.getDataformats().get(nodeId);
        }
        if (this.getEndpointDefinitions().containsKey(nodeId)) {
            return this.getEndpointDefinitions().get(nodeId);
        }
        return null;
    }

    @Override
    public CamelContextElement getCamelContext() {
        return this;
    }

    @Override
    public String getNodeTypeId() {
        return "camelContext";
    }

    @Override
    public boolean supportsBreakpoint() {
        return false;
    }
}

