/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.model;

import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.w3c.dom.Node;

public class CamelElementConnection
extends AbstractCamelModelElement {
    private boolean isConnected;
    private AbstractCamelModelElement source;
    private AbstractCamelModelElement target;

    public CamelElementConnection(AbstractCamelModelElement source, AbstractCamelModelElement target) {
        super(null, null);
        if (source == null) {
            throw new IllegalArgumentException("No source for Flow");
        }
        if (target == null) {
            throw new IllegalArgumentException("No target for Flow");
        }
        this.reconnect(source, target);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CamelElementConnection other = (CamelElementConnection)obj;
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public void disconnect() {
        if (this.isConnected) {
            this.source.setOutputElement(null);
            this.target.setInputElement(null);
            this.isConnected = false;
        }
    }

    public AbstractCamelModelElement getSource() {
        return this.source;
    }

    public AbstractCamelModelElement getTarget() {
        return this.target;
    }

    public void reconnect() {
        if (!this.isConnected) {
            this.source.setOutputElement(this.target);
            this.target.setInputElement(this.source);
            Node sourceNode = this.source.getXmlNode();
            Node targetNode = this.target.getXmlNode();
            this.source.getParent().getXmlNode().insertBefore(sourceNode, targetNode);
            this.isConnected = true;
        }
    }

    public void reconnect(AbstractCamelModelElement newSource, AbstractCamelModelElement newTarget) {
        if (newSource == null || newTarget == null || newSource == newTarget) {
            throw new IllegalArgumentException();
        }
        this.disconnect();
        this.source = newSource;
        this.target = newTarget;
        this.reconnect();
    }

    @Override
    public String toString() {
        return "Connection: " + this.source + " -> " + this.target;
    }
}

