/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.model;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.io.CamelIOHandler;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelSchemaType;
import org.fusesource.ide.camel.model.service.core.model.GlobalDefinitionCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.ICamelModelListener;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class CamelFile
extends AbstractCamelModelElement
implements EventListener {
    public static final int XML_INDENT_VALUE = 3;
    protected static final String CAMEL_CONTEXT = "camelContext";
    protected static final String CAMEL_ROUTES = "routes";
    private Map<String, GlobalDefinitionCamelModelElement> globalDefinitions = new HashMap<String, GlobalDefinitionCamelModelElement>();
    private IResource resource;
    private CamelSchemaType schemaType;
    private Document document;
    private List<ICamelModelListener> modelListeners = new ArrayList<ICamelModelListener>();

    public CamelFile(IResource resource) {
        super(null, null);
        this.resource = resource;
    }

    public void resetContents() {
        this.getGlobalDefinitions().clear();
        this.getChildElements().clear();
    }

    @Override
    public void initialize() {
        super.initialize();
        NodeList childNodes = this.document.getDocumentElement().getChildNodes();
        if (CAMEL_ROUTES.equals(CamelUtils.getTranslatedNodeName((Node)this.document.getDocumentElement()))) {
            int endIdx;
            CamelContextElement cce = new CamelContextElement(this, (Node)this.document.getDocumentElement());
            Node namedItem = this.document.getDocumentElement().getAttributes().getNamedItem("id");
            String contextId = namedItem != null ? namedItem.getNodeValue() : String.valueOf(CamelUtils.getTranslatedNodeName((Node)this.document.getDocumentElement())) + "-" + UUID.randomUUID().toString();
            int startIdx = this.resource.getFullPath().toOSString().indexOf("--");
            if (startIdx != (endIdx = this.resource.getFullPath().toOSString().indexOf("--", startIdx + 1)) && startIdx != -1) {
                contextId = this.resource.getFullPath().toOSString().substring(startIdx + 2, endIdx);
            }
            cce.setId(contextId);
            cce.initialize();
            this.addChildElement(cce);
        } else {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                if (child.getNodeType() == 1) {
                    String id;
                    String name = CamelUtils.getTranslatedNodeName((Node)child);
                    String string = id = child.getAttributes().getNamedItem("id") != null ? child.getAttributes().getNamedItem("id").getNodeValue() : String.valueOf(CamelUtils.getTranslatedNodeName((Node)child)) + "-" + UUID.randomUUID().toString();
                    if (name.equals(CAMEL_CONTEXT)) {
                        CamelContextElement cce = new CamelContextElement(this, child);
                        cce.setId(id);
                        cce.initialize();
                        this.addChildElement(cce);
                    } else {
                        GlobalDefinitionCamelModelElement cme = new GlobalDefinitionCamelModelElement(this, child);
                        cme.setId(id);
                        cme.initialize();
                        this.addGlobalDefinition(id, cme);
                    }
                }
                ++i;
            }
        }
    }

    public CamelFile reloadModelFromXML(String xmlString) {
        try {
            CamelIOHandler ioHandler = new CamelIOHandler();
            return ioHandler.loadCamelModel(xmlString, (IProgressMonitor)new NullProgressMonitor(), this);
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to load Camel context file from String: \n" + xmlString, (Throwable)ex);
            return null;
        }
    }

    public Map<String, GlobalDefinitionCamelModelElement> getGlobalDefinitions() {
        return this.globalDefinitions;
    }

    public void setGlobalDefinitions(Map<String, GlobalDefinitionCamelModelElement> globalDefinitions) {
        this.globalDefinitions = globalDefinitions;
    }

    public String addGlobalDefinition(String id, GlobalDefinitionCamelModelElement cme) {
        String usedId;
        if (this.globalDefinitions.containsKey(id)) {
            return id;
        }
        String string = usedId = id != null ? id : "_def" + UUID.randomUUID().toString();
        if (usedId != null && this.globalDefinitions.containsKey(usedId) || id == null && this.globalDefinitions.containsValue(cme)) {
            return null;
        }
        this.globalDefinitions.put(usedId, cme);
        Node parentNode = cme.getXmlNode().getParentNode();
        Element documentElement = this.getDocument().getDocumentElement();
        if (parentNode == null || !parentNode.isEqualNode(documentElement)) {
            documentElement.insertBefore(cme.getXmlNode(), documentElement.getChildNodes().item(0));
            this.fireModelChanged();
        }
        return usedId;
    }

    public String updateGlobalDefinition(String id, GlobalDefinitionCamelModelElement cme) {
        String usedId = id != null ? id : "_def" + UUID.randomUUID().toString();
        Node oldDef = this.globalDefinitions.put(usedId, cme).getXmlNode();
        Node parentNode = cme.getXmlNode().getParentNode();
        Element documentElement = this.getDocument().getDocumentElement();
        if (parentNode == null || !parentNode.isEqualNode(documentElement)) {
            documentElement.replaceChild(cme.getXmlNode(), oldDef);
            this.fireModelChanged();
        }
        return usedId;
    }

    public void removeGlobalDefinition(String id) {
        Node nodeToRemove;
        GlobalDefinitionCamelModelElement cmeToremove = this.globalDefinitions.remove(id);
        if (cmeToremove != null && (nodeToRemove = cmeToremove.getXmlNode()) != null) {
            this.getDocument().getDocumentElement().removeChild(nodeToRemove);
            this.fireModelChanged();
        }
    }

    public void clearGlobalDefinitions() {
        this.globalDefinitions.clear();
    }

    public CamelSchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(CamelSchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void registerDOMListener() {
        if (this.document != null && this.document.getDocumentElement() instanceof EventTarget) {
            ((EventTarget)((Object)this.document.getDocumentElement())).addEventListener("DOMSubtreeModified", this, true);
        }
    }

    public void unregisterDOMListener() {
        if (this.document != null && this.document.getDocumentElement() instanceof EventTarget) {
            ((EventTarget)((Object)this.document.getDocumentElement())).removeEventListener("DOMSubtreeModified", this, true);
        }
    }

    public boolean isBlueprint() {
        return this.schemaType != null && this.schemaType.equals((Object)CamelSchemaType.BLUEPRINT);
    }

    public boolean isSpring() {
        return this.schemaType != null && this.schemaType.equals((Object)CamelSchemaType.SPRING);
    }

    @Override
    public CamelFile getCamelFile() {
        return this;
    }

    public boolean isEmpty() {
        return this.getCamelContext() == null && this.getChildElements().isEmpty();
    }

    public String getDocumentAsXML() {
        try {
            int lineWidth = Integer.parseInt(XMLCorePlugin.getDefault().getPluginPreferences().getString("lineWidth"));
            int indentValue = XMLCorePlugin.getDefault().getPluginPreferences().getInt("indentationSize");
            String indentChar = XMLCorePlugin.getDefault().getPluginPreferences().getString("indentationChar");
            if (indentChar.equalsIgnoreCase("tab")) {
                int tabWidth = EditorsPlugin.getDefault().getPreferenceStore().getInt("tabWidth");
                indentValue *= tabWidth;
            }
            Document document = this.getDocument();
            OutputFormat format = new OutputFormat(document);
            format.setIndenting(true);
            format.setIndent(indentValue);
            format.setEncoding("UTF-8");
            format.setPreserveEmptyAttributes(false);
            format.setMethod("xml");
            format.setPreserveSpace(false);
            format.setOmitComments(false);
            format.setOmitDocumentType(false);
            format.setOmitXMLDeclaration(false);
            format.setLineWidth(lineWidth);
            StringWriter out = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Writer)out, format);
            serializer.serialize(document);
            return ((Object)out).toString();
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to save the camel file to " + this.getResource().getFullPath().toOSString(), (Throwable)ex);
            return null;
        }
    }

    public void addModelListener(ICamelModelListener listener) {
        if (!this.modelListeners.contains(listener)) {
            this.modelListeners.add(listener);
        }
    }

    public void removeModelListener(ICamelModelListener listener) {
        if (this.modelListeners.contains(listener)) {
            this.modelListeners.remove(listener);
        }
    }

    public void fireModelChanged() {
        for (ICamelModelListener listener : this.modelListeners) {
            if (listener == null) continue;
            listener.modelChanged();
        }
    }

    @Override
    public CamelContextElement getCamelContext() {
        for (AbstractCamelModelElement e : this.getChildElements()) {
            String translatedNodeName = e.getTranslatedNodeName();
            if (!CAMEL_CONTEXT.equalsIgnoreCase(translatedNodeName) && !CAMEL_ROUTES.equalsIgnoreCase(translatedNodeName)) continue;
            return (CamelContextElement)e;
        }
        return null;
    }

    @Override
    public boolean supportsBreakpoint() {
        return false;
    }

    @Override
    public void handleEvent(Event evt) {
        this.fireModelChanged();
    }
}

