/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModelFactory;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.catalog.components.ComponentProperty;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.foundation.core.util.IOUtils;
import org.fusesource.ide.foundation.core.util.JsonHelper;
import org.fusesource.ide.foundation.core.util.Strings;
import org.jboss.dmr.ModelNode;

public final class CamelComponentUtils {
    private static HashMap<String, Component> knownComponents = new HashMap();

    public static Component getComponentModel(String protocol, IProject project) {
        String componentClass = CamelComponentUtils.getComponentClass(protocol, project);
        if (knownComponents.containsKey(componentClass)) {
            return knownComponents.get(componentClass);
        }
        Component c = CamelComponentUtils.buildModelForComponent(protocol, componentClass, project);
        if (c != null) {
            knownComponents.put(componentClass, c);
            return CamelComponentUtils.getComponentModel(protocol, project);
        }
        return null;
    }

    public static String[] getRefs(CamelFile cf) {
        ArrayList<String> refs = new ArrayList<String>();
        refs.add("");
        refs.addAll(Arrays.asList(cf.getCamelFile().getGlobalDefinitions().keySet().toArray(new String[cf.getCamelFile().getGlobalDefinitions().keySet().size()])));
        CamelContextElement camelContext = cf.getCamelContext();
        if (camelContext != null) {
            refs.addAll(Arrays.asList(camelContext.getEndpointDefinitions().keySet().toArray(new String[camelContext.getEndpointDefinitions().size()])));
            refs.addAll(Arrays.asList(camelContext.getDataformats().keySet().toArray(new String[camelContext.getDataformats().size()])));
        }
        return refs.toArray(new String[refs.size()]);
    }

    public static boolean isRefProperty(Parameter p) {
        return p.getName().equalsIgnoreCase("ref") && p.getType().equalsIgnoreCase("string") && p.getJavaType().equalsIgnoreCase("java.lang.String") && p.getKind().equalsIgnoreCase("attribute");
    }

    public static boolean isBooleanProperty(Parameter p) {
        return p.getJavaType().equalsIgnoreCase("boolean") || p.getJavaType().equalsIgnoreCase("java.lang.Boolean");
    }

    public static boolean isDescriptionProperty(Parameter p) {
        return p.getKind().equals("element") && p.getJavaType().equalsIgnoreCase("org.apache.camel.model.DescriptionDefinition") && p.getName().equals("description");
    }

    public static boolean isTextProperty(Parameter p) {
        return p.getChoice() == null && !p.getName().equalsIgnoreCase("ref") && !p.getKind().equals("expression") && (p.getJavaType().equalsIgnoreCase("String") || p.getJavaType().equalsIgnoreCase("java.lang.String") || p.getJavaType().equalsIgnoreCase("java.net.URL") || p.getJavaType().equalsIgnoreCase("java.net.URI") || p.getJavaType().equalsIgnoreCase("Text"));
    }

    public static boolean isNumberProperty(Parameter p) {
        String javaType = p.getJavaType();
        return p.getChoice() == null && (javaType.equalsIgnoreCase("int") || javaType.equalsIgnoreCase("Integer") || javaType.equalsIgnoreCase("java.lang.Integer") || javaType.equalsIgnoreCase("long") || javaType.equalsIgnoreCase("java.lang.Long") || javaType.equalsIgnoreCase("double") || javaType.equalsIgnoreCase("java.lang.Double") || javaType.equalsIgnoreCase("float") || javaType.equalsIgnoreCase("java.lang.Float") || javaType.equalsIgnoreCase("Number"));
    }

    public static boolean isChoiceProperty(Parameter p) {
        return p.getChoice() != null && p.getChoice().trim().length() > 0;
    }

    public static boolean isFileProperty(Parameter p) {
        return p.getJavaType().equalsIgnoreCase("file") || p.getJavaType().equalsIgnoreCase("java.io.file");
    }

    public static boolean isExpressionProperty(Parameter p) {
        return p.getKind().equalsIgnoreCase("expression") || p.getJavaType().equalsIgnoreCase("org.apache.camel.model.language.ExpressionDefinition");
    }

    public static boolean isDataFormatProperty(Parameter p) {
        return p.getKind().equalsIgnoreCase("element") && p.getJavaType().equalsIgnoreCase("org.apache.camel.model.DataFormatDefinition");
    }

    public static boolean isListProperty(Parameter p) {
        return p.getJavaType().toLowerCase().startsWith("java.util.list") || p.getJavaType().toLowerCase().startsWith("java.util.collection");
    }

    public static boolean isMapProperty(Parameter p) {
        return p.getJavaType().toLowerCase().startsWith("java.util.map");
    }

    public static boolean isUriPathParameter(Parameter p) {
        return p.getKind() != null && p.getKind().equalsIgnoreCase("path");
    }

    public static boolean isUriOptionParameter(Parameter p) {
        return p.getKind() != null && p.getKind().equalsIgnoreCase("parameter");
    }

    public static boolean isUnsupportedProperty(Parameter p) {
        return CamelComponentUtils.isMapProperty(p) || p.getJavaType().toLowerCase().startsWith("java.util.date");
    }

    public static String[] getChoices(Parameter p) {
        String[] choices = p.getChoice().split(",");
        ArrayList<String> res = new ArrayList<String>();
        res.add(" ");
        String[] stringArray = choices;
        int n = choices.length;
        int n2 = 0;
        while (n2 < n) {
            String choice = stringArray[n2];
            res.add(choice);
            ++n2;
        }
        return res.toArray(new String[res.size()]);
    }

    public static String[] getOneOfList(Parameter p) {
        String[] choices = p.getOneOf().split(",");
        ArrayList<String> res = new ArrayList<String>();
        res.add(" ");
        String[] stringArray = choices;
        int n = choices.length;
        int n2 = 0;
        while (n2 < n) {
            String choice = stringArray[n2];
            res.add(choice);
            ++n2;
        }
        return res.toArray(new String[res.size()]);
    }

    protected static String getComponentClass(String scheme, IProject project) {
        String compClass = null;
        String camelVersion = CamelModelFactory.getCamelVersion(project);
        ArrayList<Component> components = CamelModelFactory.getModelForVersion(camelVersion).getComponentModel().getSupportedComponents();
        for (Component c : components) {
            if (!c.supportsScheme(scheme)) continue;
            compClass = c.getClazz();
            break;
        }
        if (compClass == null) {
            try {
                ZipFile zf = null;
                ZipEntry ze = null;
                IJavaProject jpr = JavaCore.create((IProject)project);
                IClasspathEntry[] iClasspathEntryArray = jpr.getResolvedClasspath(true);
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry e = iClasspathEntryArray[n2];
                    File cpEntryFile = e.getPath().toFile();
                    if (CamelComponentUtils.isJarFile(cpEntryFile)) {
                        zf = new ZipFile(cpEntryFile);
                        ze = zf.getEntry(String.format("META-INF/services/org/apache/camel/component/%s", scheme));
                        if (ze != null) break;
                        ze = null;
                        zf = null;
                    }
                    ++n2;
                }
                if (ze != null) {
                    Properties p = new Properties();
                    p.load(zf.getInputStream(ze));
                    compClass = p.getProperty("class");
                }
            }
            catch (Exception ex) {
                CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
                compClass = null;
            }
        }
        return compClass;
    }

    protected static String getComponentJSon(String scheme, IProject project) {
        String json = null;
        try {
            ZipFile zf = null;
            ZipEntry ze = null;
            IJavaProject jpr = JavaCore.create((IProject)project);
            IClasspathEntry[] iClasspathEntryArray = jpr.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry e = iClasspathEntryArray[n2];
                File cpEntryFile = e.getPath().toFile();
                if (CamelComponentUtils.isJarFile(cpEntryFile)) {
                    zf = new ZipFile(cpEntryFile);
                    ze = zf.getEntry(String.format("META-INF/services/org/apache/camel/component/%s", scheme));
                    if (ze != null) break;
                    ze = null;
                    zf = null;
                }
                ++n2;
            }
            if (ze != null) {
                Properties p = new Properties();
                p.load(zf.getInputStream(ze));
                String compClass = p.getProperty("class");
                String packageName = compClass.substring(0, compClass.lastIndexOf("."));
                String folder = packageName.replaceAll("\\.", "/");
                ze = zf.getEntry(String.format("%s/%s.json", folder, scheme));
                if (ze != null) {
                    json = IOUtils.loadText((InputStream)zf.getInputStream(ze), null);
                }
            }
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            json = null;
        }
        return json;
    }

    private static boolean isJarFile(File f) {
        return f.isFile() && f.getName().toLowerCase().endsWith(".jar");
    }

    protected static Component buildModelForComponent(String scheme, String clazz, IProject project) {
        Component resModel = null;
        String camelVersion = CamelModelFactory.getCamelVersion(project);
        resModel = CamelModelFactory.getModelForVersion(camelVersion).getComponentModel().getComponentForScheme(scheme);
        if (resModel == null) {
            resModel = CamelComponentUtils.buildModelFromJSON(scheme, CamelComponentUtils.getComponentJSon(scheme, project), clazz);
        }
        if (resModel == null && scheme.equalsIgnoreCase("activemq")) {
            return CamelModelFactory.getModelForVersion(camelVersion).getComponentModel().getComponentForScheme("jms").duplicateFor(scheme, clazz);
        }
        return resModel;
    }

    protected static Component buildModelFromJSON(String scheme, String oJSONBlob, String clazz) {
        Component resModel = null;
        try {
            if (oJSONBlob != null) {
                resModel = CamelComponentUtils.buildModelFromJSonBlob(oJSONBlob, clazz);
                resModel.setScheme(scheme);
                CamelComponentUtils.saveModel(resModel);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
        }
        return resModel;
    }

    private static void saveModel(Component component) {
        knownComponents.put(component.getClazz(), component);
    }

    public static URLClassLoader getProjectClassLoader(IProject project) {
        try {
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            IPackageFragmentRoot[] pfroots = javaProject.getAllPackageFragmentRoots();
            ArrayList<URL> urls = new ArrayList<URL>();
            IPackageFragmentRoot[] iPackageFragmentRootArray = pfroots;
            int n = pfroots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                URL rUrl = root.getPath().toFile().toURI().toURL();
                urls.add(rUrl);
                ++n2;
            }
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), CamelComponentUtils.class.getClassLoader());
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            return null;
        }
    }

    protected static Component buildModelFromJSonBlob(String json, String clazz) {
        Component resModel = new Component();
        resModel.setClazz(clazz);
        try {
            ModelNode model = JsonHelper.getModelNode((String)json);
            ModelNode componentNode = model.get("component");
            Map props = JsonHelper.getAsMap((ModelNode)componentNode);
            Iterator it = props.keySet().iterator();
            String grpId = null;
            String artId = null;
            String ver = null;
            while (it.hasNext()) {
                String propName = (String)it.next();
                ModelNode valueNode = componentNode.get(propName);
                if (propName.equals("kind")) {
                    resModel.setKind(valueNode.asString());
                    continue;
                }
                if (propName.equals("scheme")) {
                    resModel.setScheme(valueNode.asString());
                    continue;
                }
                if (propName.equals("syntax")) {
                    resModel.setSyntax(valueNode.asString());
                    continue;
                }
                if (propName.equals("title")) {
                    resModel.setTitle(valueNode.asString());
                    continue;
                }
                if (propName.equals("description")) {
                    resModel.setDescription(valueNode.asString());
                    continue;
                }
                if (propName.equals("label")) {
                    ArrayList<String> al = new ArrayList<String>();
                    al.addAll(Arrays.asList(valueNode.asString().split(",")));
                    resModel.setTags(al);
                    continue;
                }
                if (propName.equals("consumerOnly")) {
                    resModel.setConsumerOnly(valueNode.asString());
                    continue;
                }
                if (propName.equals("producerOnly")) {
                    resModel.setProducerOnly(valueNode.asString());
                    continue;
                }
                if (propName.equals("javaType")) {
                    resModel.setClazz(valueNode.asString());
                    continue;
                }
                if (propName.equals("groupId")) {
                    grpId = valueNode.asString();
                    continue;
                }
                if (propName.equals("artifactId")) {
                    artId = valueNode.asString();
                    continue;
                }
                if (!propName.equals("version")) continue;
                ver = valueNode.asString();
            }
            if (!(Strings.isBlank(grpId) || Strings.isBlank(artId) || Strings.isBlank(ver))) {
                ArrayList<Dependency> depList = new ArrayList<Dependency>();
                Dependency dep = new Dependency();
                dep.setGroupId(grpId);
                dep.setArtifactId(artId);
                dep.setVersion(ver);
                depList.add(dep);
                resModel.setDependencies(depList);
            }
            ArrayList<ComponentProperty> cProps = new ArrayList<ComponentProperty>();
            ModelNode componentPropertiesNode = model.get("componentProperties");
            Map cprops = JsonHelper.getAsMap((ModelNode)componentPropertiesNode);
            it = cprops.keySet().iterator();
            while (it.hasNext()) {
                ComponentProperty cp = new ComponentProperty();
                String propName = (String)it.next();
                ModelNode valueNode = componentNode.get(propName);
                if (propName.equals("defaultValue")) {
                    cp.setDefaultValue(valueNode.asString());
                } else if (propName.equals("deprecated")) {
                    cp.setDeprecated(valueNode.asString());
                } else if (propName.equals("description")) {
                    cp.setDescription(valueNode.asString());
                } else if (propName.equals("javaType")) {
                    cp.setJavaType(valueNode.asString());
                } else if (propName.equals("kind")) {
                    cp.setKind(valueNode.asString());
                } else if (propName.equals("name")) {
                    cp.setName(valueNode.asString());
                } else if (propName.equals("type")) {
                    cp.setType(valueNode.asString());
                }
                cProps.add(cp);
            }
            resModel.setComponentProperties(cProps);
            ModelNode propsNode = model.get("properties");
            props = JsonHelper.getAsMap((ModelNode)propsNode);
            it = props.keySet().iterator();
            ArrayList<Parameter> uriParams = new ArrayList<Parameter>();
            while (it.hasNext()) {
                String propName = (String)it.next();
                ModelNode valueNode = propsNode.get(propName);
                Parameter param = new Parameter();
                param.setName(propName);
                if (valueNode.hasDefined("choice")) {
                    param.setChoice(valueNode.get("choice").asString());
                }
                if (valueNode.hasDefined("defaultValue")) {
                    param.setDefaultValue(valueNode.get("defaultValue").asString());
                }
                if (valueNode.hasDefined("deprecated")) {
                    param.setDeprecated(valueNode.get("deprecated").asString());
                }
                if (valueNode.hasDefined("description")) {
                    param.setDescription(valueNode.get("description").asString());
                }
                if (valueNode.hasDefined("javaType")) {
                    param.setJavaType(valueNode.get("javaType").asString());
                }
                if (valueNode.hasDefined("kind")) {
                    param.setKind(valueNode.get("kind").asString());
                }
                if (valueNode.hasDefined("label")) {
                    param.setLabel(valueNode.get("label").asString());
                }
                if (valueNode.hasDefined("name")) {
                    param.setName(valueNode.get("name").asString());
                }
                if (valueNode.hasDefined("required")) {
                    param.setRequired(valueNode.get("required").asString());
                }
                if (valueNode.hasDefined("type")) {
                    param.setType(valueNode.get("type").asString());
                }
                uriParams.add(param);
            }
            resModel.setUriParameters(uriParams);
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            resModel = null;
        }
        return resModel;
    }
}

