/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.fusesource.ide.foundation.core.util.IOUtils;

public class CamelFileTemplateCreator {
    public void createSpringTemplateFile(IFile f) {
        File file = f.getRawLocation().makeAbsolute().toFile();
        this.createSpringTemplateFile(file);
    }

    public void createBlueprintTemplateFile(IFile f) {
        File file = f.getRawLocation().makeAbsolute().toFile();
        this.createBlueprintTemplateFile(file);
    }

    public void createRoutesTemplateFile(IFile f) {
        File file = f.getRawLocation().makeAbsolute().toFile();
        this.createRoutesTemplateFile(file);
    }

    public void createSpringTemplateFile(File f) {
        this.createTemplateFile(f, this.getSpringStubText());
    }

    public void createBlueprintTemplateFile(File f) {
        this.createTemplateFile(f, this.getBlueprintStubText());
    }

    public void createRoutesTemplateFile(File f) {
        this.createTemplateFile(f, this.getRoutesStubText());
    }

    private void createTemplateFile(File f, String content) {
        if (f == null) {
            throw new IllegalArgumentException("The given file parameter can't be null.");
        }
        if (f.isDirectory()) {
            throw new IllegalArgumentException("The given file parameter can't be a folder.");
        }
        if (f.exists() && f.isFile()) {
            f.delete();
        }
        try {
            if (f.createNewFile()) {
                IOUtils.writeText((File)f, (String)content);
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("An error occured creating the template file...", ex);
        }
    }

    String getSpringStubText() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<beans xmlns=\"http://www.springframework.org/schema/beans\"\n");
        sb.append("       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd        http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd\">\n");
        sb.append("   <camelContext id=\"camelContext1\" xmlns=\"http://camel.apache.org/schema/spring\">\n");
        sb.append("   </camelContext>\n");
        sb.append("</beans>\n");
        return sb.toString();
    }

    String getBlueprintStubText() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<blueprint xmlns=\"http://www.osgi.org/xmlns/blueprint/v1.0.0\"\n");
        sb.append("\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        sb.append("\t\t       xsi:schemaLocation=\"\n");
        sb.append("       http://www.osgi.org/xmlns/blueprint/v1.0.0 https://www.osgi.org/xmlns/blueprint/v1.0.0/blueprint.xsd\n");
        sb.append("       http://camel.apache.org/schema/blueprint http://camel.apache.org/schema/blueprint/camel-blueprint.xsd\">\n");
        sb.append("\n");
        sb.append("\t<camelContext id=\"context1\" xmlns=\"http://camel.apache.org/schema/blueprint\">\n");
        sb.append("\n");
        sb.append("\t</camelContext>\n");
        sb.append("\n");
        sb.append("</blueprint>\n");
        return sb.toString();
    }

    String getRoutesStubText() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<routes xmlns=\"http://camel.apache.org/schema/spring\">\n");
        sb.append("</routes>\n");
        return sb.toString();
    }
}

