/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.camel;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModelFactory;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.io.CamelIOHandler;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBasicModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelEndpoint;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.jboss.tools.fuse.transformation.core.TransformType;
import org.jboss.tools.fuse.transformation.core.camel.EndpointHelper;

public class CamelConfigBuilder {
    private CamelFile model;

    public CamelConfigBuilder() {
        this.model = null;
    }

    public CamelConfigBuilder(File file) {
        this.model = new CamelIOHandler().loadCamelModel(file, (IProgressMonitor)new NullProgressMonitor());
    }

    public CamelFile getModel() {
        if (this.model != null) {
            return this.model;
        }
        return CamelUtils.getDiagramEditor().getModel();
    }

    public AbstractCamelModelElement createDataFormat(TransformType type, String className, MarshalType marshalType) throws Exception {
        AbstractCamelModelElement dataFormat = null;
        switch (type) {
            case JSON: {
                dataFormat = MarshalType.UNMARSHALLER.equals((Object)marshalType) ? this.createJsonDataFormat(className) : this.createJsonDataFormat(null);
                break;
            }
            case XML: {
                dataFormat = this.createJaxbDataFormat(this.getPackage(className));
                break;
            }
            case JAVA: 
            case OTHER: {
                dataFormat = null;
                break;
            }
            default: {
                throw new Exception("Unsupported data format type: " + (Object)((Object)type));
            }
        }
        return dataFormat;
    }

    public AbstractCamelModelElement createEndpoint(String transformId, String dozerConfigPath, String sourceClass, String targetClass, AbstractCamelModelElement unmarshaller, AbstractCamelModelElement marshaller) {
        String unmarshallerId = unmarshaller != null ? unmarshaller.getId() : null;
        String marshallerId = marshaller != null ? marshaller.getId() : null;
        String endpointUri = EndpointHelper.createEndpointUri(dozerConfigPath, transformId, sourceClass, targetClass, unmarshallerId, marshallerId);
        return this.addEndpoint(transformId, endpointUri);
    }

    public void addTransformation(String transformId, String dozerConfigPath, TransformType source, String sourceClass, TransformType target, String targetClass) throws Exception {
        AbstractCamelModelElement unmarshaller = this.createDataFormat(source, sourceClass, MarshalType.UNMARSHALLER);
        AbstractCamelModelElement marshaller = this.createDataFormat(target, targetClass, MarshalType.MARSHALLER);
        String unmarshallerId = unmarshaller != null ? unmarshaller.getId() : null;
        String marshallerId = marshaller != null ? marshaller.getId() : null;
        String endpointUri = EndpointHelper.createEndpointUri(dozerConfigPath, transformId, sourceClass, targetClass, unmarshallerId, marshallerId);
        this.addEndpoint(transformId, endpointUri);
    }

    public AbstractCamelModelElement getEndpoint(String endpointId) {
        AbstractCamelModelElement endpoint = null;
        for (AbstractCamelModelElement ep : this.getEndpoints()) {
            if (!endpointId.equals(ep.getId())) continue;
            endpoint = ep;
            break;
        }
        return endpoint;
    }

    public List<String> getTransformEndpointIds() {
        LinkedList<String> endpointIds = new LinkedList<String>();
        for (AbstractCamelModelElement ep : this.getEndpoints()) {
            if (!((String)ep.getParameter("uri")).startsWith(EndpointHelper.DOZER_SCHEME)) continue;
            endpointIds.add(ep.getId());
        }
        return endpointIds;
    }

    public AbstractCamelModelElement getDataFormat(String id) {
        AbstractCamelModelElement dataFormat = null;
        for (AbstractCamelModelElement df : this.getDataFormats()) {
            if (!id.equals(df.getId())) continue;
            dataFormat = df;
            break;
        }
        return dataFormat;
    }

    public Collection<AbstractCamelModelElement> getDataFormats() {
        return this.getModel().getCamelContext().getDataformats().values();
    }

    public Collection<AbstractCamelModelElement> getEndpoints() {
        return this.getModel().getCamelContext().getEndpointDefinitions().values();
    }

    protected AbstractCamelModelElement addEndpoint(String id, String uri) {
        CamelContextElement parent = this.getModel().getCamelContext();
        CamelEndpoint ep = new CamelEndpoint(uri);
        ep.setId(id);
        ep.setParent((AbstractCamelModelElement)parent);
        ep.setUnderlyingMetaModelObject(this.getEipByName("from"));
        this.getModel().getCamelContext().addEndpointDefinition((AbstractCamelModelElement)ep);
        return ep;
    }

    protected String getPackage(String type) {
        int idx = type.lastIndexOf(46);
        return idx > 0 ? type.substring(0, idx) : type;
    }

    protected AbstractCamelModelElement createJsonDataFormat(String className) throws Exception {
        String id = className != null ? className.replaceAll("\\.", "") : "transform-json";
        Eip json = this.getEipByName("json");
        AbstractCamelModelElement dataFormat = this.getDataFormat(id);
        if (dataFormat == null) {
            CamelContextElement parent = this.getModel().getCamelContext();
            dataFormat = new CamelBasicModelElement((AbstractCamelModelElement)parent, null);
            dataFormat.setId(id);
            dataFormat.setUnderlyingMetaModelObject(json);
            dataFormat.setParameter("library", (Object)"Jackson");
            dataFormat.setParameter("unmarshalTypeName", (Object)className);
            parent.getCamelContext().addDataFormat(dataFormat);
        }
        return dataFormat;
    }

    protected AbstractCamelModelElement createJaxbDataFormat(String contextPath) throws Exception {
        String id = contextPath.replaceAll("\\.", "");
        Eip jaxb = this.getEipByName("jaxb");
        AbstractCamelModelElement dataFormat = this.getDataFormat(id);
        if (dataFormat == null) {
            CamelContextElement parent = this.getModel().getCamelContext();
            dataFormat = new CamelBasicModelElement((AbstractCamelModelElement)parent, null);
            dataFormat.setId(id);
            dataFormat.setUnderlyingMetaModelObject(jaxb);
            dataFormat.setParameter("contextPath", (Object)contextPath);
            parent.getCamelContext().addDataFormat(dataFormat);
        }
        return dataFormat;
    }

    public Eip getEipByName(String name) {
        CamelModel model;
        IResource resource = this.getModel().getResource();
        String camelVersion = null;
        if (resource != null) {
            camelVersion = CamelModelFactory.getCamelVersion((IProject)resource.getProject());
        }
        if (camelVersion == null) {
            camelVersion = CamelModelFactory.getLatestCamelVersion();
        }
        if ((model = CamelModelFactory.getModelForVersion((String)camelVersion)) == null) {
            return null;
        }
        Eip eip = model.getEipModel().getEIPByName(name);
        return eip;
    }

    public static enum MarshalType {
        MARSHALLER,
        UNMARSHALLER;

    }
}

