/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.dozer;

import java.util.List;
import org.jboss.tools.fuse.transformation.core.dozer.DozerUtil;
import org.jboss.tools.fuse.transformation.core.dozer.config.Field;
import org.jboss.tools.fuse.transformation.core.dozer.config.FieldDefinition;
import org.jboss.tools.fuse.transformation.core.dozer.config.Mapping;
import org.jboss.tools.fuse.transformation.core.model.Model;

public abstract class BaseDozerMapping {
    private Mapping mapping;
    private Field field;

    protected BaseDozerMapping(Mapping mapping, Field field) {
        this.mapping = mapping;
        this.field = field;
    }

    public void delete() {
        this.mapping.getFieldOrFieldExclude().remove(this.field);
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public Field getField() {
        return this.field;
    }

    public List<Integer> getSourceIndex() {
        return DozerUtil.getFieldIndexes(this.field.getA().getContent());
    }

    public List<Integer> getTargetIndex() {
        return DozerUtil.getFieldIndexes(this.field.getB().getContent());
    }

    public void setSourceIndex(List<Integer> indexes) {
        throw new UnsupportedOperationException("setSourceIndex not supported for mappings of type " + this.getClass().getSimpleName());
    }

    public void setTargetIndex(List<Integer> indexes) {
        throw new UnsupportedOperationException("setTargetIndex not supported for mappings of type " + this.getClass().getSimpleName());
    }

    public void setFieldIndex(FieldDefinition field, Model model, String rootType, List<Integer> indexes) {
        field.setContent(DozerUtil.getFieldName(model, rootType, indexes));
    }

    public void setSourceDateFormat(String format) {
        this.field.getA().setDateFormat(format);
    }

    public String getSourceDateFormat() {
        return this.field.getA().getDateFormat();
    }

    public void setTargetDateFormat(String format) {
        this.field.getB().setDateFormat(format);
    }

    public String getTargetDateFormat() {
        return this.field.getB().getDateFormat();
    }
}

