/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.dozer;

import java.util.Arrays;
import org.jboss.tools.fuse.transformation.core.MappingType;
import org.jboss.tools.fuse.transformation.core.TransformationMapping;
import org.jboss.tools.fuse.transformation.core.dozer.DozerFieldMapping;
import org.jboss.tools.fuse.transformation.core.dozer.TransformationArgumentHelper;

public class DozerTransformationMapping
extends DozerFieldMapping
implements TransformationMapping {
    private static final String SEP = ",";

    public DozerTransformationMapping(DozerFieldMapping fieldMapping) {
        super(fieldMapping.getSource(), fieldMapping.getTarget(), fieldMapping.getMapping(), fieldMapping.getField());
    }

    @Override
    public void addTransformationArgument(String type, String value) {
        String[] parts = TransformationArgumentHelper.getArgumentParts(this.getField(), SEP);
        StringBuilder builder = new StringBuilder(parts.length > 0 ? parts[0] : "");
        builder.append(SEP);
        builder.append(parts.length > 1 ? parts[1] : "");
        int ndx = 2;
        while (ndx < parts.length) {
            builder.append(SEP);
            builder.append(parts[ndx]);
            ++ndx;
        }
        builder.append(SEP);
        builder.append(TransformationArgumentHelper.emptyForNull(type));
        builder.append("=");
        builder.append(TransformationArgumentHelper.emptyForNull(value));
        this.getField().setCustomConverterArgument(builder.toString());
    }

    @Override
    public void addTransformationArguments(String ... arguments) {
        String[] parts = TransformationArgumentHelper.getArgumentParts(this.getField(), SEP);
        StringBuilder builder = new StringBuilder(parts.length > 0 ? parts[0] : "");
        builder.append(SEP);
        builder.append(parts.length > 1 ? parts[1] : "");
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            builder.append(SEP);
            builder.append(arg);
            ++n2;
        }
        this.getField().setCustomConverterArgument(builder.toString());
    }

    @Override
    public String[] getTransformationArguments() {
        String[] parts = TransformationArgumentHelper.getArgumentParts(this.getField(), SEP);
        return parts.length < 2 ? TransformationArgumentHelper.EMPTY_STRING_ARRAY : Arrays.copyOfRange(parts, 2, parts.length);
    }

    @Override
    public String getTransformationClass() {
        return TransformationArgumentHelper.getArgumentPart(this.getField(), SEP, 0);
    }

    @Override
    public String getTransformationName() {
        return TransformationArgumentHelper.getArgumentPart(this.getField(), SEP, 1);
    }

    @Override
    public MappingType getType() {
        return MappingType.TRANSFORMATION;
    }

    @Override
    public void setTransformationClass(String name) {
        String[] parts = TransformationArgumentHelper.getArgumentParts(this.getField(), SEP);
        StringBuilder builder = new StringBuilder(TransformationArgumentHelper.emptyForNull(name));
        builder.append(SEP);
        builder.append(parts.length > 1 ? parts[1] : "");
        int ndx = 2;
        while (ndx < parts.length) {
            builder.append(SEP);
            builder.append(parts[ndx]);
            ++ndx;
        }
        this.getField().setCustomConverterArgument(builder.toString());
    }

    @Override
    public void setTransformationName(String name) {
        String[] parts = TransformationArgumentHelper.getArgumentParts(this.getField(), SEP);
        StringBuilder builder = new StringBuilder(parts.length > 0 ? parts[0] : "");
        builder.append(SEP);
        builder.append(TransformationArgumentHelper.emptyForNull(name));
        int ndx = 2;
        while (ndx < parts.length) {
            builder.append(SEP);
            builder.append(parts[ndx]);
            ++ndx;
        }
        this.getField().setCustomConverterArgument(builder.toString());
    }
}

