/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.dozer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.fuse.transformation.core.model.Model;

public final class DozerUtil {
    private static final Pattern INDEX_PATTERN = Pattern.compile("\\[[0-9]+\\]");

    public static List<Integer> getFieldIndexes(String fieldVal) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (fieldVal != null) {
            String[] stringArray = fieldVal.split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = stringArray[n2];
                indices.add(DozerUtil.getIndex(fieldName));
                ++n2;
            }
        }
        return indices;
    }

    public static String removeIndexes(String fieldVal) {
        return fieldVal != null && fieldVal.indexOf(91) > 0 ? fieldVal.replaceAll(INDEX_PATTERN.pattern(), "") : fieldVal;
    }

    public static String getFieldName(Model model, String rootType) {
        return DozerUtil.getFieldName(model, rootType, DozerUtil.noIndex(model));
    }

    public static String getFieldName(Model model, String rootType, List<Integer> indexes) {
        int depth = DozerUtil.numberOfNodes(model);
        if (depth != indexes.size()) {
            throw new IllegalArgumentException("Size of index list " + indexes.size() + "does not match depth of model tree " + depth);
        }
        ArrayList<Integer> reversedIndex = new ArrayList<Integer>(indexes.size());
        reversedIndex.addAll(indexes);
        Collections.reverse(reversedIndex);
        Iterator indexItr = reversedIndex.iterator();
        StringBuilder name = new StringBuilder(DozerUtil.formatName(model.getName(), (Integer)indexItr.next()));
        Model parent = model.getParent();
        while (parent != null) {
            if (parent.getType().equals(rootType)) break;
            Integer parentIdx = (Integer)indexItr.next();
            if (parent.isCollection() && parentIdx == null) break;
            name.insert(0, String.valueOf(DozerUtil.formatName(parent.getName(), parentIdx)) + ".");
            parent = parent.getParent();
        }
        return name.toString();
    }

    public static Integer getIndex(String fieldName) {
        Matcher matcher = INDEX_PATTERN.matcher(fieldName);
        if (matcher.find()) {
            String indexStr = matcher.group();
            return Integer.valueOf(indexStr.substring(1, indexStr.length() - 1));
        }
        return null;
    }

    static String formatName(String name, Integer index) {
        return index != null ? String.valueOf(name) + "[" + index + "]" : name;
    }

    public static int numberOfNodes(Model model) {
        int nodes = 0;
        Model m = model.getParent();
        while (m != null) {
            ++nodes;
            m = m.getParent();
        }
        return nodes;
    }

    public static List<Integer> noIndex(Model model) {
        Object[] indexes = new Integer[DozerUtil.numberOfNodes(model)];
        Arrays.fill(indexes, null);
        return Arrays.asList(indexes);
    }
}

