/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.dozer;

import java.util.List;
import org.jboss.tools.fuse.transformation.core.MappingType;
import org.jboss.tools.fuse.transformation.core.Variable;
import org.jboss.tools.fuse.transformation.core.VariableMapping;
import org.jboss.tools.fuse.transformation.core.dozer.BaseDozerMapping;
import org.jboss.tools.fuse.transformation.core.dozer.config.Field;
import org.jboss.tools.fuse.transformation.core.dozer.config.Mapping;
import org.jboss.tools.fuse.transformation.core.model.Model;

public class DozerVariableMapping
extends BaseDozerMapping
implements VariableMapping {
    private Variable source;
    private Model target;

    public DozerVariableMapping(Variable source, Model target, Mapping mapping, Field field) {
        super(mapping, field);
        this.source = source;
        this.target = target;
    }

    @Override
    public Variable getSource() {
        return this.source;
    }

    @Override
    public Model getTarget() {
        return this.target;
    }

    @Override
    public MappingType getType() {
        return MappingType.VARIABLE;
    }

    public static String unqualifyName(String variableName) {
        return DozerVariableMapping.isQualified(variableName) ? variableName.substring(2, variableName.length() - 1) : variableName;
    }

    public static String qualifyName(String variableName) {
        return !DozerVariableMapping.isQualified(variableName) ? "${" + variableName + "}" : variableName;
    }

    public static boolean isQualified(String variableName) {
        return variableName.startsWith("${") && variableName.endsWith("}");
    }

    @Override
    public void setVariable(Variable variable) {
        this.source = variable;
        this.getField().setCustomConverterArgument(DozerVariableMapping.qualifyName(variable.getName()));
    }

    @Override
    public void setTargetIndex(List<Integer> indexes) {
        this.setFieldIndex(this.getField().getB(), this.target, this.getMapping().getClassB().getContent(), indexes);
    }
}

