/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.model.json;

import com.sun.codemodel.JCodeModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import org.jboss.tools.fuse.transformation.core.model.json.JsonGenerationConfig;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SourceType;
import org.jsonschema2pojo.rules.RuleFactory;

public class JsonModelGenerator {
    private final JsonGenerationConfig config;

    public JsonModelGenerator() {
        this(new JsonGenerationConfig());
    }

    public JsonModelGenerator(JsonGenerationConfig config) {
        this.config = config;
    }

    public JCodeModel generateFromSchema(String className, String packageName, URL schemaUrl, File targetPath) throws Exception {
        return this.generate(className, packageName, schemaUrl, targetPath);
    }

    public JCodeModel generateFromInstance(String className, String packageName, URL instanceUrl, File targetPath) throws Exception {
        this.config.setSourceType(SourceType.JSON);
        return this.generate(className, packageName, instanceUrl, targetPath);
    }

    private JCodeModel generate(String className, String packageName, URL inputUrl, File targetPath) throws Exception {
        SchemaMapper mapper = this.createSchemaMapper();
        JCodeModel codeModel = new JCodeModel();
        mapper.generate(codeModel, className, packageName, inputUrl);
        Throwable throwable = null;
        Object var8_9 = null;
        try (PrintStream status = new PrintStream(new ByteArrayOutputStream());){
            codeModel.build(targetPath, status);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return codeModel;
    }

    private SchemaMapper createSchemaMapper() {
        RuleFactory ruleFactory = new RuleFactory();
        ruleFactory.setAnnotator((Annotator)new Jackson2Annotator(){

            public boolean isAdditionalPropertiesSupported() {
                return false;
            }
        });
        ruleFactory.setGenerationConfig((GenerationConfig)this.config);
        return new SchemaMapper(ruleFactory, new SchemaGenerator());
    }
}

