/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpmn2.component;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMFactory;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMImplementationType;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMOperationType;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMPackage;
import org.switchyard.tools.models.switchyard1_0.bpm.ContainerType;
import org.switchyard.tools.models.switchyard1_0.bpm.ManifestType;
import org.switchyard.tools.models.switchyard1_0.bpm.OperationsType;
import org.switchyard.tools.models.switchyard1_0.bpm.PropertiesType;
import org.switchyard.tools.models.switchyard1_0.bpm.RemoteJmsType;
import org.switchyard.tools.models.switchyard1_0.bpm.RemoteRestType;
import org.switchyard.tools.models.switchyard1_0.bpm.ResourcesType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.bpmn2.Messages;
import org.switchyard.tools.ui.bpmn2.component.BPMActionTable;
import org.switchyard.tools.ui.bpmn2.component.BPMChannelTable;
import org.switchyard.tools.ui.bpmn2.component.BPMEventListenerTable;
import org.switchyard.tools.ui.bpmn2.component.BPMLoggerTable;
import org.switchyard.tools.ui.bpmn2.component.BPMMappingsTable;
import org.switchyard.tools.ui.bpmn2.component.BPMPropertyTable;
import org.switchyard.tools.ui.bpmn2.component.BPMResourceTable;
import org.switchyard.tools.ui.bpmn2.component.BPMTaskHandlerTable;
import org.switchyard.tools.ui.bpmn2.component.BPMUserGroupCallbackPropertyTable;
import org.switchyard.tools.ui.bpmn2.component.KIEContainerDetailsComposite;
import org.switchyard.tools.ui.bpmn2.component.RemoteJMSContainerDetailsComposite;
import org.switchyard.tools.ui.bpmn2.component.RemoteRestContainerDetailsComposite;
import org.switchyard.tools.ui.editor.diagram.shared.PropertiesFileLoadDialog;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class BPMImplementationComposite
extends AbstractModelComposite<Component> {
    private Composite _panel;
    private Text _processIDText;
    private Button _persistentButton;
    private Button _resourcesRadio;
    private Button _containerRadio;
    private Button _remoteJMSRadio;
    private Button _remoteRESTRadio;
    private StackLayout _manifestLayout;
    private BPMResourceTable _resourcesTable;
    private KIEContainerDetailsComposite _containerDetailsControls;
    private RemoteJMSContainerDetailsComposite _remoteJMSContainerDetailsControls;
    private RemoteRestContainerDetailsComposite _remoteRestContainerDetailsControls;
    private BPMActionTable _actionsTable;
    private BPMMappingsTable _inputsTable;
    private BPMMappingsTable _outputsTable;
    private BPMMappingsTable _globalsTable;
    private BPMMappingsTable _faultsTable;
    private BPMPropertyTable _propertiesTable;
    private BPMLoggerTable _loggersTable;
    private BPMTaskHandlerTable _handlersTable;
    private BPMEventListenerTable _listenersTable;
    private BPMChannelTable _channelsTable;
    private BPMImplementationType _implementation;
    private ResourcesType _resources;
    private ContainerType _container;
    private RemoteJmsType _remoteJms;
    private RemoteRestType _remoteRest;
    private boolean _updating;
    private Text _userGroupCallbackClassText;
    private BPMUserGroupCallbackPropertyTable _userCallbackPropertiesTable;
    private Link _callbackLinkLabel;
    private Text _propFileText;

    public BPMImplementationComposite(ICompositeContainer container, Composite parent, int style) {
        super(Component.class, container, parent, style);
        FormToolkit factory = this.getWidgetFactory();
        this._panel = this;
        this._panel.setLayout((Layout)new GridLayout());
        final TabFolder folder = new TabFolder(this._panel, 128);
        factory.adapt((Composite)folder);
        folder.setLayout(new Layout(){

            protected void layout(Composite composite, boolean flushCache) {
                Rectangle rect = composite.getClientArea();
                TabItem[] selected = folder.getSelection();
                if (selected == null || selected.length == 0) {
                    return;
                }
                selected[0].getControl().setBounds(rect);
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                if (wHint != -1 && hHint != -1) {
                    return new Point(wHint, hHint);
                }
                int maxWidth = 0;
                int maxHeight = 0;
                TabItem[] selected = folder.getSelection();
                if (selected != null && selected.length > 0) {
                    Point pt = selected[0].getControl().computeSize(wHint, hHint, flushCache);
                    maxWidth = Math.max(0, pt.x);
                    maxHeight = Math.max(0, pt.y);
                }
                if (wHint != -1) {
                    maxWidth = Math.max(wHint, maxWidth);
                }
                if (hHint != -1) {
                    maxWidth = Math.max(hHint, maxHeight);
                }
                return new Point(maxWidth, maxHeight);
            }
        });
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem general = new TabItem(folder, 0);
        TabItem actions = new TabItem(folder, 0);
        TabItem advanced = new TabItem(folder, 0);
        general.setText(Messages.title_general);
        actions.setText(Messages.title_operations);
        advanced.setText(Messages.title_advanced);
        this.createGeneralControls(folder, general);
        this.createActionsControls(folder, actions);
        this.createAdvancedControls(folder, advanced);
        folder.setSelection(0);
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BPMImplementationComposite.this.getContainer().layout();
            }
        });
    }

    public void refresh() {
        BPMOperationType selectedOp = null;
        if (this._implementation != null && this._actionsTable.getTableSelection() != null) {
            selectedOp = this._actionsTable.getTableSelection();
        }
        this._implementation = null;
        Component bo = (Component)this.getTargetObject();
        if (bo != null) {
            PropertiesType properties;
            Implementation rawImpl = bo.getImplementation();
            this._implementation = rawImpl instanceof BPMImplementationType ? (BPMImplementationType)rawImpl : null;
            if (this._implementation != null && this._implementation.getManifest() != null) {
                this._resources = this._implementation.getManifest().getResources();
                this._container = this._implementation.getManifest().getContainer();
                this._remoteJms = this._implementation.getManifest().getRemoteJms();
                this._remoteRest = this._implementation.getManifest().getRemoteRest();
            }
            if (this._implementation != null && this._implementation.getProperties() != null && (properties = this._implementation.getProperties()) != null && properties.getLoad() != null) {
                this._propFileText.setText(properties.getLoad());
            }
        }
        this._updating = true;
        try {
            this._resourcesTable.setTargetObject((EObject)this._implementation);
            this._actionsTable.setTargetObject((EObject)this._implementation);
            if (selectedOp != null) {
                OperationsType ops = this._implementation.getOperations();
                if (ops != null && ops.getOperation() != null && !ops.getOperation().isEmpty()) {
                    for (BPMOperationType op : ops.getOperation()) {
                        String opName = op.getName();
                        String selectedOpName = selectedOp.getName();
                        if (opName == null || selectedOpName == null || !opName.equals(selectedOpName)) continue;
                        this._actionsTable.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)op));
                        break;
                    }
                } else {
                    this._actionsTable.getTableViewer().setSelection(null);
                }
            }
            this._propertiesTable.setTargetObject((EObject)this._implementation);
            this._loggersTable.setTargetObject((EObject)this._implementation);
            this._handlersTable.setTargetObject((EObject)this._implementation);
            this._listenersTable.setTargetObject((EObject)this._implementation);
            this._channelsTable.setTargetObject((EObject)this._implementation);
            this._userCallbackPropertiesTable.setTargetObject((EObject)this._implementation);
            if (this._implementation == null) {
                this._processIDText.setText("");
                this._persistentButton.setSelection(false);
            } else {
                this._processIDText.setText(this._implementation.getProcessId() == null ? "" : this._implementation.getProcessId());
                this._persistentButton.setSelection(this._implementation.isPersistent());
            }
            if (this._resources != null && this._container == null && this._remoteJms == null && this._remoteRest == null) {
                this._resourcesRadio.setSelection(true);
                this._containerRadio.setSelection(false);
                this._remoteJMSRadio.setSelection(false);
                this._remoteRESTRadio.setSelection(false);
                this._manifestLayout.topControl = this._resourcesTable;
                this._resourcesTable.getParent().layout();
                this._container = BPMFactory.eINSTANCE.createContainerType();
                this._remoteJms = BPMFactory.eINSTANCE.createRemoteJmsType();
                this._remoteRest = BPMFactory.eINSTANCE.createRemoteRestType();
            } else if (this._resources == null && this._container != null && this._remoteJms == null && this._remoteRest == null) {
                this._resourcesRadio.setSelection(false);
                this._containerRadio.setSelection(true);
                this._remoteJMSRadio.setSelection(false);
                this._remoteRESTRadio.setSelection(false);
                this._manifestLayout.topControl = this._containerDetailsControls;
                this._containerDetailsControls.getParent().layout();
                this._resources = BPMFactory.eINSTANCE.createResourcesType();
                this._remoteJms = BPMFactory.eINSTANCE.createRemoteJmsType();
                this._remoteRest = BPMFactory.eINSTANCE.createRemoteRestType();
            } else if (this._resources == null && this._container == null && this._remoteJms != null && this._remoteRest == null) {
                this._resourcesRadio.setSelection(false);
                this._containerRadio.setSelection(false);
                this._remoteJMSRadio.setSelection(true);
                this._remoteRESTRadio.setSelection(false);
                this._manifestLayout.topControl = this._remoteJMSContainerDetailsControls;
                this._remoteJMSContainerDetailsControls.getParent().layout();
                this._resources = BPMFactory.eINSTANCE.createResourcesType();
                this._container = BPMFactory.eINSTANCE.createContainerType();
                this._remoteRest = BPMFactory.eINSTANCE.createRemoteRestType();
            } else if (this._resources == null && this._container == null && this._remoteJms == null && this._remoteRest != null) {
                this._resourcesRadio.setSelection(false);
                this._containerRadio.setSelection(false);
                this._remoteJMSRadio.setSelection(false);
                this._remoteRESTRadio.setSelection(true);
                this._manifestLayout.topControl = this._remoteRestContainerDetailsControls;
                this._remoteRestContainerDetailsControls.getParent().layout();
                this._resources = BPMFactory.eINSTANCE.createResourcesType();
                this._container = BPMFactory.eINSTANCE.createContainerType();
                this._remoteJms = BPMFactory.eINSTANCE.createRemoteJmsType();
            } else {
                this._resourcesRadio.setSelection(true);
                this._containerRadio.setSelection(false);
                this._remoteJMSRadio.setSelection(false);
                this._remoteRESTRadio.setSelection(false);
                this._manifestLayout.topControl = this._resourcesTable;
                this._resourcesTable.getParent().layout();
                this._container = BPMFactory.eINSTANCE.createContainerType();
                this._remoteJms = BPMFactory.eINSTANCE.createRemoteJmsType();
                this._remoteRest = BPMFactory.eINSTANCE.createRemoteRestType();
            }
            this._containerDetailsControls.setContainer(this._container);
            this._remoteRestContainerDetailsControls.setRemoteREST(this._remoteRest);
            this._remoteJMSContainerDetailsControls.setRemoteJMS(this._remoteJms);
            if (this._implementation != null && this._implementation.getUserGroupCallback() != null) {
                String value = this._implementation.getUserGroupCallback().getClass_();
                if (value == null) {
                    value = "";
                }
                this._userGroupCallbackClassText.setText(value);
            }
        }
        finally {
            this._updating = false;
        }
        this.getContainer().validated(this.validate());
    }

    private void createGeneralControls(TabFolder folder, TabItem item) {
        FormToolkit factory = this.getWidgetFactory();
        Composite control = factory.createComposite((Composite)folder);
        control.setLayout((Layout)new GridLayout(2, false));
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        factory.createLabel(control, Messages.label_processId);
        this._processIDText = factory.createText(control, "", 2048);
        this._processIDText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._processIDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newValue;
                String string = newValue = BPMImplementationComposite.this._processIDText.getText().length() == 0 ? null : BPMImplementationComposite.this._processIDText.getText();
                if (!BPMImplementationComposite.this._updating && (newValue == null && BPMImplementationComposite.this._implementation.getProcessId() != null || newValue != null && !newValue.equals(BPMImplementationComposite.this._implementation.getProcessId()))) {
                    BPMImplementationComposite.this.wrapOperation(new Runnable(){

                        @Override
                        public void run() {
                            BPMImplementationComposite.this._implementation.setProcessId(newValue);
                        }
                    });
                }
            }
        });
        this._persistentButton = factory.createButton(control, Messages.label_persistent, 32);
        this._persistentButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._persistentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!BPMImplementationComposite.this._updating && BPMImplementationComposite.this._implementation.isPersistent() != BPMImplementationComposite.this._persistentButton.getSelection()) {
                    BPMImplementationComposite.this.wrapOperation(new Runnable(){

                        @Override
                        public void run() {
                            BPMImplementationComposite.this._implementation.setPersistent(BPMImplementationComposite.this._persistentButton.getSelection());
                        }
                    });
                }
            }
        });
        Section resourcesSection = factory.createSection(control, 320);
        resourcesSection.setBackgroundMode(0);
        resourcesSection.setText(Messages.label_manifest);
        resourcesSection.setLayout((Layout)new GridLayout());
        resourcesSection.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite resourcesComposite = factory.createComposite((Composite)resourcesSection);
        resourcesComposite.setLayout((Layout)new GridLayout());
        resourcesComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        resourcesSection.setClient((Control)resourcesComposite);
        Composite resourceButtonsComposite = factory.createComposite(resourcesComposite);
        resourceButtonsComposite.setLayout((Layout)new RowLayout());
        resourceButtonsComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (BPMImplementationComposite.this._resourcesRadio.getSelection()) {
                    BPMImplementationComposite.this.swapResourceControls((Control)BPMImplementationComposite.this._resourcesTable, (EObject)BPMImplementationComposite.this._resources);
                } else if (BPMImplementationComposite.this._remoteJMSRadio.getSelection()) {
                    BPMImplementationComposite.this.swapResourceControls((Control)BPMImplementationComposite.this._remoteJMSContainerDetailsControls, (EObject)BPMImplementationComposite.this._remoteJms);
                } else if (BPMImplementationComposite.this._remoteRESTRadio.getSelection()) {
                    BPMImplementationComposite.this.swapResourceControls((Control)BPMImplementationComposite.this._remoteRestContainerDetailsControls, (EObject)BPMImplementationComposite.this._remoteRest);
                } else {
                    BPMImplementationComposite.this.swapResourceControls((Control)BPMImplementationComposite.this._containerDetailsControls, (EObject)BPMImplementationComposite.this._container);
                }
            }
        };
        this._resourcesRadio = factory.createButton(resourceButtonsComposite, Messages.label_definedResources, 16);
        this._resourcesRadio.addSelectionListener((SelectionListener)radioListener);
        this._containerRadio = factory.createButton(resourceButtonsComposite, Messages.label_knowledgeContainer, 16);
        this._containerRadio.addSelectionListener((SelectionListener)radioListener);
        this._remoteJMSRadio = factory.createButton(resourceButtonsComposite, "Remote JMS", 16);
        this._remoteJMSRadio.addSelectionListener((SelectionListener)radioListener);
        this._remoteRESTRadio = factory.createButton(resourceButtonsComposite, "Remote REST", 16);
        this._remoteRESTRadio.addSelectionListener((SelectionListener)radioListener);
        Composite resourceDetailsComposite = factory.createComposite(resourcesComposite);
        this._manifestLayout = new StackLayout();
        resourceDetailsComposite.setLayout((Layout)this._manifestLayout);
        resourceDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this._resourcesTable = new BPMResourceTable(resourceDetailsComposite, 0);
        this._resourcesTable.setLayoutData(new GridData(4, 4, true, true));
        this.createContainerDetailsControls(resourceDetailsComposite);
        item.setControl((Control)control);
    }

    private void swapResourceControls(Control topControl, final EObject newResourceObject) {
        this._manifestLayout.topControl = topControl;
        topControl.getParent().layout();
        if (!this._updating) {
            ManifestType manifest = this._implementation.getManifest();
            final boolean createManifest = manifest == null;
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    if (createManifest) {
                        BPMImplementationComposite.this._implementation.setManifest(BPMFactory.eINSTANCE.createManifestType());
                    }
                    if (newResourceObject instanceof ResourcesType) {
                        BPMImplementationComposite.this._resources = (ResourcesType)newResourceObject;
                        BPMImplementationComposite.this._implementation.getManifest().setResources(BPMImplementationComposite.this._resources);
                        BPMImplementationComposite.this._implementation.getManifest().setContainer(null);
                        BPMImplementationComposite.this._implementation.getManifest().setRemoteJms(null);
                        BPMImplementationComposite.this._implementation.getManifest().setRemoteRest(null);
                    } else if (newResourceObject instanceof ContainerType) {
                        BPMImplementationComposite.this._container = (ContainerType)newResourceObject;
                        BPMImplementationComposite.this._implementation.getManifest().setContainer(BPMImplementationComposite.this._container);
                        BPMImplementationComposite.this._implementation.getManifest().setResources(null);
                        BPMImplementationComposite.this._implementation.getManifest().setRemoteJms(null);
                        BPMImplementationComposite.this._implementation.getManifest().setRemoteRest(null);
                    } else if (newResourceObject instanceof RemoteJmsType) {
                        BPMImplementationComposite.this._remoteJms = (RemoteJmsType)newResourceObject;
                        BPMImplementationComposite.this._implementation.getManifest().setRemoteJms(BPMImplementationComposite.this._remoteJms);
                        BPMImplementationComposite.this._implementation.getManifest().setResources(null);
                        BPMImplementationComposite.this._implementation.getManifest().setContainer(null);
                        BPMImplementationComposite.this._implementation.getManifest().setRemoteRest(null);
                    } else if (newResourceObject instanceof RemoteRestType) {
                        BPMImplementationComposite.this._remoteRest = (RemoteRestType)newResourceObject;
                        BPMImplementationComposite.this._implementation.getManifest().setRemoteRest(BPMImplementationComposite.this._remoteRest);
                        BPMImplementationComposite.this._implementation.getManifest().setResources(null);
                        BPMImplementationComposite.this._implementation.getManifest().setContainer(null);
                        BPMImplementationComposite.this._implementation.getManifest().setRemoteJms(null);
                    }
                }
            });
        }
    }

    private void createContainerDetailsControls(Composite parent) {
        this._containerDetailsControls = new KIEContainerDetailsComposite(parent, this.getWidgetFactory());
        this._remoteJMSContainerDetailsControls = new RemoteJMSContainerDetailsComposite(this.getContainer(), parent, 0, this.getWidgetFactory());
        this._remoteRestContainerDetailsControls = new RemoteRestContainerDetailsComposite(this.getContainer(), parent, 0, this.getWidgetFactory());
    }

    private void createActionsControls(TabFolder folder, TabItem item) {
        FormToolkit factory = this.getWidgetFactory();
        Composite control = factory.createComposite((Composite)folder);
        control.setLayout((Layout)new GridLayout(2, false));
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite actionsComposite = factory.createComposite(control);
        actionsComposite.setLayout((Layout)new GridLayout());
        actionsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Section actionsSection = factory.createSection(actionsComposite, 320);
        actionsSection.setBackgroundMode(0);
        actionsSection.setText(Messages.title_operations);
        actionsSection.setLayout((Layout)new GridLayout());
        actionsSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this._actionsTable = new BPMActionTable((Composite)actionsSection, 0);
        this._actionsTable.setLayoutData(new GridData(4, 4, true, true));
        actionsSection.setClient((Control)this._actionsTable);
        factory.adapt((Composite)this._actionsTable);
        this._actionsTable.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = event.getSelection().isEmpty() ? null : ((IStructuredSelection)event.getSelection()).getFirstElement();
                BPMImplementationComposite.this._inputsTable.setTargetObject((EObject)((BPMOperationType)selected));
                BPMImplementationComposite.this._outputsTable.setTargetObject((EObject)((BPMOperationType)selected));
                BPMImplementationComposite.this._globalsTable.setTargetObject((EObject)((BPMOperationType)selected));
                BPMImplementationComposite.this._faultsTable.setTargetObject((EObject)((BPMOperationType)selected));
                BPMImplementationComposite.this._inputsTable.setEnabled(selected != null);
                BPMImplementationComposite.this._outputsTable.setEnabled(selected != null);
                BPMImplementationComposite.this._globalsTable.setEnabled(selected != null);
                BPMImplementationComposite.this._faultsTable.setEnabled(selected != null);
            }
        });
        Composite mappingsComposite = factory.createComposite(control);
        mappingsComposite.setLayout((Layout)new GridLayout());
        mappingsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Section globalsSection = factory.createSection(mappingsComposite, 258);
        globalsSection.setBackgroundMode(0);
        globalsSection.setText(Messages.title_globals);
        globalsSection.setLayout((Layout)new GridLayout());
        globalsSection.setLayoutData((Object)new GridData(4, 4, true, false));
        globalsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BPMImplementationComposite.this.getContainer().layout();
            }
        });
        this._globalsTable = new BPMMappingsTable((Composite)globalsSection, 0, "message.content", "", BPMPackage.eINSTANCE.getBPMOperationType_Globals(), BPMPackage.eINSTANCE.getGlobalsType_Global(), Arrays.asList("from", "to"));
        this._globalsTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._globalsTable);
        globalsSection.setClient((Control)this._globalsTable);
        Section inputsSection = factory.createSection(mappingsComposite, 322);
        inputsSection.setBackgroundMode(0);
        inputsSection.setText(Messages.title_inputs);
        inputsSection.setLayout((Layout)new GridLayout());
        inputsSection.setLayoutData((Object)new GridData(4, 4, true, false));
        inputsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BPMImplementationComposite.this.getContainer().layout();
            }
        });
        this._inputsTable = new BPMMappingsTable((Composite)inputsSection, 0, false, "message.content", "Parameter", null, BPMPackage.eINSTANCE.getBPMOperationType_Inputs(), BPMPackage.eINSTANCE.getInputsType_Input(), Arrays.asList("from", "to", "output"));
        this._inputsTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._inputsTable);
        inputsSection.setClient((Control)this._inputsTable);
        Section outputsSection = factory.createSection(mappingsComposite, 322);
        outputsSection.setBackgroundMode(0);
        outputsSection.setText(Messages.title_outputs);
        outputsSection.setLayout((Layout)new GridLayout());
        outputsSection.setLayoutData((Object)new GridData(4, 4, true, false));
        outputsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BPMImplementationComposite.this.getContainer().layout();
            }
        });
        this._outputsTable = new BPMMappingsTable((Composite)outputsSection, 0, "Result", "message.content", BPMPackage.eINSTANCE.getBPMOperationType_Outputs(), BPMPackage.eINSTANCE.getOutputsType_Output(), Arrays.asList("from", "to"));
        this._outputsTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._outputsTable);
        outputsSection.setClient((Control)this._outputsTable);
        Section faultsSection = factory.createSection(mappingsComposite, 322);
        faultsSection.setBackgroundMode(0);
        faultsSection.setText(Messages.title_faults);
        faultsSection.setLayout((Layout)new GridLayout());
        faultsSection.setLayoutData((Object)new GridData(4, 4, true, false));
        faultsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BPMImplementationComposite.this.getContainer().layout();
            }
        });
        this._faultsTable = new BPMMappingsTable((Composite)faultsSection, 0, "Fault", "message.content", BPMPackage.eINSTANCE.getBPMOperationType_Faults(), BPMPackage.eINSTANCE.getFaultsType_Fault(), Arrays.asList("from", "to"));
        this._faultsTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._faultsTable);
        faultsSection.setClient((Control)this._faultsTable);
        this._inputsTable.setEnabled(false);
        this._outputsTable.setEnabled(false);
        this._globalsTable.setEnabled(false);
        this._faultsTable.setEnabled(false);
        item.setControl((Control)control);
    }

    private void createAdvancedControls(TabFolder folder, TabItem item) {
        FormToolkit factory = this.getWidgetFactory();
        Composite control = factory.createComposite((Composite)folder);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Section channelsSection = factory.createSection(control, 322);
        channelsSection.setBackgroundMode(0);
        channelsSection.setText(Messages.title_channels);
        channelsSection.setLayout((Layout)new GridLayout());
        channelsSection.setLayoutData((Object)new GridData(4, 4, true, false));
        channelsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BPMImplementationComposite.this.getContainer().layout();
            }
        });
        this._channelsTable = new BPMChannelTable((Composite)channelsSection, 0);
        this._channelsTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._channelsTable);
        channelsSection.setClient((Control)this._channelsTable);
        Section listenersSection = factory.createSection(control, 258);
        listenersSection.setBackgroundMode(0);
        listenersSection.setText(Messages.title_listeners);
        listenersSection.setLayout((Layout)new GridLayout());
        listenersSection.setLayoutData((Object)new GridData(4, 4, true, false));
        listenersSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BPMImplementationComposite.this.getContainer().layout();
            }
        });
        this._listenersTable = new BPMEventListenerTable((Composite)listenersSection, 0);
        this._listenersTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._listenersTable);
        listenersSection.setClient((Control)this._listenersTable);
        Section loggersSection = factory.createSection(control, 258);
        loggersSection.setBackgroundMode(0);
        loggersSection.setText(Messages.title_loggers);
        loggersSection.setLayout((Layout)new GridLayout());
        loggersSection.setLayoutData((Object)new GridData(4, 4, true, false));
        loggersSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BPMImplementationComposite.this.getContainer().layout();
            }
        });
        this._loggersTable = new BPMLoggerTable((Composite)loggersSection, 0);
        this._loggersTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._loggersTable);
        loggersSection.setClient((Control)this._loggersTable);
        Section propertiesSection = factory.createSection(control, 258);
        propertiesSection.setBackgroundMode(0);
        propertiesSection.setText(Messages.title_properties);
        propertiesSection.setLayout((Layout)new GridLayout());
        propertiesSection.setLayoutData((Object)new GridData(4, 4, true, false));
        propertiesSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BPMImplementationComposite.this.getContainer().layout();
            }
        });
        Composite propsComposite = new Composite((Composite)propertiesSection, 0);
        propsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 5));
        propsComposite.setLayout((Layout)new GridLayout(3, false));
        Label propFileLabel = new Label(propsComposite, 0);
        propFileLabel.setText("Properties File:");
        propFileLabel.setLayoutData((Object)new GridData());
        this._propFileText = new Text(propsComposite, 2048);
        this._propFileText.setLayoutData((Object)new GridData(4, 1, true, false));
        this._propFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BPMImplementationComposite.this.updateImplementationPropertiesLoadValue(BPMImplementationComposite.this._propFileText.getText());
                BPMImplementationComposite.this.getContainer().validated(BPMImplementationComposite.this.validate());
            }
        });
        Button propFileBrowseBtn = new Button(propsComposite, 8);
        propFileBrowseBtn.setText("...");
        propFileBrowseBtn.setLayoutData((Object)new GridData(4, 1, false, false));
        propFileBrowseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int rtn_value;
                PropertiesFileLoadDialog dialog = new PropertiesFileLoadDialog(Display.getCurrent().getActiveShell());
                if (!BPMImplementationComposite.this._propFileText.getText().isEmpty()) {
                    dialog.setPropertiesFileValue(BPMImplementationComposite.this._propFileText.getText());
                }
                if ((rtn_value = dialog.open()) == 0) {
                    String value = dialog.getPropertiesFileValue();
                    if (value == null) {
                        value = "";
                    }
                    BPMImplementationComposite.this._propFileText.setText(value);
                    BPMImplementationComposite.this.updateImplementationPropertiesLoadValue(BPMImplementationComposite.this._propFileText.getText());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._propertiesTable = new BPMPropertyTable(propsComposite, 0);
        this._propertiesTable.setLayoutData(new GridData(4, 4, true, false, 3, 5));
        factory.adapt((Composite)this._propertiesTable);
        propertiesSection.setClient((Control)propsComposite);
        this.addUserGroupCallBackSection(factory, control);
        Section handlersSection = factory.createSection(control, 258);
        handlersSection.setBackgroundMode(0);
        handlersSection.setText(Messages.title_workItemHandlers);
        handlersSection.setLayout((Layout)new GridLayout());
        handlersSection.setLayoutData((Object)new GridData(4, 4, true, false));
        handlersSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BPMImplementationComposite.this.getContainer().layout();
            }
        });
        this._handlersTable = new BPMTaskHandlerTable((Composite)handlersSection, 0);
        this._handlersTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._handlersTable);
        handlersSection.setClient((Control)this._handlersTable);
        item.setControl((Control)control);
    }

    private void updateImplementationPropertiesLoadValue(final String value) {
        this.wrapOperation(new Runnable(){

            @Override
            public void run() {
                PropertiesType properties = BPMImplementationComposite.this._implementation.getProperties();
                if (properties == null) {
                    properties = BPMFactory.eINSTANCE.createPropertiesType();
                    BPMImplementationComposite.this._implementation.setProperties(properties);
                }
                properties.setLoad(value);
            }
        });
    }

    private void addUserGroupCallBackSection(FormToolkit factory, Composite control) {
        Section userGroupCallbackSection = factory.createSection(control, 258);
        userGroupCallbackSection.setBackgroundMode(0);
        userGroupCallbackSection.setText(Messages.title_userGroupCallback);
        userGroupCallbackSection.setLayout((Layout)new GridLayout());
        userGroupCallbackSection.setLayoutData((Object)new GridData(4, 4, true, false));
        userGroupCallbackSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BPMImplementationComposite.this.getContainer().layout();
            }
        });
        Composite userGroupCallbackControl = factory.createComposite((Composite)userGroupCallbackSection);
        userGroupCallbackControl.setLayout((Layout)new GridLayout(3, false));
        userGroupCallbackControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this._callbackLinkLabel = new Link(userGroupCallbackControl, 0);
        String message = Messages.link_class;
        this._callbackLinkLabel.setText(message);
        this._callbackLinkLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BPMImplementationComposite.this.handleClassLink(BPMImplementationComposite.this._userGroupCallbackClassText, BPMImplementationComposite.this._callbackLinkLabel, "org.kie.internal.task.api.UserGroupCallback");
            }
        });
        this._userGroupCallbackClassText = factory.createText(userGroupCallbackControl, "", 2048);
        this._userGroupCallbackClassText.setLayoutData((Object)new GridData(4, 4, true, false));
        this._userGroupCallbackClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newValue;
                String string = newValue = BPMImplementationComposite.this._userGroupCallbackClassText.getText().length() == 0 ? null : BPMImplementationComposite.this._userGroupCallbackClassText.getText();
                if (!BPMImplementationComposite.this._updating) {
                    BPMImplementationComposite.this.wrapOperation(new Runnable(){

                        @Override
                        public void run() {
                            if (BPMImplementationComposite.this._implementation.getUserGroupCallback() == null) {
                                BPMImplementationComposite.this._implementation.setUserGroupCallback(BPMFactory.eINSTANCE.createUserGroupCallbackType());
                            }
                            BPMImplementationComposite.this._implementation.getUserGroupCallback().setClass(newValue);
                            if (BPMImplementationComposite.this._implementation.getUserGroupCallback().getClass_() == null && BPMImplementationComposite.this._implementation.getUserGroupCallback().getProperties() == null) {
                                BPMImplementationComposite.this._implementation.setUserGroupCallback(null);
                            }
                        }
                    });
                }
            }
        });
        Button _userGroupCallbackClassBrowseBtn = factory.createButton(userGroupCallbackControl, Messages.button_dots, 8);
        _userGroupCallbackClassBrowseBtn.setLayoutData((Object)new GridData(4, 4, false, false));
        _userGroupCallbackClassBrowseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IType selected;
                    IProject project = null;
                    if (BPMImplementationComposite.this._implementation != null) {
                        project = PlatformResourceAdapterFactory.getContainingProject((Object)BPMImplementationComposite.this._implementation);
                    }
                    if ((selected = BPMImplementationComposite.this.selectType(BPMImplementationComposite.this._panel.getShell(), "org.kie.internal.task.api.UserGroupCallback", project)) != null) {
                        BPMImplementationComposite.this._userGroupCallbackClassText.setText(selected.getFullyQualifiedName());
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label callbackPropsLabel = factory.createLabel(userGroupCallbackControl, Messages.label_properties);
        callbackPropsLabel.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this._userCallbackPropertiesTable = new BPMUserGroupCallbackPropertyTable(userGroupCallbackControl, 0);
        this._userCallbackPropertiesTable.setLayoutData(new GridData(4, 4, true, false, 3, 5));
        factory.adapt((Composite)this._userCallbackPropertiesTable);
        userGroupCallbackSection.setClient((Control)userGroupCallbackControl);
    }

    public IType selectType(Shell shell, String superTypeName, IProject project) throws JavaModelException {
        IJavaSearchScope searchScope = null;
        if (project == null) {
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            StructuredSelection selectionToPass = StructuredSelection.EMPTY;
            if (selection instanceof IStructuredSelection && (selectionToPass = (IStructuredSelection)selection).getFirstElement() instanceof IFile) {
                project = ((IFile)selectionToPass.getFirstElement()).getProject();
            }
        }
        if (superTypeName != null && !superTypeName.equals("java.lang.Object")) {
            IJavaProject javaProject;
            IType superType;
            if (project == null && this._implementation != null) {
                project = PlatformResourceAdapterFactory.getContainingProject((Object)this._implementation);
            }
            if ((superType = (javaProject = JavaCore.create((IProject)project)).findType(superTypeName)) != null) {
                searchScope = SearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)superType, (boolean)true, (boolean)false, null);
            }
        } else {
            searchScope = SearchEngine.createWorkspaceScope();
        }
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)searchScope, (int)512, (boolean)false);
        dialog.setTitle(Messages.title_selectEntries);
        dialog.setMessage(Messages.description_matchingItems);
        if (dialog.open() == 1) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types == null || types.length == 0) {
            return null;
        }
        return (IType)types[0];
    }

    private String handleCreateJavaClass(String className, String interfaceName) throws JavaModelException {
        IType stype;
        String name;
        IProject project = null;
        IJavaProject javaProject = null;
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        IFile modelFile = SwitchyardSCAEditor.getEditor((EObject)this._implementation).getModelFile();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (modelFile != null) {
            selectionToPass = new StructuredSelection((Object)modelFile);
            project = ((IFile)selectionToPass.getFirstElement()).getProject();
        }
        NewClassWizardPage page = new NewClassWizardPage();
        ArrayList<String> interfaces = new ArrayList<String>();
        if (interfaceName != null && interfaceName.trim().length() > 0) {
            interfaces.add(interfaceName);
            page.setSuperInterfaces(interfaces, false);
        }
        IPackageFragmentRoot packRoot = null;
        if (project != null) {
            javaProject = JavaCore.create((IProject)project);
            if (!className.isEmpty()) {
                if (className.contains(".")) {
                    className = className.substring(className.lastIndexOf(46) + 1);
                }
                page.setTypeName(className, true);
            }
            packRoot = JavaUtil.getFirstJavaSourceRoot((IJavaProject)javaProject);
            page.setPackageFragmentRoot(packRoot, true);
        }
        action.setSelection((IStructuredSelection)selectionToPass);
        if (javaProject != null) {
            IJavaElement[] roots = packRoot.getChildren();
            PackageFragment stashFrag = null;
            int i = 0;
            while (i < roots.length) {
                PackageFragment frag = (PackageFragment)roots[i];
                if (!frag.isDefaultPackage() && !frag.hasSubpackages()) {
                    stashFrag = frag;
                    break;
                }
                ++i;
            }
            if (stashFrag != null) {
                page.setPackageFragment(stashFrag, true);
            }
        }
        action.setConfiguredWizardPage(page);
        action.setOpenEditorOnFinish(false);
        action.run();
        IJavaElement createdElement = action.getCreatedElement();
        if (createdElement != null && createdElement instanceof IType && (name = (stype = (IType)createdElement).getFullyQualifiedName()) != null) {
            return name;
        }
        return null;
    }

    private void handleClassLink(Text classText, Link classLink, String interfaceName) {
        if (classText != null && !classText.isDisposed()) {
            String classname = classText.getText();
            try {
                IType foundClass = this.canFindClass(classname);
                if (foundClass == null) {
                    String className = this.handleCreateJavaClass(classname, interfaceName);
                    if (className != null) {
                        classText.setText(className);
                    }
                    return;
                }
                this.handleOpenJavaClass(foundClass);
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
        }
    }

    private IType canFindClass(String classname) throws JavaModelException {
        IJavaProject javaProject;
        IType superType;
        IProject project = null;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            selectionToPass = (IStructuredSelection)selection;
            if (selectionToPass.getFirstElement() instanceof IFile) {
                project = ((IFile)selectionToPass.getFirstElement()).getProject();
            } else if (selectionToPass.getFirstElement() instanceof AbstractGraphicalEditPart) {
                project = PlatformResourceAdapterFactory.getContainingProject((Object)this._implementation);
            }
        }
        if (selectionToPass == StructuredSelection.EMPTY) {
            project = PlatformResourceAdapterFactory.getContainingProject((Object)this._implementation);
        }
        if (project != null && classname != null && (superType = (javaProject = JavaCore.create((IProject)project)).findType(classname)) != null) {
            return superType;
        }
        return null;
    }

    private void handleOpenJavaClass(IType classToOpen) {
        if (classToOpen != null) {
            try {
                JavaUI.openInEditor((IJavaElement)classToOpen);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public IStatus validate() {
        String loadPath;
        IStatus loadStatus;
        if (this._implementation != null && this._implementation.getManifest() != null) {
            IStatus restStatus;
            IStatus jmsStatus;
            ManifestType manifest = this._implementation.getManifest();
            if (manifest.getRemoteJms() != null && (jmsStatus = this._remoteJMSContainerDetailsControls.validate()) != Status.OK_STATUS) {
                return jmsStatus;
            }
            if (manifest.getRemoteRest() != null && (restStatus = this._remoteRestContainerDetailsControls.validate()) != Status.OK_STATUS) {
                return restStatus;
            }
        }
        if (this._implementation != null && this._implementation.getProperties() != null && this._implementation.getProperties().getLoad() != null && (loadStatus = PropertiesFileLoadDialog.validatePropertiesLoadValue((String)(loadPath = this._implementation.getProperties().getLoad()))) != Status.OK_STATUS) {
            return loadStatus;
        }
        return Status.OK_STATUS;
    }
}

