/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.modelgenerator.salesforce.SalesforceConstants;
import org.teiid.designer.modelgenerator.salesforce.ui.Activator;
import org.teiid.designer.modelgenerator.salesforce.ui.ModelGeneratorSalesforceUiConstants;
import org.teiid.designer.relational.model.DatatypeProcessor;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class CreateSalesForceFunctionsAction
extends SortableSelectionAction {
    private DatatypeProcessor datatypeProcessor;

    public CreateSalesForceFunctionsAction() {
        super(ModelGeneratorSalesforceUiConstants.UTIL.getString("create.functions.label", new Object[0]), -1);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/salesforce_wiz.gif"));
    }

    public CreateSalesForceFunctionsAction(String text, int style) {
        super(text, style);
    }

    public boolean isApplicable(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    protected boolean isValidSelection(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    private boolean sourceModelSelected(ISelection theSelection) {
        Object selectedObj;
        if (SelectionUtilities.isSingleSelection((ISelection)theSelection) && theSelection instanceof IStructuredSelection && (selectedObj = ((IStructuredSelection)theSelection).getFirstElement()) instanceof IFile && ModelIdentifier.isRelationalSourceModel((IResource)((IFile)selectedObj))) {
            File file = ((IFile)selectedObj).getLocation().toFile();
            try {
                ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(SalesforceConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
                if (assistant != null) {
                    return assistant.hasExtensionProperties(file);
                }
            }
            catch (Exception e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        return false;
    }

    public void run() {
        this.datatypeProcessor = new DatatypeProcessor();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor theMonitor) {
                block15: {
                    String taskName = ModelGeneratorSalesforceUiConstants.UTIL.getString("create.functions.job", new Object[0]);
                    boolean started = ModelerCore.startTxn((boolean)true, (boolean)true, (String)taskName, (Object)((Object)this));
                    boolean succeeded = false;
                    try {
                        try {
                            IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)CreateSalesForceFunctionsAction.this.getSelection()).get(0);
                            theMonitor.beginTask(taskName, -1);
                            ModelResource modelResource = ModelUtil.getModelResource((IFile)modelFile, (boolean)true);
                            theMonitor.worked(1000);
                            if (modelResource != null) {
                                CreateSalesForceFunctionsAction.this.createPushdownFunctions(modelResource, theMonitor);
                                modelResource.save(theMonitor, false);
                            }
                            succeeded = true;
                        }
                        catch (ModelWorkspaceException e) {
                            String msg = ModelGeneratorSalesforceUiConstants.UTIL.getString("create.functions.errorMessage", new Object[]{e.getMessage()});
                            UiConstants.Util.log(4, (Throwable)e, msg);
                            if (started) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (started) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        throw throwable;
                    }
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
                theMonitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            UiConstants.Util.log(e.getTargetException());
        }
    }

    protected void createPushdownFunctions(ModelResource modelResource, IProgressMonitor theMonitor) throws ModelWorkspaceException {
        Procedure function = this.createIncludesFunction();
        modelResource.getEmfResource().getContents().add((Object)function);
        theMonitor.worked(1000);
        function = this.createExcludesFunction();
        modelResource.getEmfResource().getContents().add((Object)function);
        theMonitor.worked(1000);
    }

    private Procedure createExcludesFunction() {
        Procedure function = this.createCommonProps();
        function.setName("excludes");
        return function;
    }

    private Procedure createIncludesFunction() {
        Procedure function = this.createCommonProps();
        function.setName("includes");
        return function;
    }

    private Procedure createCommonProps() {
        Procedure function = RelationalFactory.eINSTANCE.createProcedure();
        function.setFunction(true);
        EObject stringDatatype = this.datatypeProcessor.findDatatype("string");
        ProcedureParameter param = RelationalFactory.eINSTANCE.createProcedureParameter();
        param.setName("columnName");
        if (stringDatatype != null) {
            param.setType(stringDatatype);
            param.setLength(0);
        }
        param.setDirection(DirectionKind.IN_LITERAL);
        function.getParameters().add((Object)param);
        param = RelationalFactory.eINSTANCE.createProcedureParameter();
        param.setName("param");
        if (stringDatatype != null) {
            param.setType(stringDatatype);
            param.setLength(0);
        }
        param.setDirection(DirectionKind.IN_LITERAL);
        function.getParameters().add((Object)param);
        ProcedureParameter result = RelationalFactory.eINSTANCE.createProcedureParameter();
        result.setDirection(DirectionKind.RETURN_LITERAL);
        EObject booleanDatatype = this.datatypeProcessor.findDatatype("boolean");
        if (booleanDatatype != null) {
            result.setType(booleanDatatype);
        }
        result.setName("returnParam");
        function.getParameters().add((Object)result);
        return function;
    }
}

