/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.datatools.ui.dialogs.ConnectionProfileWorker;
import org.teiid.designer.datatools.ui.dialogs.IProfileChangedListener;
import org.teiid.designer.datatools.ui.jobs.PingJobWithoutPopup;
import org.teiid.designer.modelgenerator.salesforce.SalesforceImportWizardManager;
import org.teiid.designer.modelgenerator.salesforce.ui.ModelGeneratorSalesforceUiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class CredentialsPage
extends AbstractWizardPage
implements Listener,
IProfileChangedListener,
ModelGeneratorSalesforceUiConstants,
ModelGeneratorSalesforceUiConstants.Images,
ModelGeneratorSalesforceUiConstants.HelpContexts {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(CredentialsPage.class);
    private static final String EMPTY_STR = "";
    private static final String SF_PROFILE_ID = "org.teiid.designer.datatools.salesforce.connectionProfile";
    SalesforceImportWizardManager importManager;
    private Combo connectionProfilesCombo;
    private ILabelProvider profileLabelProvider;
    private IConnectionProfile selectedConnectionProfile;
    private CLabel textFieldUsername;
    private Text textFieldPassword;
    private Button validateButton;
    private Button newCPButton;
    private Button editCPButton;
    private CLabel textFieldURL;
    private ConnectionProfileWorker profileWorker;

    public CredentialsPage(SalesforceImportWizardManager importManager) {
        super(CredentialsPage.class.getSimpleName(), CredentialsPage.getString("title"));
        this.importManager = importManager;
    }

    public void createControl(Composite theParent) {
        this.profileWorker = new ConnectionProfileWorker(this.getShell(), SF_PROFILE_ID, (IProfileChangedListener)this);
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        pnl.setLayout((Layout)new GridLayout(1, false));
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnl, "org.teiid.designer.modelgenerator.salesforce.ui.credentialsPage");
        this.setControl((Control)pnl);
        Group profileGroup = WidgetFactory.createGroup((Composite)pnl, (String)CredentialsPage.getString("profileLabel.text"), (int)0, (int)2, (int)3);
        profileGroup.setLayoutData((Object)new GridData(768));
        this.profileLabelProvider = new LabelProvider(){

            public String getText(Object source) {
                return ((IConnectionProfile)source).getName();
            }
        };
        this.connectionProfilesCombo = WidgetFactory.createCombo((Composite)profileGroup, (int)8, (int)768, (List)this.profileWorker.getProfiles(), (ILabelProvider)this.profileLabelProvider, (boolean)true);
        this.connectionProfilesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = CredentialsPage.this.connectionProfilesCombo.getSelectionIndex();
                String name = CredentialsPage.this.connectionProfilesCombo.getItem(selIndex);
                if (name != null) {
                    IConnectionProfile profile = CredentialsPage.this.profileWorker.getProfile(name);
                    CredentialsPage.this.profileWorker.setSelection(profile);
                    CredentialsPage.this.handleProfileSelection();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.connectionProfilesCombo.setVisibleItemCount(10);
        this.newCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)CredentialsPage.getString("new.label"));
        this.newCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CredentialsPage.this.profileWorker.create();
            }
        });
        this.editCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)CredentialsPage.getString("edit.label"));
        this.editCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CredentialsPage.this.profileWorker.edit();
            }
        });
        Group propertiesGroup = WidgetFactory.createGroup((Composite)pnl, (String)CredentialsPage.getString("properties.label"), (int)0, (int)2, (int)2);
        GridData gdCredentialsGroup = new GridData(768);
        propertiesGroup.setLayoutData((Object)gdCredentialsGroup);
        CLabel urlLabel = new CLabel((Composite)propertiesGroup, 0);
        urlLabel.setText(CredentialsPage.getString("overrideURLCheckbox.text"));
        urlLabel.setToolTipText(CredentialsPage.getString("overrideURLCheckbox.tipText"));
        this.textFieldURL = WidgetFactory.createLabel((Composite)propertiesGroup, (int)768);
        String urlText = CredentialsPage.getString("URLTextField.tooltip");
        this.textFieldURL.setToolTipText(urlText);
        this.textFieldURL.addListener(13, (Listener)this);
        this.textFieldURL.setEnabled(false);
        CLabel userLabel = new CLabel((Composite)propertiesGroup, 0);
        userLabel.setText(CredentialsPage.getString("usernameLabel.text"));
        GridData gridData = new GridData(0);
        gridData.horizontalSpan = 1;
        userLabel.setLayoutData((Object)gridData);
        this.textFieldUsername = WidgetFactory.createLabel((Composite)propertiesGroup, (int)768);
        String text = CredentialsPage.getString("usernameTextField.tooltip");
        this.textFieldUsername.setToolTipText(text);
        this.textFieldUsername.setText(EMPTY_STR);
        this.textFieldUsername.setEnabled(false);
        CLabel passwordLabel = new CLabel((Composite)propertiesGroup, 0);
        passwordLabel.setText(CredentialsPage.getString("passwordLabel.text"));
        GridData gridData2 = new GridData(0);
        gridData2.horizontalSpan = 1;
        passwordLabel.setLayoutData((Object)gridData2);
        this.textFieldPassword = WidgetFactory.createTextField((Composite)propertiesGroup, (int)768);
        text = CredentialsPage.getString("usernameTextField.tooltip");
        this.textFieldPassword.setToolTipText(text);
        this.textFieldPassword.setText(EMPTY_STR);
        this.textFieldPassword.setEchoChar('*');
        this.textFieldPassword.setEnabled(false);
        Composite buttonComposite = WidgetFactory.createPanel((Composite)pnl, (int)0, (int)1040);
        GridLayout layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        this.validateButton = WidgetFactory.createButton((Composite)buttonComposite, (String)CredentialsPage.getString("validateCredentialsButton.text"), (int)768);
        this.validateButton.setToolTipText(CredentialsPage.getString("validateCredentialsButton.tipText"));
        this.validateButton.addListener(13, (Listener)this);
        this.validateButton.setEnabled(false);
        this.handleProfileSelection();
    }

    protected void handleProfileSelection() {
        if (this.connectionProfilesCombo.getItems() == null || this.connectionProfilesCombo.getItems().length == 0) {
            this.setErrorMessage(CredentialsPage.getString("no.profile"));
            this.textFieldUsername.setText(EMPTY_STR);
            this.textFieldPassword.setText(EMPTY_STR);
            this.textFieldURL.setText(EMPTY_STR);
            this.validateButton.setEnabled(false);
            return;
        }
        if (this.connectionProfilesCombo.getSelectionIndex() < 0) {
            this.setErrorMessage(null);
            this.setMessage(CredentialsPage.getString("select.profile"));
            return;
        }
        String selectedItem = this.connectionProfilesCombo.getItem(this.connectionProfilesCombo.getSelectionIndex());
        this.selectedConnectionProfile = ProfileManager.getInstance().getProfileByName(selectedItem);
        Properties props = this.selectedConnectionProfile.getBaseProperties();
        this.textFieldUsername.setText(props.getProperty("username"));
        this.textFieldPassword.setText(props.getProperty("password"));
        if (props.getProperty("url") == null) {
            this.textFieldURL.setText(UTIL.getString("Common.URL.Default.Label", new Object[0]));
        } else {
            this.textFieldURL.setText(props.getProperty("url"));
        }
        this.setErrorMessage(null);
        this.setMessage(CredentialsPage.getString("validate.profile"));
        this.validateButton.setEnabled(true);
        this.setPageComplete(false);
        this.importManager.setConnectionProfile(this.selectedConnectionProfile);
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.validateButton) {
            String selectedItem = this.connectionProfilesCombo.getItem(this.connectionProfilesCombo.getSelectionIndex());
            this.selectedConnectionProfile = ProfileManager.getInstance().getProfileByName(selectedItem);
            final PingJobWithoutPopup pingJob = new PingJobWithoutPopup(Display.getCurrent().getActiveShell(), this.selectedConnectionProfile);
            pingJob.schedule();
            Runnable op = new Runnable(){

                @Override
                public void run() {
                    try {
                        pingJob.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            };
            UiBusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)op);
            if (pingJob.getResult().isOK()) {
                this.importManager.setConnectionProfile(this.selectedConnectionProfile);
                this.setErrorMessage(null);
                this.setMessage(CredentialsPage.getString("Click.Next"));
                this.setPageComplete(true);
            } else {
                this.setErrorMessage(CredentialsPage.getString("connectionFailedMsg"));
                this.setPageComplete(false);
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getControl().setVisible(visible);
        } else {
            super.setVisible(visible);
        }
    }

    public void profileChanged(IConnectionProfile profile) {
        this.resetCPComboItems();
        this.selectConnectionProfile(profile.getName());
    }

    void resetCPComboItems() {
        if (this.connectionProfilesCombo != null) {
            ArrayList<IConnectionProfile> profileList = new ArrayList<IConnectionProfile>();
            for (IConnectionProfile prof : this.profileWorker.getProfiles()) {
                profileList.add(prof);
            }
            WidgetUtil.setComboItems((Combo)this.connectionProfilesCombo, profileList, (ILabelProvider)this.profileLabelProvider, (boolean)true);
        }
    }

    void selectConnectionProfile(String name) {
        if (name == null) {
            return;
        }
        int cpIndex = -1;
        int i = 0;
        String[] stringArray = this.connectionProfilesCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.length() > 0 && item.toUpperCase().equalsIgnoreCase(name.toUpperCase())) {
                cpIndex = i;
                break;
            }
            ++i;
            ++n2;
        }
        if (cpIndex > -1) {
            this.connectionProfilesCombo.select(cpIndex);
        }
        this.handleProfileSelection();
    }
}

