/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.ui.wizards;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.DataSourceConnectionHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoHelper;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.modelgenerator.salesforce.SalesforceImportWizardManager;
import org.teiid.designer.modelgenerator.salesforce.ui.ModelGeneratorSalesforceUiConstants;
import org.teiid.designer.modelgenerator.salesforce.ui.util.XMLExtensionsFilter;
import org.teiid.designer.modelgenerator.salesforce.ui.wizards.SalesforceUIUtil;
import org.teiid.designer.ui.common.dialog.FolderSelectionDialog;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;

public class ModelSelectionPage
extends AbstractWizardPage
implements Listener,
ModelGeneratorSalesforceUiConstants,
ModelGeneratorSalesforceUiConstants.Images,
ModelGeneratorSalesforceUiConstants.HelpContexts {
    static final String PREFIX = I18nUtil.getPropertyPrefix(ModelSelectionPage.class);
    protected SalesforceImportWizardManager importManager;
    private Text textFieldTargetModelName;
    private Button buttonSelectTargetModel;
    private Text textFieldTargetModelLocation;
    private boolean usesHiddenProject = false;
    private Button buttonSelectTargetModelLocation;
    private IContainer targetModelLocation;
    private boolean updating = false;
    private Button modelAuditFieldsCheck;
    private Button namesAslabelCheckBox;
    private Button generateUpdatedCheckBox;
    private Button generateDeletedCheckBox;
    private Text jndiNameField;
    private String jndiName;
    private Button autoCreateDataSource;
    private IConnectionInfoHelper connectionInfoHelper;
    private ViewerFilter targetLocationFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean projectOpen;
            boolean result = false;
            if (element instanceof IResource && (projectOpen = ((IResource)element).getProject().isOpen())) {
                if (element instanceof IProject) {
                    result = true;
                } else if (element instanceof IFolder) {
                    result = true;
                }
            }
            return result;
        }
    };
    private Button cardinalitiesCheckBox;
    private Button uniqueValueCheckBox;

    public ModelSelectionPage(SalesforceImportWizardManager importManager) {
        super(ModelSelectionPage.class.getSimpleName(), ModelSelectionPage.getString("title"));
        this.importManager = importManager;
    }

    public void createControl(Composite theParent) {
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        GridLayout layout = new GridLayout(1, false);
        pnl.setLayout((Layout)layout);
        this.setControl((Control)pnl);
        this.createTargetModelControls(pnl);
        this.createImportOptionsControls(pnl);
        this.setPageStatus();
    }

    private void createTargetModelControls(Composite pnl) {
        Group modelGroup = WidgetFactory.createGroup((Composite)pnl, null, (int)4, (int)1, (int)3);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)modelGroup);
        modelGroup.setText(ModelSelectionPage.getString("targetModelGroup.text"));
        GridData gData = new GridData(768);
        modelGroup.setLayoutData((Object)gData);
        CLabel theLabel = new CLabel((Composite)modelGroup, 0);
        theLabel.setText(ModelSelectionPage.getString("targetModelLabel.text"));
        GridData gridData = new GridData(0);
        gridData.horizontalSpan = 1;
        theLabel.setLayoutData((Object)gridData);
        this.textFieldTargetModelName = WidgetFactory.createTextField((Composite)modelGroup, (int)768);
        String text = ModelSelectionPage.getString("targetModelTextField.tooltip");
        this.textFieldTargetModelName.setToolTipText(text);
        if (this.importManager.getTargetModelName() != null) {
            this.textFieldTargetModelName.setText(this.importManager.getTargetModelName());
        }
        this.textFieldTargetModelName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ModelSelectionPage.this.setPageStatus();
            }
        });
        this.buttonSelectTargetModel = WidgetFactory.createButton((Composite)modelGroup, (String)ModelSelectionPage.getString("targetModelBrowseButton.text"), (int)4);
        this.buttonSelectTargetModel.setToolTipText(ModelSelectionPage.getString("targetModelBrowseButton.tooltip"));
        CLabel theLabel2 = new CLabel((Composite)modelGroup, 0);
        theLabel2.setText(ModelSelectionPage.getString("targetModelLocationLabel.text"));
        GridData gridData2 = new GridData(0);
        gridData2.horizontalSpan = 1;
        theLabel2.setLayoutData((Object)gridData2);
        IContainer location = this.importManager.getTargetModelLocation();
        String name = location == null ? null : location.getFullPath().makeRelative().toString();
        this.textFieldTargetModelLocation = WidgetFactory.createTextField((Composite)modelGroup, (int)768);
        text = ModelSelectionPage.getString("targetModelLocationTextField.tooltip");
        this.textFieldTargetModelLocation.setToolTipText(text);
        if (name != null) {
            this.textFieldTargetModelLocation.setText(name);
        }
        this.textFieldTargetModelLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ModelSelectionPage.this.setPageStatus();
            }
        });
        if (this.usesHiddenProject) {
            theLabel2.setVisible(false);
            this.textFieldTargetModelLocation.setEditable(false);
            this.textFieldTargetModelLocation.setVisible(false);
            this.textFieldTargetModelLocation.setVisible(false);
            try {
                ModelProject theProject = ModelerCore.getModelWorkspace().getModelProjects()[0];
                IProject proj = theProject.getProject();
                this.textFieldTargetModelLocation.setText(proj.getName());
            }
            catch (ModelWorkspaceException e) {
                UTIL.log((Throwable)e);
                WizardUtil.setPageComplete((WizardPage)this, (String)e.getLocalizedMessage(), (int)3);
            }
        }
        if (!this.usesHiddenProject) {
            this.buttonSelectTargetModelLocation = WidgetFactory.createButton((Composite)modelGroup, (String)ModelSelectionPage.getString("targetModelLocationBrowseButton.text"), (int)4);
            this.buttonSelectTargetModelLocation.setToolTipText(ModelSelectionPage.getString("targetModelLocationBrowseButton.tooltip"));
            this.buttonSelectTargetModelLocation.addListener(13, (Listener)this);
        }
        this.buttonSelectTargetModel.addListener(13, (Listener)this);
        this.addJndiNamePanel((Composite)modelGroup);
    }

    private void addJndiNamePanel(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)ModelSelectionPage.getString("jndiGroup"), (int)0, (int)3, (int)3);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo((Composite)theGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)theGroup);
        Label nameLabel = new Label((Composite)theGroup, 0);
        nameLabel.setText(ModelSelectionPage.getString("jndiLabel"));
        nameLabel.setToolTipText(ModelSelectionPage.getString("jndiToolTip"));
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)nameLabel);
        boolean serverDefined = DataSourceConnectionHelper.isServerDefined();
        boolean serverActive = DataSourceConnectionHelper.isServerConnected();
        this.jndiNameField = WidgetFactory.createTextField((Composite)theGroup);
        this.jndiNameField.setToolTipText(ModelSelectionPage.getString("jndiToolTip"));
        this.jndiName = this.importManager.getJBossJndiName();
        if (this.jndiName != null && this.jndiName.length() > 0) {
            this.jndiNameField.setText(this.jndiName);
        }
        this.jndiNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ModelSelectionPage.this.jndiNameField.getText() != null && ModelSelectionPage.this.jndiNameField.getText().length() > 0) {
                    ModelSelectionPage.this.jndiName = ModelSelectionPage.this.jndiNameField.getText();
                    ModelSelectionPage.this.importManager.setJBossJndiNameName(ModelSelectionPage.this.jndiName);
                } else {
                    ModelSelectionPage.this.jndiName = "";
                    ModelSelectionPage.this.importManager.setJBossJndiNameName(null);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.jndiNameField);
        this.autoCreateDataSource = WidgetFactory.createCheckBox((Composite)theGroup, (String)"Auto-create Data Source");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.autoCreateDataSource);
        this.autoCreateDataSource.setSelection(this.importManager.doCreateDataSource());
        if (serverActive) {
            this.autoCreateDataSource.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ModelSelectionPage.this.importManager.setCreateDataSource(ModelSelectionPage.this.autoCreateDataSource.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.autoCreateDataSource.setEnabled(serverActive);
        if (!serverActive) {
            Group serverMessageGroup = WidgetFactory.createGroup((Composite)theGroup, (String)ModelSelectionPage.getString("serverUnavailableGroup"), (int)0, (int)2, (int)3);
            serverMessageGroup.setLayoutData((Object)new GridData(768));
            Text msgText = new Text((Composite)serverMessageGroup, 72);
            msgText.setBackground(Display.getCurrent().getSystemColor(19));
            msgText.setForeground(Display.getCurrent().getSystemColor(10));
            GridDataFactory.fillDefaults().span(2, 1).grab(true, false).hint(0, 55).applyTo((Control)serverMessageGroup);
            if (!serverDefined) {
                msgText.setText(ModelSelectionPage.getString("noServerDefined"));
            } else {
                msgText.setText(ModelSelectionPage.getString("serverNotStarted"));
            }
        }
    }

    private void createImportOptionsControls(Composite pnl) {
        Group optionsGroup = WidgetFactory.createGroup((Composite)pnl, (int)4);
        optionsGroup.setText(ModelSelectionPage.getString("importOptionsGroup.text"));
        GridData gData = new GridData(4, 4, true, true);
        gData.heightHint = 200;
        optionsGroup.setLayoutData((Object)gData);
        ScrolledComposite c1 = new ScrolledComposite((Composite)optionsGroup, 772);
        c1.setLayout((Layout)new GridLayout());
        c1.setLayoutData((Object)new GridData(4, 4, true, true));
        c1.setExpandHorizontal(true);
        c1.setExpandVertical(true);
        Composite c2 = WidgetFactory.createPanel((Composite)c1);
        gData = new GridData(4, 4, true, true);
        c2.setLayoutData((Object)gData);
        c2.setLayout((Layout)new GridLayout(2, false));
        c1.setContent((Control)c2);
        this.modelAuditFieldsCheck = WidgetFactory.createCheckBox((Composite)c2, (String)ModelSelectionPage.getString("modelAuditFields.text"));
        this.modelAuditFieldsCheck.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.modelAuditFields(((Button)e.getSource()).getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.modelAuditFields(((Button)e.getSource()).getSelection());
            }
        });
        GridData labelData = new GridData(4, 128, true, false, 2, 1);
        Label label = WidgetFactory.createLabel((Composite)c2, (String)ModelSelectionPage.getString("modelAuditFieldsWarning.text"), (int)4);
        label.setLayoutData((Object)labelData);
        label = WidgetFactory.createLabel((Composite)c2, (String)ModelSelectionPage.getString("modelAuditFieldsWarning.text2"), (int)4);
        label.setLayoutData((Object)labelData);
        this.cardinalitiesCheckBox = WidgetFactory.createCheckBox((Composite)c2, (String)ModelSelectionPage.getString("gatherCardianalitiesLabel.text"));
        this.cardinalitiesCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.supressCollectCardinalities(((Button)e.getSource()).getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.supressCollectCardinalities(((Button)e.getSource()).getSelection());
            }
        });
        label = WidgetFactory.createLabel((Composite)c2, (String)ModelSelectionPage.getString("gatherCardianalitiesWarning.text"), (int)4);
        label.setLayoutData((Object)labelData);
        label = WidgetFactory.createLabel((Composite)c2, (String)ModelSelectionPage.getString("gatherCardianalitiesWarning.text2"), (int)4);
        label.setLayoutData((Object)labelData);
        this.uniqueValueCheckBox = WidgetFactory.createCheckBox((Composite)c2, (String)ModelSelectionPage.getString("gatherColumnDistinctValueLabel.text"));
        this.uniqueValueCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.setCollectColumnDistinctValue(((Button)e.getSource()).getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.setCollectColumnDistinctValue(((Button)e.getSource()).getSelection());
            }
        });
        label = WidgetFactory.createLabel((Composite)c2, (String)ModelSelectionPage.getString("gatherColumnDistinctValueWarning.text"), (int)4);
        label.setLayoutData((Object)labelData);
        label = WidgetFactory.createLabel((Composite)c2, (String)ModelSelectionPage.getString("gatherColumnDistinctValueWarning.text2"), (int)4);
        label.setLayoutData((Object)labelData);
        this.namesAslabelCheckBox = WidgetFactory.createCheckBox((Composite)c2, (String)ModelSelectionPage.getString("namesAsNameInSourceLabel.text"));
        this.namesAslabelCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.setNameAsLabel(((Button)e.getSource()).getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.setNameAsLabel(((Button)e.getSource()).getSelection());
            }
        });
        label = WidgetFactory.createLabel((Composite)c2, (String)ModelSelectionPage.getString("namesAsNameInSourceWarning.text"), (int)4);
        label.setLayoutData((Object)labelData);
        label = WidgetFactory.createLabel((Composite)c2, (String)ModelSelectionPage.getString("namesAsNameInSourceWarning.text2"), (int)4);
        label.setLayoutData((Object)labelData);
        this.generateUpdatedCheckBox = WidgetFactory.createCheckBox((Composite)c2, (String)ModelSelectionPage.getString("generateUpdatedLabel.text"));
        this.generateUpdatedCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.setGenerateUpdated(((Button)e.getSource()).getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.setGenerateUpdated(((Button)e.getSource()).getSelection());
            }
        });
        label = WidgetFactory.createLabel((Composite)c2, (String)ModelSelectionPage.getString("generateUpdatedWarning.text"), (int)4);
        label.setLayoutData((Object)labelData);
        this.generateDeletedCheckBox = WidgetFactory.createCheckBox((Composite)c2, (String)ModelSelectionPage.getString("generateDeletedLabel.text"));
        this.generateDeletedCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.setGenerateDeleted(((Button)e.getSource()).getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                ModelSelectionPage.this.importManager.setGenerateDeleted(((Button)e.getSource()).getSelection());
            }
        });
        label = WidgetFactory.createLabel((Composite)c2, (String)ModelSelectionPage.getString("generateDeletedWarning.text"), (int)4);
        label.setLayoutData((Object)labelData);
        Point point = c2.computeSize(-1, -1);
        point.x += 150;
        point.y += 20;
        c1.setMinSize(point);
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    private String getString(String theKey, Object ... properties) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), properties);
    }

    void handleBrowseWorkspaceForTargetModel() {
        Object[] resources = WidgetUtil.showWorkspaceObjectSelectionDialog((String)ModelSelectionPage.getString("dialog.browseTargetModel.title"), (String)ModelSelectionPage.getString("dialog.browseTargetModel.msg"), (boolean)false, (Object)this.importManager.getTargetModelLocation(), (ViewerFilter)new XMLExtensionsFilter(), (ISelectionStatusValidator)new ValidationFilter(), (ILabelProvider)new ModelExplorerLabelProvider());
        if (resources != null && resources.length > 0) {
            IFile model = (IFile)resources[0];
            IContainer location = model.getParent();
            this.textFieldTargetModelName.setText(model.getName());
            this.textFieldTargetModelLocation.setText(location == null ? "" : location.getFullPath().makeRelative().toString());
        }
    }

    void handleBrowseWorkspaceForTargetModelLocation() {
        IContainer location;
        FolderSelectionDialog dlg = new FolderSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dlg.setInitialSelection((Object)this.importManager.getTargetModelLocation());
        dlg.addFilter(this.targetLocationFilter);
        dlg.setValidator((ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        dlg.setAllowMultiple(false);
        dlg.setInput((Object)ModelerCore.getWorkspace().getRoot());
        Object[] objs = new Object[1];
        if (dlg.open() == 0) {
            objs = dlg.getResult();
        }
        IContainer iContainer = location = objs.length == 0 ? null : (IContainer)objs[0];
        if (location != null) {
            this.textFieldTargetModelLocation.setText(location.getFullPath().makeRelative().toString());
            this.setPageStatus();
        }
    }

    void setPageStatus() {
        boolean targetValid = this.validateTargetModelNameAndLocation();
        if (!targetValid) {
            return;
        }
        this.getContainer().updateButtons();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.buttonSelectTargetModel) {
            this.handleBrowseWorkspaceForTargetModel();
        } else if (event.widget == this.buttonSelectTargetModelLocation) {
            this.handleBrowseWorkspaceForTargetModelLocation();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateTargetModelNameAndLocation() {
        this.updating = false;
        this.importManager.setCanFinish(false);
        try {
            this.targetModelLocation = this.validateFileAndFolder(this.textFieldTargetModelName, this.textFieldTargetModelLocation, ".xmi");
            if (this.targetModelLocation == null) {
                return false;
            }
            if (this.targetModelLocation.getProject().getNature("org.teiid.designer.core.modelNature") == null) {
                this.setErrorMessage(ModelSelectionPage.getString("notModelProjectMessage"));
                this.setPageComplete(false);
                this.targetModelLocation = null;
                return false;
            }
            String targetModelName = this.textFieldTargetModelName.getText();
            targetModelName = FileUtils.toFileNameWithExtension((String)targetModelName, (String)".xmi");
            IFile file = this.targetModelLocation.getFile((IPath)new Path(targetModelName));
            ModelResource model = null;
            if (file.exists()) {
                try {
                    model = ModelerCore.getModelEditor().findModelResource((IResource)file);
                    if (model.isReadOnly()) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)UTIL.getString(String.valueOf(PREFIX) + "readOnlyModelMessage", (Object)file.getName()), (int)3);
                        return false;
                    }
                    if (!"http://www.metamatrix.com/metamodels/Relational".equals(model.getPrimaryMetamodelDescriptor().getNamespaceURI())) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)UTIL.getString(String.valueOf(PREFIX) + "notRelationalModelMessage", (Object)file.getName()), (int)3);
                        return false;
                    }
                    if (model.getModelType().getValue() == ModelType.VIRTUAL) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)UTIL.getString(String.valueOf(PREFIX) + "virtualModelMessage", (Object)file.getName()), (int)3);
                        return false;
                    }
                    this.importManager.setUpdatedModel(model);
                    this.updating = true;
                }
                catch (ModelWorkspaceException err) {
                    UTIL.log((Throwable)err);
                    WidgetUtil.showError((String)err.getLocalizedMessage());
                }
            }
            this.importManager.setTargetModelName(targetModelName);
            this.importManager.setTargetModelLocation(this.targetModelLocation);
            if (!this.updating) {
                this.importManager.setCanFinish(true);
            }
            this.getContainer().updateButtons();
        }
        catch (CoreException err) {
            UTIL.log((Throwable)err);
            WizardUtil.setPageComplete((WizardPage)this, (String)err.getLocalizedMessage(), (int)3);
            return false;
        }
        WizardUtil.setPageComplete((WizardPage)this);
        return true;
    }

    private IContainer validateFileAndFolder(Text fileText, Text folderText, String fileExtension) throws CoreException {
        CoreArgCheck.isNotNull((Object)fileText);
        CoreArgCheck.isNotNull((Object)folderText);
        CoreArgCheck.isNotNull((Object)fileExtension);
        String fileName = fileText.getText();
        if (CoreStringUtil.isEmpty((String)fileName)) {
            WizardUtil.setPageComplete((WizardPage)this, (String)ModelSelectionPage.getString("missingFileMessage"), (int)3);
        } else {
            IStatus status = ModelNameUtil.validate((String)fileName, (String)".xmi", (IContainer)this.targetModelLocation, (int)5);
            if (status.getSeverity() == 4) {
                WizardUtil.setPageComplete((WizardPage)this, (String)(String.valueOf(ModelNameUtil.MESSAGES.INVALID_MODEL_NAME) + status.getMessage()), (int)3);
                this.targetModelLocation = null;
            } else {
                String folderName = folderText.getText();
                if (CoreStringUtil.isEmpty((String)folderName)) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)ModelSelectionPage.getString("missingFolderMessage"), (int)3);
                } else {
                    IResource resrc = ModelerCore.getWorkspace().getRoot().findMember(folderName);
                    if (resrc == null || !(resrc instanceof IContainer) || resrc.getProject() == null) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)ModelSelectionPage.getString("invalidFolderMessage"), (int)3);
                    } else if (!resrc.getProject().isOpen()) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)ModelSelectionPage.getString("closedProjectMessage"), (int)3);
                    } else {
                        IContainer folder = (IContainer)resrc;
                        boolean exists = false;
                        IResource[] resrcs = folder.members();
                        fileName = FileUtils.toFileNameWithExtension((String)fileName, (String)fileExtension);
                        int ndx = resrcs.length;
                        while (--ndx >= 0) {
                            if (!resrcs[ndx].getName().equalsIgnoreCase(fileName)) continue;
                            exists = true;
                            break;
                        }
                        if (exists) {
                            WizardUtil.setPageComplete((WizardPage)this);
                        } else {
                            WizardUtil.setPageComplete((WizardPage)this, (String)ModelSelectionPage.getString("invalidFileMessage"), (int)3);
                        }
                        return folder;
                    }
                }
            }
        }
        return null;
    }

    public void setInitialSelection(ISelection theSelection) {
        if (!theSelection.isEmpty() && theSelection instanceof IStructuredSelection) {
            IContainer container;
            Object[] selectedObjects = ((IStructuredSelection)theSelection).toArray();
            if (selectedObjects.length == 1 && (container = ModelUtil.getContainer((Object)selectedObjects[0])) != null) {
                this.importManager.setTargetModelLocation(container);
            }
            int i = 0;
            while (i < selectedObjects.length) {
                File fNew;
                if (selectedObjects[i] instanceof IFile && SalesforceUIUtil.isModelFile((IFile)selectedObjects[i]) && (fNew = ((IFile)selectedObjects[i]).getLocation().toFile()) != null) {
                    String uriStr = null;
                    try {
                        uriStr = fNew.toURI().toURL().toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {}
                    if (uriStr == null) break;
                    this.importManager.setTargetModelName(uriStr.substring(uriStr.lastIndexOf(47) + 1));
                    break;
                }
                ++i;
            }
        }
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.updating;
    }

    class ValidationFilter
    extends ModelResourceSelectionValidator {
        public ValidationFilter() {
            super(ModelerCore.getMetamodelRegistry().getMetamodelDescriptor("http://www.metamatrix.com/metamodels/Relational"), false);
        }

        public IStatus validate(Object[] selection) {
            IStatus status = super.validate(selection);
            if (status.getSeverity() != 4) {
                IFile file = (IFile)selection[0];
                try {
                    ModelResource model = ModelerCore.getModelEditor().findModelResource((IResource)file);
                    if (model.isReadOnly()) {
                        status = new Status(4, "org.teiid.designer.modelgenerator.salesforce.ui", UTIL.getString(String.valueOf(PREFIX) + "dialog.readOnlyModelMessage", new Object[0]));
                    }
                    if (model.getModelType().getValue() == ModelType.VIRTUAL) {
                        status = new Status(4, "org.teiid.designer.modelgenerator.salesforce.ui", UTIL.getString(String.valueOf(PREFIX) + "dialog.virtualModelMessage", new Object[0]));
                    }
                }
                catch (Exception e) {
                    status = new Status(4, "org.teiid.designer.modelgenerator.salesforce.ui", null, (Throwable)e);
                }
            }
            return status;
        }
    }
}

