/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.modelgenerator.salesforce.SalesforceImportWizardManager;
import org.teiid.designer.modelgenerator.salesforce.ui.Activator;
import org.teiid.designer.modelgenerator.salesforce.ui.ModelGeneratorSalesforceUiConstants;
import org.teiid.designer.modelgenerator.salesforce.ui.wizards.CredentialsPage;
import org.teiid.designer.modelgenerator.salesforce.ui.wizards.ModelSelectionPage;
import org.teiid.designer.modelgenerator.salesforce.ui.wizards.SelectSalesforceObjectsPage;
import org.teiid.designer.modelgenerator.salesforce.ui.wizards.ShowDifferencesPage;
import org.teiid.designer.modelgenerator.salesforce.util.ModelBuildingException;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.NoOpenProjectsWizardPage;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class SalesforceToRelationalImportWizard
extends AbstractWizard
implements IImportWizard,
ModelGeneratorSalesforceUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(SalesforceToRelationalImportWizard.class);
    private static final String TITLE = SalesforceToRelationalImportWizard.getString("Salesforce.Import.Wizard");
    SalesforceImportWizardManager importManager;
    private WizardPage selectSalesforceObjectsPage;
    private IStructuredSelection selection;
    private CredentialsPage credentialsPage;
    private ModelSelectionPage modelSelectionPage;
    private ShowDifferencesPage differencesPage;

    public SalesforceToRelationalImportWizard() {
        super((AbstractUIPlugin)Activator.getDefault(), TITLE, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.teiid.designer.modelgenerator.salesforce.ui", (String)"icons/salesforce_wiz.gif"));
    }

    private static String getString(String id) {
        return UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.importManager = new SalesforceImportWizardManager();
        this.selection = currentSelection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        if (!ModelerUiViewUtils.workspaceHasOpenModelProjects()) {
            IProject newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
            if (newProject != null) {
                this.selection = new StructuredSelection((Object)newProject);
            } else {
                this.addPage((IWizardPage)NoOpenProjectsWizardPage.getStandardPage());
                return;
            }
        }
        this.createWizardPages((ISelection)this.selection);
        this.setNeedsProgressMonitor(true);
    }

    public void createWizardPages(ISelection theSelection) {
        this.importManager = new SalesforceImportWizardManager();
        this.credentialsPage = new CredentialsPage(this.importManager);
        this.selectSalesforceObjectsPage = new SelectSalesforceObjectsPage(this.importManager);
        this.modelSelectionPage = new ModelSelectionPage(this.importManager);
        this.differencesPage = new ShowDifferencesPage(this.importManager);
        this.credentialsPage.setPageComplete(false);
        this.selectSalesforceObjectsPage.setPageComplete(false);
        this.modelSelectionPage.setPageComplete(false);
        this.differencesPage.setPageComplete(false);
        this.addPage((IWizardPage)this.credentialsPage);
        this.addPage((IWizardPage)this.selectSalesforceObjectsPage);
        this.addPage((IWizardPage)this.modelSelectionPage);
        this.addPage((IWizardPage)this.differencesPage);
        this.modelSelectionPage.setInitialSelection(theSelection);
    }

    public boolean finish() {
        boolean result = false;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Creating Salesforce model", (Object)new Object());
                boolean succeeded = false;
                try {
                    try {
                        SalesforceToRelationalImportWizard.this.importManager.runFinish(monitor);
                        succeeded = !monitor.isCanceled();
                    }
                    catch (ModelBuildingException mbe) {
                        mbe.printStackTrace(System.err);
                        throw new InvocationTargetException(mbe);
                    }
                    catch (Throwable t) {
                        throw new InvocationTargetException(t);
                    }
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        };
        try {
            try {
                ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
                dlg.run(true, true, op);
                result = true;
            }
            catch (Throwable err) {
                if (err instanceof InvocationTargetException) {
                    Throwable t = ((InvocationTargetException)err).getCause();
                    Status iteStatus = new Status(4, "org.teiid.designer.modelgenerator.salesforce.ui", 4, SalesforceToRelationalImportWizard.getString("importError.msg"), t);
                    ErrorDialog.openError((Shell)this.getShell(), (String)SalesforceToRelationalImportWizard.getString("importError.title"), (String)SalesforceToRelationalImportWizard.getString("importError.msg"), (IStatus)iteStatus);
                    Activator.getDefault().getLog().log((IStatus)iteStatus);
                } else {
                    Status status = new Status(4, "org.teiid.designer.modelgenerator.salesforce.ui", 4, SalesforceToRelationalImportWizard.getString("importError.msg"), err);
                    ErrorDialog.openError((Shell)this.getShell(), (String)SalesforceToRelationalImportWizard.getString("importError.title"), (String)SalesforceToRelationalImportWizard.getString("importError.msg"), (IStatus)status);
                    err.printStackTrace(System.err);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                this.dispose();
            }
        }
        finally {
            this.dispose();
        }
        return result;
    }

    public boolean canFinish() {
        boolean result = super.canFinish();
        result = this.importManager.canFinish();
        return result;
    }
}

