/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.PropertyDifference;
import org.teiid.designer.compare.ui.tree.DifferenceReportsPanel;
import org.teiid.designer.modelgenerator.salesforce.SalesforceImportWizardManager;
import org.teiid.designer.modelgenerator.salesforce.ui.ModelGeneratorSalesforceUiConstants;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class ShowDifferencesPage
extends AbstractWizardPage
implements ModelGeneratorSalesforceUiConstants,
ModelGeneratorSalesforceUiConstants.Images,
ModelGeneratorSalesforceUiConstants.HelpContexts {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ShowDifferencesPage.class);
    private DifferenceReportsPanel pnlDiffReport;
    private List lstDIfferenceReports;
    SalesforceImportWizardManager importManager;
    private boolean bIsVisible;
    protected DifferenceReport shuntDiffReport;
    private static final String MESSAGE = ShowDifferencesPage.getString("message");
    private static final String DIFF_DESCRIPTOR_TITLE = ShowDifferencesPage.getString("diffDescriptorTitle");

    public ShowDifferencesPage(SalesforceImportWizardManager importManager) {
        super(ShowDifferencesPage.class.getSimpleName(), ShowDifferencesPage.getString("title"));
        this.importManager = importManager;
    }

    public void createControl(Composite parent) {
        Composite pg = new Composite(parent, 0);
        pg.setLayout((Layout)new GridLayout());
        pg.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)pg);
        String treeTitle = "";
        String tableTitle = DIFF_DESCRIPTOR_TITLE;
        boolean enableProperySelection = true;
        boolean showCheckboxes = true;
        this.pnlDiffReport = new DifferenceReportsPanel(pg, treeTitle, tableTitle, enableProperySelection, showCheckboxes, true, true);
        this.pnlDiffReport.setMessage("");
        super.setMessage(MESSAGE);
        TableViewer tableViewer = this.pnlDiffReport.getTableViewer();
        if (tableViewer instanceof CheckboxTableViewer) {
            ((CheckboxTableViewer)tableViewer).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent theEvent) {
                    Object checkedObject = theEvent.getElement();
                    boolean isChecked = theEvent.getChecked();
                    if (checkedObject instanceof PropertyDifference) {
                        PropertyDifference propDiff = (PropertyDifference)checkedObject;
                        propDiff.setSkip(!isChecked);
                    }
                }
            });
        }
    }

    public void setVisible(boolean bIsVisible) {
        this.bIsVisible = bIsVisible;
        if (bIsVisible) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ShowDifferencesPage.this.shuntDiffReport = ShowDifferencesPage.this.importManager.getDifferenceReport(monitor);
                        monitor.done();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, op);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                Shell shell = this.getShell();
                Status status = new Status(4, "org.teiid.designer.modelgenerator.salesforce.ui", 0, cause.getLocalizedMessage(), cause);
                System.err.println("cause message=" + cause.getLocalizedMessage());
                ErrorDialog.openError((Shell)shell, (String)ShowDifferencesPage.getString("dialog.dataModelCreationError.title"), (String)cause.getLocalizedMessage(), (IStatus)status);
                super.setVisible(false);
                return;
            }
            catch (InterruptedException interruptedException) {
                super.setVisible(false);
                return;
            }
            this.setDifferenceReport(this.shuntDiffReport);
            this.importManager.setCanFinish(true);
        }
        this.validatePage();
        super.setVisible(bIsVisible);
    }

    private void validatePage() {
        WizardUtil.setPageComplete((WizardPage)this);
    }

    public boolean isVisible() {
        return this.bIsVisible;
    }

    public DifferenceReport getDifferenceReport() {
        return this.pnlDiffReport.getDifferenceReport();
    }

    public void setDifferenceReport(DifferenceReport drDifferenceReport) {
        this.lstDIfferenceReports = new ArrayList(1);
        this.lstDIfferenceReports.add(drDifferenceReport);
        if (this.pnlDiffReport != null) {
            this.pnlDiffReport.setDifferenceReports(this.lstDIfferenceReports);
        }
    }

    public void setDifferenceReports(List lstDIfferenceReports) {
        this.lstDIfferenceReports = lstDIfferenceReports;
        if (this.pnlDiffReport != null) {
            this.pnlDiffReport.setDifferenceReports(lstDIfferenceReports);
        }
    }

    public void setMessage(String sMessage) {
    }

    public void setModelName(String sModelName) {
        if (this.pnlDiffReport != null) {
            this.pnlDiffReport.setModelName(sModelName);
        }
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }
}

