/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.project;

import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.fusesource.ide.foundation.ui.logging.RiderLogFacade;
import org.fusesource.ide.project.Activator;
import org.fusesource.ide.project.providers.CamelVirtualFolder;

public class CamelNatureTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IProject) {
            IProject project = (IProject)receiver;
            boolean enabled = this.isCamelNatureDefined(project);
            if (property.equals("camelNatureEnabled")) {
                return enabled;
            }
            if (property.equals("camelNatureDisabled")) {
                return !enabled;
            }
            if (property.equals("projectOpen")) {
                return project.isOpen();
            }
            if (property.equals("hasChildren")) {
                return this.hasChildren(project);
            }
        }
        return false;
    }

    private boolean hasChildren(IProject project) {
        if (project.isOpen()) {
            CamelVirtualFolder cvf = new CamelVirtualFolder(project);
            cvf.populateChildren();
            return !cvf.getCamelFiles().isEmpty();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCamelNatureDefined(IProject project) {
        if (!project.isOpen()) return false;
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("org.fusesource.ide.project.RiderProjectNature".equals(natures[i])) {
                    return true;
                }
                ++i;
            }
            if (!FacetedProjectFramework.isFacetedProject((IProject)project)) return false;
            IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
            Set enabled = fp.getProjectFacets();
            for (IProjectFacetVersion i2 : enabled) {
                if (!i2.getProjectFacet().getId().equals("jst.camel")) continue;
                return true;
            }
            return false;
        }
        catch (CoreException e) {
            RiderLogFacade.getLog((ILog)Activator.getDefault().getLog()).error((Throwable)e);
        }
        return false;
    }
}

