/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui;

import java.net.URI;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_1.model.sca.WSDLPortType;
import org.switchyard.common.type.Classes;
import org.switchyard.component.bean.config.model.BeanComponentImplementationModel;
import org.switchyard.component.bpm.config.model.BPMComponentImplementationModel;
import org.switchyard.component.camel.model.CamelComponentImplementationModel;
import org.switchyard.component.clojure.config.model.ClojureComponentImplementationModel;
import org.switchyard.component.rules.config.model.RulesComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.implementation.bpel.BPELComponentImplementationModel;
import org.switchyard.config.model.resource.ResourceModel;
import org.switchyard.extensions.java.JavaService;
import org.switchyard.extensions.wsdl.WSDLService;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOnlyService;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.tools.models.switchyard1_0.switchyard.EsbInterface;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.util.SwitchyardResourceFactoryImpl;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.common.ISwitchYardProjectWorkingCopy;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.i18n.Messages;

public final class SwitchYardModelUtils {
    public static String getSwitchYardProjectRuntimeVersion(IProject project) {
        ISwitchYardProjectWorkingCopy isypwc;
        if (project != null && (isypwc = SwitchYardProjectManager.instance().getSwitchYardProject(project).createWorkingCopy()) != null) {
            return isypwc.getVersion();
        }
        return null;
    }

    public static SwitchYardType createSwitchYardModel(String name, String targetNamespace) {
        SwitchYardType switchYardModel = SwitchyardFactory.eINSTANCE.createSwitchYardType();
        switchYardModel.setName(name);
        switchYardModel.setTargetNamespace(targetNamespace);
        return switchYardModel;
    }

    public static String createTargetnamespace(String groupId, String artifactId, String version) {
        return "urn:" + groupId + ":" + artifactId + ":" + version;
    }

    public static IResource getAssociatedResource(IProject project, InterfaceModel im) {
        if (im == null) {
            return null;
        }
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp == null) {
            return null;
        }
        if ("java".equals(im.getType())) {
            return SwitchYardModelUtils.getJavaType(project, im.getInterface());
        }
        if ("wsdl".equals(im.getType())) {
            return SwitchYardModelUtils.getJavaResource(project, im.getInterface());
        }
        return null;
    }

    public static IResource getAssociatedResource(IProject project, ComponentImplementationModel im) {
        if (im == null) {
            return null;
        }
        if (im instanceof BeanComponentImplementationModel) {
            return SwitchYardModelUtils.getJavaType(project, ((BeanComponentImplementationModel)im).getClazz());
        }
        if (im instanceof BPELComponentImplementationModel) {
            return SwitchYardModelUtils.getJavaResource(project, ((BPELComponentImplementationModel)im).getProcess());
        }
        if (im instanceof BPMComponentImplementationModel) {
            BPMComponentImplementationModel bpmIm = (BPMComponentImplementationModel)im;
            if (bpmIm.getManifest() == null || bpmIm.getManifest().getResources() == null || bpmIm.getManifest().getResources().getResources() == null || bpmIm.getManifest().getResources().getResources().size() != 1) {
                return null;
            }
            return SwitchYardModelUtils.getJavaResource(project, ((ResourceModel)bpmIm.getManifest().getResources().getResources().get(0)).getLocation());
        }
        if (im instanceof CamelComponentImplementationModel) {
            CamelComponentImplementationModel camelIm = (CamelComponentImplementationModel)im;
            if (camelIm.getJavaClass() == null || camelIm.getJavaClass().length() == 0) {
                return SwitchYardModelUtils.getSwitchYardConfigurationFile(project);
            }
            return SwitchYardModelUtils.getJavaType(project, camelIm.getJavaClass());
        }
        if (im instanceof ClojureComponentImplementationModel) {
            ClojureComponentImplementationModel clojureIm = (ClojureComponentImplementationModel)im;
            if (clojureIm.getScriptFile() == null || clojureIm.getScriptFile().length() == 0) {
                return SwitchYardModelUtils.getSwitchYardConfigurationFile(project);
            }
            return SwitchYardModelUtils.getJavaResource(project, clojureIm.getScriptFile());
        }
        if (im instanceof RulesComponentImplementationModel) {
            RulesComponentImplementationModel rulesIm = (RulesComponentImplementationModel)im;
            if (rulesIm.getManifest() == null || rulesIm.getManifest().getResources() == null || rulesIm.getManifest().getResources().getResources() == null || rulesIm.getManifest().getResources().getResources().size() != 1) {
                return null;
            }
            return SwitchYardModelUtils.getJavaResource(project, ((ResourceModel)rulesIm.getManifest().getResources().getResources().get(0)).getLocation());
        }
        return null;
    }

    public static IResource getJavaType(IProject project, String type) {
        IType it;
        block5: {
            if (project == null || type == null || type.length() == 0) {
                return null;
            }
            IJavaProject jp = JavaCore.create((IProject)project);
            if (jp == null) {
                return null;
            }
            try {
                it = jp.findType(type);
                if (it != null) break block5;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return it.getUnderlyingResource();
    }

    public static IResource getJavaResource(IProject project, String resourcePath) {
        if (project == null || resourcePath == null || resourcePath.length() == 0) {
            return null;
        }
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp == null) {
            return null;
        }
        resourcePath = URI.create(resourcePath).getPath();
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = jp.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot pfr = iPackageFragmentRootArray[n2];
                if (!pfr.isArchive() && !pfr.isExternal()) {
                    IPath path = pfr.getPath().append(resourcePath);
                    IFile file = project.getWorkspace().getRoot().getFile(path);
                    if (file.exists()) {
                        return file;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }

    public static ServiceInterface getServiceInterface(Interface intf) throws Exception {
        if (intf instanceof JavaInterface) {
            JavaInterface javaIntfc = (JavaInterface)intf;
            Class interfaceClasses = Classes.forName((String)javaIntfc.getInterface());
            if (interfaceClasses != null) {
                return JavaService.fromClass((Class)interfaceClasses);
            }
            throw new IllegalArgumentException(NLS.bind((String)Messages.SwitchYardModelUtils_InterfaceClassNotFound, (Object)javaIntfc.getInterface()));
        }
        if (intf instanceof WSDLPortType) {
            WSDLPortType wsdlIntfc = (WSDLPortType)intf;
            return WSDLService.fromWSDL((String)wsdlIntfc.getInterface());
        }
        if (intf instanceof EsbInterface) {
            EsbInterface esbIntfc = (EsbInterface)intf;
            if (esbIntfc.getOutputType() == null) {
                return new InOnlyService(new InOnlyOperation("", QName.valueOf(esbIntfc.getInputType())));
            }
            return new InOutService(new InOutOperation("", QName.valueOf(esbIntfc.getInputType()), QName.valueOf(esbIntfc.getOutputType()), esbIntfc.getFaultType() == null ? null : QName.valueOf(esbIntfc.getFaultType())));
        }
        throw new IllegalArgumentException(String.valueOf(Messages.SwitchYardModelUtils_InterfaceTypeUnsupportedException) + (intf == null ? "null" : intf.eClass().getInstanceTypeName()));
    }

    public static ResourceSet newResourceSet() {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.switchyard.content-type.1.x", new SwitchyardResourceFactoryImpl());
        return rs;
    }

    private static IFile getSwitchYardConfigurationFile(IProject project) {
        ISwitchYardProject switchYardProject = SwitchYardProjectManager.instance().getSwitchYardProject(project);
        if (switchYardProject == null) {
            return null;
        }
        return switchYardProject.getSwitchYardConfigurationFile();
    }

    private SwitchYardModelUtils() {
    }
}

