/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.WizardActionGroup;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.explorer.AbstractSwitchYardNode;
import org.switchyard.tools.ui.explorer.ISwitchYardNode;
import org.switchyard.tools.ui.explorer.ISwitchYardRootNode;
import org.switchyard.tools.ui.explorer.SwitchYardExplorerContentProvider;
import org.switchyard.tools.ui.explorer.impl.ComponentNode;
import org.switchyard.tools.ui.explorer.impl.ComponentReference;
import org.switchyard.tools.ui.explorer.impl.ComponentService;
import org.switchyard.tools.ui.explorer.impl.ReferenceNode;
import org.switchyard.tools.ui.explorer.impl.ServiceNode;

public class SwitchYardActionProvider
extends CommonActionProvider {
    private static final String SWITCHYARD_NAVIGATOR_EXTENSION = "org.switchyard.tools.ui.explorer.content";
    private static final String SWITCHYARD_MENU = "org.switchyard.tools.ui.switchyard";
    private static final String NEW_MENU = "new.menu";
    private WizardActionGroup _newWizardActionGroup;
    private RefreshAction _refreshAction;
    private OpenFileAction _openFileAction;
    private boolean _contribute;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        if (aSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite workbenchSite = (ICommonViewerWorkbenchSite)aSite.getViewSite();
            this._newWizardActionGroup = new WizardActionGroup(workbenchSite.getWorkbenchWindow(), PlatformUI.getWorkbench().getNewWizardRegistry(), "new", aSite.getContentService());
            this._openFileAction = new OpenFileAction(workbenchSite.getPage()){

                protected List getSelectedResources() {
                    return SwitchYardActionProvider.this.collectResources(this.getStructuredSelection());
                }
            };
            aSite.getStructuredViewer().addSelectionChangedListener((ISelectionChangedListener)this._openFileAction);
            this._contribute = true;
        }
        this._refreshAction = new RefreshAction(new IShellProvider(){

            public Shell getShell() {
                return SwitchYardActionProvider.this.getActionSite().getViewSite().getShell();
            }
        }){

            public void run() {
                ISelection selection = SwitchYardActionProvider.this.getContext().getSelection();
                if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                ISwitchYardNode node = (ISwitchYardNode)((IStructuredSelection)selection).getFirstElement();
                SwitchYardExplorerContentProvider switchYardContentProvider = (SwitchYardExplorerContentProvider)SwitchYardActionProvider.this.getActionSite().getContentService().getContentExtensionById(SwitchYardActionProvider.SWITCHYARD_NAVIGATOR_EXTENSION).getContentProvider();
                switchYardContentProvider.projectUpdated(node.getRoot().getSwitchYardProject(), EnumSet.of(SwitchYardProjectManager.ISwitchYardProjectListener.Type.CONFIG));
                SwitchYardActionProvider.this.getActionSite().getStructuredViewer().refresh((Object)node);
            }
        };
        this._refreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
    }

    public void dispose() {
        this.getActionSite().getStructuredViewer().removeSelectionChangedListener((ISelectionChangedListener)this._openFileAction);
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.insertAfter("group.open", (IContributionItem)new Separator(SWITCHYARD_MENU));
        if (this._contribute) {
            MenuManager submenu = new MenuManager(WorkbenchNavigatorMessages.NewActionProvider_NewMenu_label, NEW_MENU);
            this._newWizardActionGroup.setContext(this.getContext());
            this._newWizardActionGroup.fillContextMenu((IMenuManager)submenu);
            menu.insertAfter("group.new", (IContributionItem)submenu);
            if (this._openFileAction.isEnabled()) {
                menu.insertAfter("group.open", (IAction)this._openFileAction);
            }
        }
        this._refreshAction.setEnabled(true);
        menu.appendToGroup("group.build", (IAction)this._refreshAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this._openFileAction);
    }

    private List<IResource> collectResources(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<Object> converted = new LinkedHashSet<Object>(selection.size());
        for (Object obj : selection) {
            AbstractSwitchYardNode reference;
            IResource related;
            AbstractSwitchYardNode service;
            if (obj instanceof ComponentService) {
                service = (ComponentService)obj;
                related = SwitchYardModelUtils.getAssociatedResource(service.getRoot().getProject(), ((ComponentService)service).getModel().getInterface());
                if (related == null) continue;
                converted.add(related);
                continue;
            }
            if (obj instanceof ComponentReference) {
                reference = (ComponentReference)obj;
                related = SwitchYardModelUtils.getAssociatedResource(reference.getRoot().getProject(), ((ComponentReference)reference).getModel().getInterface());
                if (related == null) continue;
                converted.add(related);
                continue;
            }
            if (obj instanceof ComponentNode) {
                ComponentNode component = (ComponentNode)obj;
                related = SwitchYardModelUtils.getAssociatedResource(component.getRoot().getProject(), component.getModel().getImplementation());
                if (related == null) continue;
                converted.add(related);
                continue;
            }
            if (obj instanceof ServiceNode) {
                service = (ServiceNode)obj;
                related = SwitchYardModelUtils.getAssociatedResource(service.getRoot().getProject(), ((ServiceNode)service).getModel().getInterface());
                if (related == null) continue;
                converted.add(related);
                continue;
            }
            if (obj instanceof ReferenceNode) {
                reference = (ReferenceNode)obj;
                related = SwitchYardModelUtils.getAssociatedResource(reference.getRoot().getProject(), ((ReferenceNode)reference).getModel().getInterface());
                if (related == null) continue;
                converted.add(related);
                continue;
            }
            if (obj instanceof ISwitchYardRootNode) {
                IFile switchYardConfigFile = ((ISwitchYardNode)obj).getRoot().getSwitchYardProject().getSwitchYardConfigurationFile();
                if (switchYardConfigFile == null) continue;
                converted.add(switchYardConfigFile);
                continue;
            }
            if (!(obj instanceof IResource)) continue;
            converted.add((IResource)obj);
        }
        return new ArrayList<IResource>(converted);
    }
}

