/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.switchyard.tools.ui.i18n.Messages;

public class ESBInterfaceInputDialog
extends TitleAreaDialog {
    private Text _inputTypeText;
    private Text _outputTypeText;
    private Text _faultTypeText;
    private String _inputType = null;
    private String _outputType = null;
    private String _faultType = null;

    public ESBInterfaceInputDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ESBInterfaceInputDialog_Title);
        this.setMessage(Messages.ESBInterfaceInputDialog_Message);
        this.getShell().setText(Messages.ESBInterfaceInputDialog_WindowTitle);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        area.setLayout((Layout)gridLayout);
        area.setLayoutData((Object)new GridData(1808));
        this._inputTypeText = this.createLabelAndText(area, Messages.ESBInterfaceInputDialog_InputTypeLabel);
        if (this._inputType != null && !this._inputType.trim().isEmpty()) {
            this._inputTypeText.setText(this._inputType);
        }
        this._inputTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ESBInterfaceInputDialog.this._inputType = ESBInterfaceInputDialog.this._inputTypeText.getText().trim();
            }
        });
        this._outputTypeText = this.createLabelAndText(area, Messages.ESBInterfaceInputDialog_OutputTypeLabel);
        if (this._outputType != null && !this._outputType.trim().isEmpty()) {
            this._outputTypeText.setText(this._outputType);
        }
        this._outputTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ESBInterfaceInputDialog.this._outputType = ESBInterfaceInputDialog.this._outputTypeText.getText().trim();
            }
        });
        this._faultTypeText = this.createLabelAndText(area, Messages.ESBInterfaceInputDialog_FaultTypeLabel);
        if (this._faultType != null && !this._faultType.trim().isEmpty()) {
            this._faultTypeText.setText(this._faultType);
        }
        this._faultTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ESBInterfaceInputDialog.this._faultType = ESBInterfaceInputDialog.this._faultTypeText.getText().trim();
            }
        });
        return area;
    }

    protected Control createButtonBar(Composite parent) {
        Control rtnControl = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.validate());
        this.setErrorMessage(null);
        return rtnControl;
    }

    protected Text createLabelAndText(Composite parent, String label) {
        new Label(parent, 0).setText(label);
        Text newText = new Text(parent, 2048);
        newText.setLayoutData((Object)new GridData(4, 0, true, false));
        newText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ESBInterfaceInputDialog.this.getButton(0).setEnabled(ESBInterfaceInputDialog.this.validate());
            }
        });
        newText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ESBInterfaceInputDialog.this.getButton(0).setEnabled(ESBInterfaceInputDialog.this.validate());
            }
        });
        return newText;
    }

    protected boolean validate() {
        this.setErrorMessage(null);
        if (this._inputTypeText.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.ESBInterfaceInputDialog_InputTypeRequiredMessage);
        } else if (!this._faultTypeText.getText().isEmpty() && this._outputTypeText.getText().isEmpty()) {
            this.setErrorMessage(Messages.ESBInterfaceInputDialog_FaultTypeRequiresOutputTypeMessage);
        }
        return this.getErrorMessage() == null;
    }

    public String getInputType() {
        return this._inputType;
    }

    public String getOutputType() {
        return this._outputType;
    }

    public String getFaultType() {
        return this._faultType;
    }

    public void setInputType(String input) {
        this._inputType = input;
    }

    public void setOutputType(String output) {
        this._outputType = output;
    }

    public void setFaultType(String fault) {
        this._faultType = fault;
    }
}

