/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.model.Dependency;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.M2EUtils;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.i18n.Messages;

public final class SwitchYardComponentExtensionManager {
    public static final String RUNTIME_COMPONENT_EXTENSION_ID = "org.switchyard:switchyard-runtime";
    private static final SwitchYardComponentExtensionManager INSTANCE = new SwitchYardComponentExtensionManager();
    private Map<String, ISwitchYardComponentExtension> _extensions = new TreeMap<String, ISwitchYardComponentExtension>();
    private Map<ISwitchYardComponentExtension.Category, Collection<ISwitchYardComponentExtension>> _extensionsByCategory = new HashMap<ISwitchYardComponentExtension.Category, Collection<ISwitchYardComponentExtension>>();

    public static SwitchYardComponentExtensionManager instance() {
        return INSTANCE;
    }

    private SwitchYardComponentExtensionManager() {
        ISwitchYardComponentExtension.Category[] categoryArray = ISwitchYardComponentExtension.Category.values();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISwitchYardComponentExtension.Category category = categoryArray[n2];
            this._extensionsByCategory.put(category, new ArrayList());
            ++n2;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.switchyard.tools.ui", "switchYardComponent");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n3 = iExtensionArray.length;
        n = 0;
        while (n < n3) {
            IExtension extension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n4 = iConfigurationElementArray.length;
            int n5 = 0;
            while (n5 < n4) {
                IConfigurationElement element = iConfigurationElementArray[n5];
                this.processComponent(element);
                ++n5;
            }
            ++n;
        }
    }

    public ISwitchYardComponentExtension getRuntimeComponentExtension() {
        if (this._extensions.containsKey(RUNTIME_COMPONENT_EXTENSION_ID)) {
            return this._extensions.get(RUNTIME_COMPONENT_EXTENSION_ID);
        }
        return null;
    }

    public Collection<ISwitchYardComponentExtension> getComponentExtensions() {
        return Collections.unmodifiableCollection(this._extensions.values());
    }

    public Collection<ISwitchYardComponentExtension> getComponentExtensions(ISwitchYardComponentExtension.Category category) {
        return Collections.unmodifiableCollection(this._extensionsByCategory.get((Object)category));
    }

    public ISwitchYardComponentExtension getComponentExtension(String id) {
        if (this._extensions.containsKey(id)) {
            return this._extensions.get(id);
        }
        return null;
    }

    private void processComponent(IConfigurationElement element) {
        if (!"component".equals(element.getName())) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", String.valueOf(Messages.SwitchYardComponentExtensionManager_InvalidElementStatus) + element.getName() + ", plugin=" + element.getContributor().getName()));
            return;
        }
        String id = element.getAttribute("id");
        String name = element.getAttribute("name");
        ISwitchYardComponentExtension.Category category = this.parseCategory(element);
        String description = this.parseDescription(element);
        String bundleId = this.parseBundleId(element);
        List<Dependency> dependencies = this.parseDependencies(element);
        if (id == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", String.valueOf(Messages.SwitchYardComponentExtensionManager_InvalidIDStatus) + element.getContributor().getName()));
            return;
        }
        if (this._extensions.containsKey(id)) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", String.valueOf(Messages.SwitchYardComponentExtensionManager_DuplicateIDStatus) + element.getContributor().getName()));
            return;
        }
        if (name == null || name.length() == 0) {
            name = id;
        }
        SwitchYardComponentExtension extension = new SwitchYardComponentExtension(id, name, category, element.getAttribute("scannerClass"), description, bundleId, dependencies);
        this._extensions.put(id, extension);
        this._extensionsByCategory.get((Object)category).add(extension);
    }

    private ISwitchYardComponentExtension.Category parseCategory(IConfigurationElement element) {
        String categoryString = element.getAttribute("category");
        if (categoryString == null || categoryString.length() == 0) {
            return ISwitchYardComponentExtension.Category.UNKNOWN;
        }
        try {
            return ISwitchYardComponentExtension.Category.valueOf(categoryString.toUpperCase());
        }
        catch (Exception exception) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", String.valueOf(Messages.SwitchYardComponentExtensionManager_InvalidCategoryStatus) + element.getContributor().getName() + ", id=" + element.getAttribute("id")));
            return ISwitchYardComponentExtension.Category.UNKNOWN;
        }
    }

    private String parseDescription(IConfigurationElement element) {
        IConfigurationElement[] descriptions = element.getChildren("description");
        if (descriptions.length == 0) {
            return null;
        }
        return descriptions[0].getValue();
    }

    private List<Dependency> parseDependencies(IConfigurationElement element) {
        IConfigurationElement[] dependencyElements = element.getChildren("dependency");
        if (dependencyElements == null) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(dependencyElements.length);
        IConfigurationElement[] iConfigurationElementArray = dependencyElements;
        int n = dependencyElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement dependencyElement = iConfigurationElementArray[n2];
            String artifactId = this.parseArtifactId(dependencyElement);
            String groupId = this.parseGroupId(dependencyElement);
            String scope = this.parseScope(dependencyElement);
            if (artifactId == null || artifactId.length() == 0 || groupId == null || groupId.length() == 0) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", String.valueOf(Messages.SwitchYardComponentExtensionManager_InvalidDependencyStatus) + element.getContributor().getName()));
            } else {
                dependencies.add(M2EUtils.createSwitchYardDependency(groupId, artifactId, scope));
            }
            ++n2;
        }
        return dependencies;
    }

    private String parseGroupId(IConfigurationElement element) {
        IConfigurationElement[] groupIds = element.getChildren("groupId");
        if (groupIds.length != 1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", String.valueOf(Messages.SwitchYardComponentExtensionManager_MultipleGroupIDsFoundStatus) + element.getContributor().getName()));
            return null;
        }
        return groupIds[0].getValue().trim();
    }

    private String parseArtifactId(IConfigurationElement element) {
        IConfigurationElement[] artifactIds = element.getChildren("artifactId");
        if (artifactIds.length != 1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", String.valueOf(Messages.SwitchYardComponentExtensionManager_MultipleArtifactIDsStatus) + element.getContributor().getName()));
            return null;
        }
        return artifactIds[0].getValue().trim();
    }

    private String parseBundleId(IConfigurationElement element) {
        String bundleIdString = element.getAttribute("bundleId");
        if (bundleIdString != null && bundleIdString.length() > 0) {
            return bundleIdString;
        }
        return null;
    }

    private String parseScope(IConfigurationElement element) {
        String scope;
        IConfigurationElement[] scopes = element.getChildren("scope");
        if (scopes.length == 0) {
            return null;
        }
        if (scopes.length != 1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", String.valueOf(Messages.SwitchYardComponentExtensionManager_MultipleScopesStatus) + element.getContributor().getName()));
        }
        return (scope = scopes[0].getValue().trim()).length() == 0 ? null : scope;
    }

    private static final class SwitchYardComponentExtension
    implements ISwitchYardComponentExtension {
        private final String _id;
        private final String _name;
        private final ISwitchYardComponentExtension.Category _category;
        private final String _scannerClassName;
        private final String _description;
        private final String _bundleId;
        private final List<Dependency> _dependencies;

        private SwitchYardComponentExtension(String id, String name, ISwitchYardComponentExtension.Category category, String scannerClassName, String description, String bundleId, List<Dependency> dependencies) {
            this._id = id;
            this._name = name;
            this._category = category;
            this._scannerClassName = scannerClassName;
            this._description = description;
            this._dependencies = Collections.unmodifiableList(dependencies);
            this._bundleId = bundleId;
        }

        @Override
        public String getId() {
            return this._id;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public ISwitchYardComponentExtension.Category getCategory() {
            return this._category;
        }

        @Override
        public String getScannerClassName() {
            return this._scannerClassName;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public List<Dependency> getDependencies() {
            return this._dependencies;
        }

        @Override
        public String getBundleId() {
            return this._bundleId;
        }
    }
}

