/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.i18n.Messages;

public class WSDLPortTypeSelectionDialog
extends ClasspathResourceSelectionDialog {
    private ListViewer _portTypesList;
    private Map<IResource, Definition> _wsdlDefinitions = new HashMap<IResource, Definition>();
    private PortType _result;

    public WSDLPortTypeSelectionDialog(Shell parentShell, IContainer container) {
        super(parentShell, container);
        this.setTitle(Messages.WSDLPortTypeSelectionDialog_dialogTitle);
    }

    public PortType getSelectedPortType() {
        return this._result;
    }

    protected Control createExtendedContentArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(contents, 0);
        label.setText(Messages.WSDLPortTypeSelectionDialog_labelSelectPortType);
        this._portTypesList = new ListViewer(contents, 2052);
        this._portTypesList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof PortType) {
                    return ((PortType)element).getQName().getLocalPart();
                }
                return super.getText(element);
            }
        });
        this._portTypesList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this._portTypesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WSDLPortTypeSelectionDialog.this.portTypeSelected((StructuredSelection)event.getSelection());
            }
        });
        this._portTypesList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WSDLPortTypeSelectionDialog.this.okPressed();
            }
        });
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = this._portTypesList.getList().getItemHeight() * 3;
        this._portTypesList.getControl().setLayoutData((Object)data);
        return contents;
    }

    private void portTypeSelected(StructuredSelection selection) {
        super.handleSelected(selection);
    }

    protected void handleSelected(StructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1 || !(selection.getFirstElement() instanceof IResource)) {
            this._portTypesList.setInput(null);
            return;
        }
        Definition definition = this._wsdlDefinitions.get(selection.getFirstElement());
        if (definition == null) {
            final IResource wsdlFile = (IResource)selection.getFirstElement();
            final Definition[] holder = new Definition[1];
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        WSDLResourceImpl resource = (WSDLResourceImpl)resourceSet.getResource(URI.createPlatformResourceURI((String)wsdlFile.getFullPath().toString(), (boolean)true), true);
                        holder[0] = resource.getDefinition();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            definition = holder[0];
            this._wsdlDefinitions.put(wsdlFile, definition);
        }
        List portTypes = definition == null ? Collections.emptyList() : this.getAllPortTypes(definition).values();
        this._portTypesList.setInput(portTypes);
        selection = portTypes.size() > 0 ? new StructuredSelection(portTypes.iterator().next()) : StructuredSelection.EMPTY;
        this._portTypesList.setSelection((ISelection)selection, true);
    }

    protected IStatus validateItem(Object item) {
        if (item instanceof PortType) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.switchyard.tools.ui", Messages.WSDLPortTypeSelectionDialog_validateMessage_SelectWSDLFileAndPortType);
    }

    protected void computeResult() {
        super.computeResult();
        StructuredSelection selection = (StructuredSelection)this._portTypesList.getSelection();
        this._result = (PortType)selection.getFirstElement();
    }

    private Map getAllPortTypes(Definition definition) {
        return this.getAllPortTypes(definition, new HashSet<String>());
    }

    private Map getAllPortTypes(Definition definition, Set<String> imported) {
        HashMap allPortTypes = new HashMap(definition.getPortTypes());
        Map importMap = definition.getImports();
        for (ArrayList importDefs : importMap.values()) {
            for (Import importDef : importDefs) {
                if (imported.contains(importDef.getLocationURI())) continue;
                imported.add(importDef.getLocationURI());
                Definition importedDef = (Definition)importDef.getDefinition();
                if (importedDef == null) continue;
                allPortTypes.putAll(this.getAllPortTypes(importedDef, imported));
            }
        }
        return allPortTypes;
    }
}

