/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.explorer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.explorer.IArtifactsNode;
import org.switchyard.tools.ui.explorer.IComponentNode;
import org.switchyard.tools.ui.explorer.IComponentReference;
import org.switchyard.tools.ui.explorer.IComponentService;
import org.switchyard.tools.ui.explorer.IComponentsNode;
import org.switchyard.tools.ui.explorer.IReferenceNode;
import org.switchyard.tools.ui.explorer.IReferencesNode;
import org.switchyard.tools.ui.explorer.IServiceNode;
import org.switchyard.tools.ui.explorer.IServicesNode;
import org.switchyard.tools.ui.explorer.ISwitchYardNode;
import org.switchyard.tools.ui.explorer.ISwitchYardRootNode;
import org.switchyard.tools.ui.explorer.impl.SwitchYardRootNode;
import org.switchyard.tools.ui.i18n.Messages;

public class SwitchYardExplorerContentProvider
implements ITreeContentProvider,
SwitchYardProjectManager.ISwitchYardProjectListener {
    private Map<IProject, SwitchYardRootNode> _cache = new HashMap<IProject, SwitchYardRootNode>();
    private TreeViewer _viewer;
    private static final Object PENDING = new Object();
    private ConcurrentMap<SwitchYardRootNode, Object> _pendingUpdates = new ConcurrentHashMap<SwitchYardRootNode, Object>();
    private Job _switchYardNodeRefreshJob = new SwitchYardRefreshJob();
    private IJobChangeListener _jobListener = new JobChangeAdapter(){

        public void done(IJobChangeEvent event) {
            if (event.getJob().belongsTo(SwitchYardProjectManager.SWITCHYARD_PROJECT_REFRESH_JOB_FAMILY) && SwitchYardExplorerContentProvider.this._pendingUpdates.size() > 0) {
                SwitchYardExplorerContentProvider.this._switchYardNodeRefreshJob.schedule(100L);
            }
        }

        public void scheduled(IJobChangeEvent event) {
            if (event.getJob().belongsTo(SwitchYardProjectManager.SWITCHYARD_PROJECT_REFRESH_JOB_FAMILY)) {
                SwitchYardExplorerContentProvider.this._switchYardNodeRefreshJob.cancel();
            }
        }
    };

    public SwitchYardExplorerContentProvider() {
        Job.getJobManager().addJobChangeListener(this._jobListener);
        SwitchYardProjectManager.instance().addListener(this);
    }

    public synchronized void dispose() {
        this._viewer = null;
        SwitchYardProjectManager.instance().removeListener(this);
        Job.getJobManager().removeJobChangeListener(this._jobListener);
        this._switchYardNodeRefreshJob.cancel();
        this._pendingUpdates.clear();
        for (SwitchYardRootNode node : this._cache.values()) {
            node.dispose();
        }
        this._cache.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this._viewer = viewer instanceof TreeViewer ? (TreeViewer)viewer : null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            return new Object[]{this.getOrCreateRootNode((IProject)parentElement)};
        }
        if (parentElement instanceof ISwitchYardRootNode) {
            ISwitchYardRootNode root = (ISwitchYardRootNode)parentElement;
            return new Object[]{root.getServicesNode(), root.getReferencesNode(), root.getComponentsNode(), root.getArtifactsNode()};
        }
        if (parentElement instanceof IServicesNode) {
            return ((IServicesNode)parentElement).getServices().toArray();
        }
        if (parentElement instanceof IReferencesNode) {
            return ((IReferencesNode)parentElement).getReferences().toArray();
        }
        if (parentElement instanceof IComponentsNode) {
            return ((IComponentsNode)parentElement).getComponents().toArray();
        }
        if (parentElement instanceof IArtifactsNode) {
            return ((IArtifactsNode)parentElement).getArtifacts().toArray();
        }
        if (parentElement instanceof IComponentNode) {
            IComponentNode component = (IComponentNode)parentElement;
            List<IComponentService> services = component.getServices();
            List<IComponentReference> references = component.getReferences();
            ArrayList<ISwitchYardNode> children = new ArrayList<ISwitchYardNode>(services.size() + references.size());
            children.addAll(services);
            children.addAll(references);
            return children.toArray();
        }
        if (parentElement instanceof IServiceNode) {
            return ((IServiceNode)parentElement).getGateways().toArray();
        }
        if (parentElement instanceof IReferenceNode) {
            return ((IReferenceNode)parentElement).getGateways().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof ISwitchYardRootNode) {
            return ((ISwitchYardRootNode)element).getProject();
        }
        if (element instanceof ISwitchYardNode) {
            return ((ISwitchYardNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ISwitchYardRootNode) {
            return true;
        }
        return this.getChildren(element).length > 0;
    }

    @Override
    public synchronized void projectUpdated(ISwitchYardProject project, Set<SwitchYardProjectManager.ISwitchYardProjectListener.Type> types) {
        if (!this._cache.containsKey(project.getProject()) || types.size() == 1 && types.contains((Object)SwitchYardProjectManager.ISwitchYardProjectListener.Type.POM)) {
            return;
        }
        if (types.contains((Object)SwitchYardProjectManager.ISwitchYardProjectListener.Type.REMOVED)) {
            SwitchYardRootNode node = this._cache.remove(project.getProject());
            this._pendingUpdates.remove(node);
            node.dispose();
            return;
        }
        this.scheduleRefresh(this._cache.get(project.getProject()));
    }

    private synchronized SwitchYardRootNode getOrCreateRootNode(IProject project) {
        if (this._cache.containsKey(project)) {
            return this._cache.get(project);
        }
        SwitchYardRootNode rootNode = new SwitchYardRootNode(project);
        this._cache.put(project, rootNode);
        this.scheduleRefresh(rootNode);
        return rootNode;
    }

    private void scheduleRefresh(SwitchYardRootNode node) {
        if (node == null) {
            return;
        }
        this._pendingUpdates.putIfAbsent(node, PENDING);
        this._switchYardNodeRefreshJob.schedule(100L);
    }

    private final class SwitchYardRefreshJob
    extends Job {
        private SwitchYardRefreshJob() {
            super(Messages.SwitchYardExplorerContentProvider_jobMessage_RefreshingSYProjectConfig);
            this.setPriority(50);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.SwitchYardExplorerContentProvider_jobMessage_RefreshingSYProjectConfig, -1);
            IStatus status = Status.OK_STATUS;
            try {
                final LinkedHashSet<SwitchYardRootNode> updatedNodes = new LinkedHashSet<SwitchYardRootNode>();
                block7: do {
                    Iterator it = SwitchYardExplorerContentProvider.this._pendingUpdates.keySet().iterator();
                    while (it.hasNext()) {
                        block14: {
                            SwitchYardRootNode switchYardNode = (SwitchYardRootNode)it.next();
                            monitor.subTask(switchYardNode.getProject().getName());
                            SubProgressMonitor subMontior = new SubProgressMonitor(monitor, 100);
                            Job.getJobManager().beginRule((ISchedulingRule)switchYardNode.getProject(), monitor);
                            try {
                                try {
                                    it.remove();
                                    switchYardNode.reload((IProgressMonitor)subMontior);
                                    updatedNodes.add(switchYardNode);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    Job.getJobManager().endRule((ISchedulingRule)switchYardNode.getProject());
                                    subMontior.done();
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                Job.getJobManager().endRule((ISchedulingRule)switchYardNode.getProject());
                                subMontior.done();
                                throw throwable;
                            }
                            Job.getJobManager().endRule((ISchedulingRule)switchYardNode.getProject());
                            subMontior.done();
                        }
                        if (!monitor.isCanceled()) continue;
                        status = Status.CANCEL_STATUS;
                        continue block7;
                    }
                } while (status.isOK() && SwitchYardExplorerContentProvider.this._pendingUpdates.size() > 0);
                final TreeViewer viewer = SwitchYardExplorerContentProvider.this._viewer;
                if (viewer == null) {
                    SwitchYardExplorerContentProvider.this._pendingUpdates.clear();
                } else if (updatedNodes.size() > 0) {
                    viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (viewer.getControl().isDisposed()) {
                                return;
                            }
                            for (SwitchYardRootNode node : updatedNodes) {
                                viewer.refresh((Object)node);
                            }
                        }
                    });
                }
            }
            finally {
                monitor.done();
            }
            if (SwitchYardExplorerContentProvider.this._pendingUpdates.size() > 0) {
                this.schedule(100L);
            }
            return status;
        }

        public boolean shouldRun() {
            return SwitchYardExplorerContentProvider.this._pendingUpdates.size() > 0 && Job.getJobManager().find(SwitchYardProjectManager.SWITCHYARD_PROJECT_REFRESH_JOB_FAMILY).length == 0;
        }
    }
}

