/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.explorer.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.ui.explorer.AbstractSwitchYardNode;
import org.switchyard.tools.ui.explorer.IReferenceNode;
import org.switchyard.tools.ui.explorer.IReferencesNode;
import org.switchyard.tools.ui.explorer.impl.ReferenceNode;
import org.switchyard.tools.ui.explorer.impl.SwitchYardRootNode;
import org.switchyard.tools.ui.i18n.Messages;

public class ReferencesNode
extends AbstractSwitchYardNode
implements IReferencesNode {
    private List<IReferenceNode> _references;

    public ReferencesNode(SwitchYardRootNode root, SwitchYardModel configuration) {
        super(root);
        if (configuration == null) {
            this._references = Collections.emptyList();
            return;
        }
        CompositeModel composite = configuration.getComposite();
        if (composite == null) {
            this._references = Collections.emptyList();
            return;
        }
        List references = composite.getReferences();
        this._references = new ArrayList<IReferenceNode>(references.size());
        for (CompositeReferenceModel reference : references) {
            this._references.add(new ReferenceNode(this, reference));
        }
    }

    @Override
    public String getName() {
        return Messages.ReferencesNode_labelReferences;
    }

    @Override
    public List<IReferenceNode> getReferences() {
        return this._references;
    }

    public int hashCode() {
        return this.getRoot().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReferencesNode) {
            return ((ReferencesNode)obj).getRoot() == this.getRoot();
        }
        return false;
    }
}

