/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.switchyard.config.OutputKey;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.switchyard.ArtifactModel;
import org.switchyard.config.model.switchyard.ArtifactsModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.ui.common.impl.SwitchYardProject;
import org.switchyard.tools.ui.i18n.Messages;

public class CreateArtifactReferenceOperation
implements IWorkspaceRunnable {
    private SwitchYardProject _switchYardProject;
    private String _name;
    private String _url;
    private IWorkspaceRunnable _downloadOperation;
    private IAdaptable _uiInfo;

    public CreateArtifactReferenceOperation(SwitchYardProject switchYardProject, String name, String url, IWorkspaceRunnable downloadOperation, IAdaptable uiInfo) {
        this._switchYardProject = switchYardProject;
        this._name = name;
        this._url = url;
        this._downloadOperation = downloadOperation;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.CreateArtifactReferenceOperation_taskLabel_addingArtifactReferenceToProject, 200);
        try {
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100, 4);
            try {
                try {
                    monitor.subTask(Messages.CreateArtifactReferenceOperation_taskLabel_updatingSYXMLFile);
                    this.updateSwitchYardFile((IProgressMonitor)subMonitor);
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.CreateArtifactReferenceOperation_exceptionMessage_errorUpdatingSYXMLFile, (Throwable)e));
                }
            }
            finally {
                subMonitor.done();
                subMonitor.setTaskName("");
            }
            if (this._downloadOperation == null) {
                return;
            }
            subMonitor = new SubProgressMonitor(monitor, 100, 4);
            monitor.subTask(Messages.CreateArtifactReferenceOperation_taskLabel_downloadingArtifactResource);
            try {
                this._downloadOperation.run((IProgressMonitor)subMonitor);
            }
            catch (CoreException e) {
                throw new CoreException((IStatus)new Status(2, "org.switchyard.tools.ui", Messages.CreateArtifactReferenceOperation_exceptionMessage_errorWhileDownloadingArtifact, (Throwable)e));
            }
        }
        finally {
            monitor.subTask("");
            monitor.done();
        }
    }

    private void updateSwitchYardFile(IProgressMonitor monitor) throws CoreException, ExecutionException, IOException {
        monitor.beginTask(Messages.CreateArtifactReferenceOperation_taskLabel_updatingSYXMLFile, 200);
        monitor.subTask(Messages.CreateArtifactReferenceOperation_taskLabel_loadingSYXMLFile);
        SwitchYardModel switchYardModel = this._switchYardProject.loadSwitchYardModel((IProgressMonitor)new NullProgressMonitor());
        monitor.worked(100);
        IFile switchYardFile = this._switchYardProject.getSwitchYardConfigurationFile();
        ArtifactsModel artifacts = switchYardModel.getArtifacts();
        if (artifacts == null) {
            artifacts = (ArtifactsModel)new ModelPuller().pull(new QName(this._switchYardProject.getSwitchYardNamespaceUri(), "artifacts"));
            switchYardModel.setArtifacts(artifacts);
        }
        ArtifactModel artifact = (ArtifactModel)new ModelPuller().pull(new QName(this._switchYardProject.getSwitchYardNamespaceUri(), "artifact"));
        artifact.setName(this._name);
        artifact.setURL(this._url);
        artifacts.addArtifact(artifact);
        monitor.subTask(Messages.CreateArtifactReferenceOperation_taskLabel_writingUpdatedSYXML);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        switchYardModel.getModelConfiguration().write((OutputStream)baos, new OutputKey[0]);
        if (switchYardFile.exists()) {
            switchYardFile.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        } else {
            try {
                new CreateFileOperation(switchYardFile, null, (InputStream)new ByteArrayInputStream(baos.toByteArray()), Messages.CreateArtifactReferenceOperation_operationLabel_creatingSYXMLFile).execute((IProgressMonitor)new SubProgressMonitor(monitor, 100), this._uiInfo);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof CoreException) {
                    throw (CoreException)e.getCause();
                }
                throw e;
            }
        }
    }
}

