/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.validation;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.tools.models.switchyard1_0.camel.CamelImplementationType;
import org.switchyard.tools.models.switchyard1_0.switchyard.EsbInterface;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.validation.SwitchYardProjectValidator;
import org.switchyard.tools.ui.validation.ValidationProblem;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CamelComponentConstraint
extends AbstractModelConstraint {
    private static final String CONFIGURE_METHOD = "configure";
    private static final String TO_TAG = "to";
    private static final String URI_ATTRIBUTE = "uri";
    private static final String FROM_TAG = "from";
    private static final String ROUTE_TAG = "route";

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof CamelImplementationType) {
            CamelImplementationType camelImpl = (CamelImplementationType)eObj;
            if (camelImpl.getJava() != null) {
                return this.validateJava(ctx, camelImpl);
            }
            if (camelImpl.getXml() != null) {
                return this.validateXML(ctx, camelImpl);
            }
            Component component = (Component)camelImpl.eContainer();
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelImplementationIncomplete.getSeverity(), (int)ValidationProblem.CamelImplementationIncomplete.ordinal(), (String)ValidationProblem.CamelImplementationIncomplete.getMessage(), (Object[])new Object[]{component.getName()});
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateXML(IValidationContext ctx, CamelImplementationType camelImpl) {
        Component component = (Component)camelImpl.eContainer();
        String xmlName = camelImpl.getXml().getPath();
        if (xmlName == null || xmlName.trim().isEmpty()) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelXMLUnspecified.getSeverity(), (int)ValidationProblem.CamelXMLUnspecified.ordinal(), (String)ValidationProblem.CamelXMLUnspecified.getMessage(), (Object[])new Object[]{component.getName()});
        }
        ArrayList<Object> statuses = new ArrayList<Object>();
        SwitchYardProjectValidator.ValidationAdapter adapter = (SwitchYardProjectValidator.ValidationAdapter)EcoreUtil.getAdapter((List)camelImpl.eResource().eAdapters(), SwitchYardProjectValidator.ValidationAdapter.class);
        IJavaProject javaProject = adapter.getJavaProject();
        IFile xmlFileResource = PlatformResourceAdapterFactory.getFileForObject(camelImpl, javaProject.getProject());
        if (xmlFileResource == null) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelXMLNotFound.getSeverity(), (int)ValidationProblem.CamelXMLNotFound.ordinal(), (String)ValidationProblem.CamelXMLNotFound.getMessage(), (Object[])new Object[]{xmlName, component.getName()});
        }
        if (xmlFileResource != null && xmlFileResource instanceof IFile) {
            IFile xmlFile = xmlFileResource;
            IPath location = xmlFile.getLocation();
            File file = location.toFile();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(file);
                NodeList routeTags = document.getElementsByTagName(ROUTE_TAG);
                if (routeTags.getLength() > 0) {
                    int i = 0;
                    while (i < routeTags.getLength()) {
                        Node routeTag = routeTags.item(i);
                        int switchyardFromCount = 0;
                        if (routeTag.hasChildNodes()) {
                            int j = 0;
                            while (j < routeTag.getChildNodes().getLength()) {
                                Node uriAttribute;
                                Node childNode = routeTag.getChildNodes().item(j);
                                if (childNode.getNodeName().equals(FROM_TAG) && (uriAttribute = childNode.getAttributes().getNamedItem(URI_ATTRIBUTE)) != null) {
                                    String switchyardString = uriAttribute.getNodeValue();
                                    IStatus status = this.verifyURI(switchyardString, ctx, component, true, javaProject);
                                    if (status != Status.OK_STATUS) {
                                        statuses.add(status);
                                    }
                                    if (switchyardString.startsWith("switchyard://")) {
                                        ++switchyardFromCount;
                                    }
                                }
                                ++j;
                            }
                            if (switchyardFromCount > 1) {
                                ConstraintStatus nodeStatus = ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteMoreThanOneFromFound.getSeverity(), (int)ValidationProblem.CamelRouteMoreThanOneFromFound.ordinal(), (String)ValidationProblem.CamelRouteMoreThanOneFromFound.getMessage(), (Object[])new Object[]{component.getName()});
                                statuses.add(nodeStatus);
                            } else if (switchyardFromCount == 0) {
                                ConstraintStatus status = ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteNoSYFromFound.getSeverity(), (int)ValidationProblem.CamelRouteNoSYFromFound.ordinal(), (String)ValidationProblem.CamelRouteNoSYFromFound.getMessage(), (Object[])new Object[]{component.getName()});
                                statuses.add(status);
                            }
                        } else {
                            ConstraintStatus status = ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteNoSYFromFound.getSeverity(), (int)ValidationProblem.CamelRouteNoSYFromFound.ordinal(), (String)ValidationProblem.CamelRouteNoSYFromFound.getMessage(), (Object[])new Object[]{component.getName()});
                            statuses.add(status);
                        }
                        ++i;
                    }
                } else {
                    ConstraintStatus status = ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteNoSYFromFound.getSeverity(), (int)ValidationProblem.CamelRouteNoSYFromFound.ordinal(), (String)ValidationProblem.CamelRouteNoSYFromFound.getMessage(), (Object[])new Object[]{component.getName()});
                    statuses.add(status);
                }
                NodeList toTags = document.getElementsByTagName(TO_TAG);
                if (toTags.getLength() > 0) {
                    int i = 0;
                    while (i < toTags.getLength()) {
                        String switchyardString;
                        IStatus status;
                        Node fromTag = toTags.item(i);
                        Node uriAttribute = fromTag.getAttributes().getNamedItem(URI_ATTRIBUTE);
                        if (uriAttribute != null && (status = this.verifyURI(switchyardString = uriAttribute.getNodeValue(), ctx, component, false, javaProject)) != Status.OK_STATUS) {
                            statuses.add(status);
                        }
                        ++i;
                    }
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    private IStatus validateJava(IValidationContext ctx, CamelImplementationType camelImpl) {
        Component component = (Component)camelImpl.eContainer();
        String className = camelImpl.getJava().getClass_();
        if (className == null || className.length() == 0) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelJavaUnspecifiedClass.getSeverity(), (int)ValidationProblem.CamelJavaUnspecifiedClass.ordinal(), (String)ValidationProblem.CamelJavaUnspecifiedClass.getMessage(), (Object[])new Object[]{component.getName()});
        }
        SwitchYardProjectValidator.ValidationAdapter adapter = (SwitchYardProjectValidator.ValidationAdapter)EcoreUtil.getAdapter((List)camelImpl.eResource().eAdapters(), SwitchYardProjectValidator.ValidationAdapter.class);
        IJavaProject javaProject = adapter.getJavaProject();
        try {
            IType javaClass;
            IType iType = javaClass = javaProject == null ? null : javaProject.findType(className);
            if (javaClass == null) {
                return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelJavaUnresolvableClass.getSeverity(), (int)ValidationProblem.CamelJavaUnresolvableClass.ordinal(), (String)ValidationProblem.CamelJavaUnresolvableClass.getMessage(), (Object[])new Object[]{className, component.getName()});
            }
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            adapter.addDependency(javaClass.getResource());
            statuses.add(this.validateRouteClass(camelImpl, className, javaProject, ctx, component));
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
        }
        catch (JavaModelException javaModelException) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelJavaUnresolvableClass.getSeverity(), (int)ValidationProblem.CamelJavaUnresolvableClass.ordinal(), (String)ValidationProblem.CamelJavaUnresolvableClass.getMessage(), (Object[])new Object[]{className, component.getName()});
        }
    }

    private boolean canFindSuperClass(IType searchType, String superClassName) throws JavaModelException {
        if (searchType.getSuperclassName() != null && searchType.getSuperclassName().contentEquals(superClassName)) {
            return true;
        }
        ITypeHierarchy supertypehierarchy = searchType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType supertype = supertypehierarchy.getSuperclass(searchType);
        if (supertype != null) {
            return this.canFindSuperClass(supertype, superClassName);
        }
        return false;
    }

    private IStatus validateRouteClass(CamelImplementationType impl, String className, IJavaProject javaProject, IValidationContext ctx, Component component) {
        ArrayList<Object> statuses = new ArrayList<Object>();
        try {
            IType javaClass;
            IType iType = javaClass = javaProject == null ? null : javaProject.findType(className);
            if (javaClass != null) {
                boolean extendsRouteBuilder = this.canFindSuperClass(javaClass, "RouteBuilder");
                if (!extendsRouteBuilder) {
                    return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelJavaWrongSuperclass.getSeverity(), (int)ValidationProblem.CamelJavaWrongSuperclass.ordinal(), (String)ValidationProblem.CamelJavaWrongSuperclass.getMessage(), (Object[])new Object[]{className, component.getName()});
                }
                IMethod[] methods = javaClass.getMethods();
                IMethod configureMethod = null;
                if (methods != null && methods.length > 0) {
                    int i = 0;
                    while (i < methods.length) {
                        IMethod method = methods[i];
                        if (method.getElementName().contentEquals(CONFIGURE_METHOD)) {
                            configureMethod = method;
                            break;
                        }
                        ++i;
                    }
                }
                if (configureMethod != null) {
                    IStatus status;
                    String switchyardString;
                    String source = configureMethod.getSource();
                    String tryThis = ".?from\\(\".*?\"\\)(.?)";
                    Pattern fromPattern = Pattern.compile(tryThis);
                    Matcher fromMatcher = fromPattern.matcher(source);
                    int fromCount = 0;
                    while (fromMatcher.find()) {
                        ++fromCount;
                    }
                    if (fromCount > 0) {
                        ConstraintStatus status2;
                        int switchyardFromCount = 0;
                        String tryThisNext = ".?(from)\\(\".*?\"\\)(.?)";
                        Pattern fromToPattern = Pattern.compile(tryThisNext);
                        Matcher fromToMatcher = fromToPattern.matcher(source);
                        while (fromToMatcher.find()) {
                            String fromToString = source.substring(fromToMatcher.start(), fromToMatcher.end());
                            Pattern switchyardPattern = Pattern.compile("switchyard://.*\"");
                            Matcher switchyardMatcher = switchyardPattern.matcher(fromToString);
                            boolean isFrom = fromToString.matches(tryThis);
                            while (switchyardMatcher.find()) {
                                switchyardString = fromToString.substring(switchyardMatcher.start(), switchyardMatcher.end() - 1);
                                status = this.verifyURI(switchyardString, ctx, component, isFrom, javaProject);
                                if (status != Status.OK_STATUS) {
                                    statuses.add(status);
                                }
                                if (switchyardString.startsWith("switchyard://")) {
                                    ++switchyardFromCount;
                                    continue;
                                }
                                if (switchyardFromCount != 0) continue;
                                status = ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteNoSYFromFound.getSeverity(), (int)ValidationProblem.CamelRouteNoSYFromFound.ordinal(), (String)ValidationProblem.CamelRouteNoSYFromFound.getMessage(), (Object[])new Object[]{component.getName()});
                                statuses.add(status);
                            }
                        }
                        if (switchyardFromCount > 1) {
                            status2 = ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteMoreThanOneFromFound.getSeverity(), (int)ValidationProblem.CamelRouteMoreThanOneFromFound.ordinal(), (String)ValidationProblem.CamelRouteMoreThanOneFromFound.getMessage(), (Object[])new Object[]{component.getName()});
                            statuses.add(status2);
                        } else if (switchyardFromCount == 0) {
                            status2 = ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteNoSYFromFound.getSeverity(), (int)ValidationProblem.CamelRouteNoSYFromFound.ordinal(), (String)ValidationProblem.CamelRouteNoSYFromFound.getMessage(), (Object[])new Object[]{component.getName()});
                            statuses.add(status2);
                        }
                    } else {
                        ConstraintStatus status3 = ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteNoSYFromFound.getSeverity(), (int)ValidationProblem.CamelRouteNoSYFromFound.ordinal(), (String)ValidationProblem.CamelRouteNoSYFromFound.getMessage(), (Object[])new Object[]{component.getName()});
                        statuses.add(status3);
                    }
                    String tryThisNext = ".?to\\(\".*?\"\\)(.?)";
                    Pattern toPattern = Pattern.compile(tryThisNext);
                    Matcher toMatcher = fromPattern.matcher(source);
                    int toCount = 0;
                    while (toMatcher.find()) {
                        ++toCount;
                    }
                    if (toCount > 0) {
                        String tryThisPatternNext = ".?(to)\\(\".*?\"\\)(.?)";
                        toPattern = Pattern.compile(tryThisPatternNext);
                        toMatcher = toPattern.matcher(source);
                        while (toMatcher.find()) {
                            String toString = source.substring(toMatcher.start(), toMatcher.end());
                            Pattern switchyardPattern = Pattern.compile("switchyard://.*\"");
                            Matcher switchyardMatcher = switchyardPattern.matcher(toString);
                            while (switchyardMatcher.find()) {
                                switchyardString = toString.substring(switchyardMatcher.start(), switchyardMatcher.end() - 1);
                                status = this.verifyURI(switchyardString, ctx, component, false, javaProject);
                                if (status == Status.OK_STATUS) continue;
                                statuses.add(status);
                            }
                        }
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelJavaUnresolvableClass.getSeverity(), (int)ValidationProblem.CamelJavaUnresolvableClass.ordinal(), (String)ValidationProblem.CamelJavaUnresolvableClass.getMessage(), (Object[])new Object[]{className, component.getName()});
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    private ComponentService findService(String serviceName, Component component) {
        if (component != null && !component.getService().isEmpty()) {
            EList list = component.getService();
            for (ComponentService cs : list) {
                if (!cs.getName().equals(serviceName)) continue;
                return cs;
            }
        }
        return null;
    }

    private ComponentReference findReference(String referenceName, Component component) {
        if (component != null && !component.getReference().isEmpty()) {
            EList list = component.getReference();
            for (ComponentReference cr : list) {
                if (!cr.getName().equals(referenceName)) continue;
                return cr;
            }
        }
        return null;
    }

    private IStatus verifyURI(String uriValue, IValidationContext ctx, Component component, boolean isFrom, IJavaProject javaProject) {
        ArrayList<ConstraintStatus> statuses = new ArrayList<ConstraintStatus>();
        URI testURI = null;
        try {
            testURI = new URI(uriValue);
        }
        catch (URISyntaxException ex) {
            String fromOrTo = "TO";
            if (isFrom) {
                fromOrTo = "FROM";
            }
            statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteURIInvalid.getSeverity(), (int)ValidationProblem.CamelRouteURIInvalid.ordinal(), (String)ValidationProblem.CamelRouteURIInvalid.getMessage(), (Object[])new Object[]{fromOrTo, component.getName(), ex.getLocalizedMessage()}));
        }
        if (testURI != null) {
            String scheme = testURI.getScheme();
            ComponentService serviceFound = null;
            ComponentReference referenceFound = null;
            if (scheme.equals("switchyard")) {
                String schemeName = testURI.getAuthority();
                if (isFrom) {
                    String serviceName = schemeName;
                    serviceFound = this.findService(serviceName, component);
                    if (serviceFound == null) {
                        statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.MissingServiceDeclaration.getSeverity(), (int)ValidationProblem.MissingServiceDeclaration.ordinal(), (String)ValidationProblem.MissingServiceDeclaration.getMessage(), (Object[])new Object[]{serviceName, component.getName()}));
                    }
                } else {
                    String referenceName = schemeName;
                    referenceFound = this.findReference(referenceName, component);
                    if (referenceFound == null) {
                        statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.MissingReferenceDeclaration.getSeverity(), (int)ValidationProblem.MissingReferenceDeclaration.ordinal(), (String)ValidationProblem.MissingReferenceDeclaration.getMessage(), (Object[])new Object[]{referenceName, component.getName()}));
                    }
                }
                String operationName = this.getOperationName(testURI);
                if (!isFrom && operationName != null && referenceFound != null) {
                    if (!this.checkInterfaceForOperation(referenceFound.getInterface(), operationName, javaProject)) {
                        statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteOperationNotFoundAsReference.getSeverity(), (int)ValidationProblem.CamelRouteOperationNotFoundAsReference.ordinal(), (String)ValidationProblem.CamelRouteOperationNotFoundAsReference.getMessage(), (Object[])new Object[]{operationName, referenceFound.getName()}));
                    }
                } else if (isFrom && operationName != null && serviceFound != null && !this.checkInterfaceForOperation(serviceFound.getInterface(), operationName, javaProject)) {
                    statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteOperationNotFoundAsService.getSeverity(), (int)ValidationProblem.CamelRouteOperationNotFoundAsService.ordinal(), (String)ValidationProblem.CamelRouteOperationNotFoundAsService.getMessage(), (Object[])new Object[]{operationName, serviceFound.getName()}));
                }
                if (operationName == null && referenceFound != null && !this.checkInterfaceForNumberOfOperations(referenceFound.getInterface(), javaProject)) {
                    statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)component, null, (int)ValidationProblem.CamelRouteOperationRequiredNotSpecified.getSeverity(), (int)ValidationProblem.CamelRouteOperationRequiredNotSpecified.ordinal(), (String)ValidationProblem.CamelRouteOperationRequiredNotSpecified.getMessage(), (Object[])new Object[]{component.getName()}));
                }
            }
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    private String getOperationName(URI uri) {
        String query;
        block5: {
            query = uri.getQuery();
            if (query != null) break block5;
            return null;
        }
        try {
            String[] stringArray = URLDecoder.decode(query, "UTF-8").split("&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                String pair = stringArray[n2];
                int index = pair.indexOf(61);
                if (index >= 0 && "operationName".equals(name = pair.substring(0, index))) {
                    return pair.substring(index + 1);
                }
                ++n2;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean checkInterfaceForOperation(Interface intfc, String opName, IJavaProject javaProject) {
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JavaUtil.getProjectClassLoader(JavaCore.create((IProject)WorkspaceSynchronizer.getFile((Resource)intfc.eResource()).getProject()), ((Object)((Object)this)).getClass().getClassLoader()));
            if (intfc instanceof JavaInterface) {
                IType javaClass;
                JavaInterface javaIntfc = (JavaInterface)intfc;
                String className = javaIntfc.getInterface();
                IType iType = javaClass = javaProject == null ? null : javaProject.findType(className);
                if (javaClass != null && javaClass.getMethods() != null && javaClass.getMethods().length > 0) {
                    int i = 0;
                    while (i < javaClass.getMethods().length) {
                        IMethod method = javaClass.getMethods()[i];
                        if (method.getElementName().equals(opName)) {
                            return true;
                        }
                        ++i;
                    }
                }
            } else {
                if (intfc instanceof EsbInterface) {
                    return true;
                }
                ServiceInterface serviceIntfc = SwitchYardModelUtils.getServiceInterface(intfc);
                if (serviceIntfc != null && serviceIntfc.getOperations() != null) {
                    if (serviceIntfc.getOperation(opName) != null) {
                        return true;
                    }
                    QName qname = new QName(opName);
                    if (serviceIntfc.getOperation(qname.getLocalPart()) != null) {
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
        return false;
    }

    private boolean checkInterfaceForNumberOfOperations(Interface intfc, IJavaProject javaProject) {
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JavaUtil.getProjectClassLoader(JavaCore.create((IProject)WorkspaceSynchronizer.getFile((Resource)intfc.eResource()).getProject()), ((Object)((Object)this)).getClass().getClassLoader()));
            if (intfc instanceof JavaInterface) {
                IType javaClass;
                JavaInterface javaIntfc = (JavaInterface)intfc;
                String className = javaIntfc.getInterface();
                IType iType = javaClass = javaProject == null ? null : javaProject.findType(className);
                if (javaClass != null && javaClass.getMethods() != null && javaClass.getMethods().length < 2) {
                    return true;
                }
            } else {
                if (intfc instanceof EsbInterface) {
                    return true;
                }
                ServiceInterface serviceIntfc = SwitchYardModelUtils.getServiceInterface(intfc);
                if (serviceIntfc != null && serviceIntfc.getOperations() != null && serviceIntfc.getOperations().size() < 2) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
        return false;
    }
}

