/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.validation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.switchyard.tools.models.switchyard1_0.switchyard.DocumentRoot;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.validation.ValidationProblem;

public class SwitchYardProjectValidator
extends AbstractValidator {
    public static final String SWITCHYARD_MARKER_ID = "org.switchyard.tools.ui.problemMarker";

    public static SwitchYardType getSwitchYard(Resource resource) {
        if (resource == null || resource.getContents().isEmpty()) {
            return null;
        }
        EObject docroot = (EObject)resource.getContents().get(0);
        if (docroot instanceof DocumentRoot) {
            return ((DocumentRoot)docroot).getSwitchyard();
        }
        if (docroot instanceof SwitchYardType) {
            return (SwitchYardType)docroot;
        }
        return null;
    }

    public ValidationResult validate(ValidationEvent event, ValidationState state, IProgressMonitor monitor) {
        ValidationResult result = new ValidationResult();
        if ((event.getKind() & 2) != 0 || event.getResource().isDerived(512)) {
            return result;
        }
        ISwitchYardProject switchYardProject = SwitchYardProjectManager.instance().getSwitchYardProject(event.getResource().getProject());
        if (switchYardProject.needsLoading()) {
            switchYardProject.load((IProgressMonitor)new NullProgressMonitor());
        }
        IFile switchYardOutput = switchYardProject.getOutputSwitchYardConfigurationFile();
        if (event.getResource().equals((Object)switchYardProject.getSwitchYardConfigurationFile())) {
            if (switchYardOutput == null) {
                switchYardOutput = event.getResource();
            } else {
                result.setDependsOn(new IResource[]{switchYardOutput});
                if (!switchYardOutput.exists() || switchYardOutput.getModificationStamp() < event.getResource().getModificationStamp() || event.getDependsOn() != null && (event.getDependsOn().getKind() & 2) != 0 && event.getDependsOn().findMember(switchYardOutput.getFullPath()) != null) {
                    return result;
                }
            }
        } else {
            switchYardOutput = event.getResource();
        }
        try {
            event.getResource().deleteMarkers(SWITCHYARD_MARKER_ID, true, 0);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        ResourceSet rs = SwitchYardModelUtils.newResourceSet();
        Resource resource = rs.createResource(URI.createPlatformResourceURI((String)switchYardOutput.getFullPath().toString(), (boolean)false), "org.switchyard.content-type.1.x");
        try {
            resource.load(null);
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
        try {
            if (resource.getContents().isEmpty()) {
                ValidatorMessage message = ValidatorMessage.create((String)Messages.SwitchYardProjectValidator_validatorMessage_InvalidSYXMLFile, (IResource)event.getResource());
                message.setType(SWITCHYARD_MARKER_ID);
                result.add(message);
            } else {
                IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
                ValidationAdapter adapter = new ValidationAdapter((IResource)switchYardOutput, result.getDependsOn());
                resource.eAdapters().add((Object)adapter);
                this.processStatus(validator.validate((Collection)resource.getContents(), monitor), event.getResource(), result, !switchYardOutput.equals((Object)event.getResource()));
                result.setDependsOn(adapter._dependencies.toArray(new IResource[adapter._dependencies.size()]));
            }
            ValidationResult validationResult = result;
            return validationResult;
        }
        finally {
            resource.unload();
        }
    }

    private void processStatus(IStatus status, IResource resource, ValidationResult result, boolean patchURIs) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.processStatus(child, resource, result, patchURIs);
                ++n2;
            }
        } else if (!status.isOK()) {
            result.add(this.createValidationMessage(status, resource, patchURIs));
        }
    }

    private ValidatorMessage createValidationMessage(IStatus status, IResource resource, boolean patchURIs) {
        ValidatorMessage message = ValidatorMessage.create((String)status.getMessage(), (IResource)resource);
        switch (status.getSeverity()) {
            case 1: {
                message.setAttribute("severity", 0);
                break;
            }
            case 2: {
                message.setAttribute("severity", 1);
                break;
            }
            case 4: 
            case 8: {
                message.setAttribute("severity", 2);
            }
        }
        if (status instanceof IConstraintStatus) {
            IConstraintStatus ics = (IConstraintStatus)status;
            message.setAttribute("uri", (Object)this.getURIStringForObject(ics.getTarget(), patchURIs));
            message.setAttribute("rule", (Object)ics.getConstraint().getDescriptor().getId());
            message.setAttribute(ValidationProblem.PROBLEM_CODE, ics.getCode());
            if (ics.getResultLocus().size() > 0) {
                StringBuffer relatedUris = new StringBuffer();
                for (EObject eobject : ics.getResultLocus()) {
                    relatedUris.append(this.getURIStringForObject(eobject, patchURIs)).append(" ");
                }
                relatedUris.deleteCharAt(relatedUris.length() - 1);
                message.setAttribute("relatedURIs", (Object)relatedUris.toString());
            }
        }
        message.setType(SWITCHYARD_MARKER_ID);
        return message;
    }

    private String getURIStringForObject(EObject object, boolean patchURI) {
        URI objectURI = EcoreUtil.getURI((EObject)object);
        if (patchURI) {
            return URI.createGenericURI((String)"switchyard", (String)"generated", (String)objectURI.fragment()).toString();
        }
        return objectURI.toString();
    }

    public void clean(IProject project, ValidationState state, IProgressMonitor monitor) {
        super.clean(project, state, monitor);
        try {
            project.deleteMarkers(SWITCHYARD_MARKER_ID, true, 2);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public static final class ValidationAdapter
    extends AdapterImpl {
        private final Set<IResource> _dependencies = new LinkedHashSet<IResource>();
        private final IProject _project;
        private IJavaProject _javaProject;

        public ValidationAdapter(IProject project) {
            this(project, null);
        }

        private ValidationAdapter(IResource switchYardFile, IResource[] dependencies) {
            this(switchYardFile.getProject(), dependencies);
        }

        private ValidationAdapter(IProject project, IResource[] dependencies) {
            this._project = project;
            if (dependencies != null) {
                this._dependencies.addAll(Arrays.asList(dependencies));
            }
        }

        public IProject getProject() {
            return this._project;
        }

        public synchronized IJavaProject getJavaProject() {
            if (this._javaProject == null) {
                this._javaProject = JavaCore.create((IProject)this._project);
            }
            return this._javaProject;
        }

        public void addDependency(IResource dependency) {
            if (dependency != null) {
                this._dependencies.add(dependency);
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == ((Object)((Object)this)).getClass();
        }
    }
}

