/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.switchyard.tools.ui.validation.ValidationProblem;

public class ValidationStatusAdapter
extends AdapterImpl {
    private List<IStatus> _validationStatus = new ArrayList<IStatus>();
    private Set<String> _breakpoints = new HashSet<String>();
    private Map<EObject, List<IStatus>> _connectionStatus = new HashMap<EObject, List<IStatus>>();

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(((Object)((Object)this)).getClass());
    }

    public Set<String> getBreakpoints() {
        return Collections.unmodifiableSet(this._breakpoints);
    }

    public boolean hasBreakpoints(String type) {
        return this._breakpoints.contains(type);
    }

    public boolean hasBreakpoints() {
        return this._breakpoints.size() > 0;
    }

    public void addBreakpoint(String type) {
        this._breakpoints.add(type);
    }

    public void removeBreakpoint(String type) {
        this._breakpoints.remove(type);
    }

    public IStatus getValidationStatus() {
        return this.createStatus(this._validationStatus);
    }

    public IStatus getConnectionStatus(EObject target) {
        return this.createStatus(this._connectionStatus.get(target));
    }

    public void clearValidationStatus() {
        this._validationStatus.clear();
        this._connectionStatus.clear();
    }

    public void addValidationStatus(IStatus status) {
        if (ValidationProblem.isConnectionProblem(status.getCode()) && status instanceof IConstraintStatus) {
            for (EObject other : ((IConstraintStatus)status).getResultLocus()) {
                if (other == this.getTarget()) continue;
                this.addConnectionStatus(other, status);
                return;
            }
        }
        this._validationStatus.add(status);
    }

    private void addConnectionStatus(EObject target, IStatus status) {
        List<IStatus> statuses = this._connectionStatus.get(target);
        if (statuses == null) {
            statuses = new ArrayList<IStatus>();
            this._connectionStatus.put(target, statuses);
        }
        statuses.add(status);
    }

    private IStatus createStatus(List<? extends IStatus> statuses) {
        if (statuses == null) {
            return Status.OK_STATUS;
        }
        switch (statuses.size()) {
            case 0: {
                return Status.OK_STATUS;
            }
            case 1: {
                return statuses.get(0);
            }
        }
        return new MultiStatusWithMessage(statuses.toArray(new IStatus[statuses.size()]));
    }

    private static class MultiStatusWithMessage
    extends MultiStatus {
        private String _message;

        public MultiStatusWithMessage(IStatus[] newChildren) {
            super("org.switchyard.tools.ui", 0, newChildren, "", null);
        }

        public String getMessage() {
            if (this._message != null) {
                return this._message;
            }
            if (this.getChildren().length == 0) {
                return super.getMessage();
            }
            StringBuffer sb = new StringBuffer();
            IStatus[] iStatusArray = this.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status = iStatusArray[n2];
                if (!status.isOK()) {
                    sb.append(" - ").append(status.getMessage()).append('\n');
                }
                ++n2;
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            this._message = sb.toString();
            return this._message;
        }
    }
}

