/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.common.ContractControl;
import org.switchyard.tools.ui.common.InterfaceControl;
import org.switchyard.tools.ui.explorer.ISwitchYardNode;
import org.switchyard.tools.ui.explorer.impl.ComponentReference;
import org.switchyard.tools.ui.i18n.Messages;

public class NewBeanServiceClassWizardPage
extends NewTypeWizardPage {
    private static final String SERVICE_INTERFACE = "SERVICE_INTERFACE";
    private ContractControl _serviceInterfaceControl;
    private SelectionButtonDialogField _createTestClassButton;
    private IStatus _serviceInterfaceStatus;
    private String _oldTypeName;

    public NewBeanServiceClassWizardPage() {
        super(true, NewBeanServiceClassWizardPage.class.getSimpleName());
        this.setTitle(Messages.NewBeanServiceClassWizardPage_wizardPageTitle);
        this.setDescription(Messages.NewBeanServiceClassWizardPage_wizardPageDescription);
        this._serviceInterfaceControl = new ContractControl(ScaPackage.eINSTANCE.getComponentService(), this.getJavaProject(), EnumSet.of(InterfaceControl.InterfaceType.Java));
        this._serviceInterfaceControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewBeanServiceClassWizardPage.this.handleFieldChanged(NewBeanServiceClassWizardPage.SERVICE_INTERFACE);
            }
        });
        this._createTestClassButton = new SelectionButtonDialogField(32);
        this._createTestClassButton.setLabelText(Messages.NewBeanServiceClassWizardPage_buttonLabelCreateTestClass);
        this._createTestClassButton.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                NewBeanServiceClassWizardPage.this.createTestClassChanged();
            }
        });
    }

    public void init(IStructuredSelection selection) {
        ICompilationUnit cu;
        IJavaElement elem = this.getInitialJavaElement(selection);
        ICompilationUnit iCompilationUnit = cu = elem == null ? null : (ICompilationUnit)elem.getAncestor(5);
        if (cu != null) {
            elem = cu.findPrimaryType();
        }
        this.initContainerPage(this.getInitialContainerElement(selection, elem));
        this.initTypePage(elem);
        List<String> superInterfaces = this.getSuperInterfaces();
        if (superInterfaces.size() > 0) {
            this.initServiceInterface(superInterfaces.get(0));
        }
        this.setModifiers(1, false);
        this._createTestClassButton.setSelection(false);
        this.doStatusUpdate();
    }

    public void forceServiceInterfaceType(ComponentService serviceInterface) {
        if (serviceInterface == null) {
            return;
        }
        this._serviceInterfaceControl.init((Contract)serviceInterface, null);
        this._serviceInterfaceControl.setEnabled(false);
        this.serviceInterfaceChanged();
    }

    private void initServiceInterface(String interfaceName) {
        if (interfaceName == null || interfaceName.length() == 0) {
            return;
        }
        JavaInterface javaInterface = ScaFactory.eINSTANCE.createJavaInterface();
        javaInterface.setInterface(interfaceName);
        this._serviceInterfaceControl.setInterface((Interface)javaInterface);
        this.serviceInterfaceChanged();
        List<String> superInterfaces = this.getSuperInterfaces();
        if (superInterfaces != null && superInterfaces.remove(interfaceName)) {
            this.setSuperInterfaces(superInterfaces, this.getPackageFragmentRoot() != null);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createServiceInterfaceControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    public List<String> getSuperInterfaces() {
        List result = super.getSuperInterfaces();
        JavaInterface serviceInterface = this.getServiceInterface();
        if (serviceInterface != null && serviceInterface.getInterface() != null && serviceInterface.getInterface().length() > 0) {
            result.add(0, serviceInterface.getInterface());
        }
        return result;
    }

    public boolean addSuperInterface(String superInterface) {
        if (superInterface.equals(this.getServiceInterface())) {
            return false;
        }
        return super.addSuperInterface(superInterface);
    }

    public void setSuperInterfaces(List<String> interfacesNames, boolean canBeModified) {
        JavaInterface serviceInterface = this.getServiceInterface();
        if (serviceInterface != null && serviceInterface.getInterface() != null) {
            interfacesNames.remove(serviceInterface.getInterface());
        }
        super.setSuperInterfaces(interfacesNames, canBeModified);
    }

    protected String constructCUContent(ICompilationUnit cu, String typeContent, String lineDelimiter) throws CoreException {
        String simpleServiceInterfaceName = this.getSimpleServiceInterfaceName((Interface)this.getServiceInterface());
        String serviceAnnotation = simpleServiceInterfaceName == null || simpleServiceInterfaceName.equals(this.getServiceName()) ? "@Service(" + simpleServiceInterfaceName + ".class)" + lineDelimiter : "@Service(value=" + simpleServiceInterfaceName + ".class, name=\"" + this.getServiceName() + "\")" + lineDelimiter;
        return super.constructCUContent(cu, String.valueOf(serviceAnnotation) + typeContent, lineDelimiter);
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(type, false, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        imports.addImport("org.switchyard.component.bean.Service");
        if (monitor != null) {
            monitor.done();
        }
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof ISwitchYardNode) {
            IResource javaInterface;
            ComponentReference componentReference;
            ComponentReferenceModel reference;
            if (selection.getFirstElement() instanceof ComponentReference && (reference = (componentReference = (ComponentReference)selection.getFirstElement()).getModel()).getInterface() != null && "java".equals(reference.getInterface().getType()) && (javaInterface = SwitchYardModelUtils.getAssociatedResource(componentReference.getRoot().getProject(), reference.getInterface())) != null) {
                return super.getInitialJavaElement((IStructuredSelection)new StructuredSelection((Object)javaInterface));
            }
            return JavaUtil.getInitialJavaElementForResource((IResource)((ISwitchYardNode)selection.getFirstElement()).getRoot().getProject());
        }
        return super.getInitialJavaElement(selection);
    }

    private IJavaElement getInitialContainerElement(IStructuredSelection selection, IJavaElement initialElement) {
        if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof ISwitchYardNode) {
            ISwitchYardNode switchYardNode = (ISwitchYardNode)selection.getFirstElement();
            if (initialElement == null || initialElement.getJavaProject() == null || !initialElement.getJavaProject().getProject().equals((Object)switchYardNode.getRoot().getProject())) {
                return JavaCore.create((IProject)switchYardNode.getRoot().getProject());
            }
        }
        return initialElement;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == SERVICE_INTERFACE) {
            this.serviceInterfaceChanged();
        } else if (fieldName == "NewContainerWizardPage.container") {
            this._serviceInterfaceControl.setProject(this.getJavaProject());
            this.serviceInterfaceChanged();
        }
        this.doStatusUpdate();
    }

    public void setCreateTestClass(boolean createTestClass) {
        this._createTestClassButton.setSelection(createTestClass);
    }

    public boolean getCreateTestClass() {
        return this._createTestClassButton.isSelected();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus, this._serviceInterfaceStatus};
        this.updateStatus(status);
    }

    public Contract getServiceContract() {
        return this._serviceInterfaceControl.getContract();
    }

    private JavaInterface getServiceInterface() {
        Interface intf = this.getServiceContract().getInterface();
        if (intf instanceof JavaInterface) {
            return (JavaInterface)intf;
        }
        return null;
    }

    private void createTestClassChanged() {
        IWizard wizard = this.getWizard();
        if (wizard != null) {
            wizard.getContainer().updateButtons();
        }
        this.doStatusUpdate();
    }

    private void createServiceInterfaceControls(Composite composite, int nColumns) {
        this._serviceInterfaceControl.createControl(composite, nColumns);
    }

    private void serviceInterfaceChanged() {
        this._serviceInterfaceControl.setProject(this.getJavaProject());
        this._serviceInterfaceStatus = this._serviceInterfaceControl.getStatus();
        this.setSuperInterfaces(super.getSuperInterfaces(), true);
        String newName = this.createDefaultClassName();
        if (this.updateDefault(this._oldTypeName, newName, this.getTypeName())) {
            this.setTypeName(newName, true);
        }
        this._oldTypeName = newName;
    }

    private String getSimpleServiceInterfaceName(Interface serviceInterface) {
        if (serviceInterface == null || !(serviceInterface instanceof JavaInterface) || ((JavaInterface)serviceInterface).getInterface() == null) {
            return "";
        }
        String serviceInterfaceName = ((JavaInterface)serviceInterface).getInterface();
        int lastDotIndex = serviceInterfaceName.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return serviceInterfaceName.substring(lastDotIndex + 1);
        }
        return serviceInterfaceName;
    }

    private String getServiceName() {
        return this._serviceInterfaceControl.getContract().getName();
    }

    private String createDefaultClassName() {
        String serviceName = this.getServiceName();
        if (serviceName == null) {
            return "";
        }
        return String.valueOf(serviceName) + "Bean";
    }

    private boolean updateDefault(String oldValue, String newValue, String currentValue) {
        return currentValue == null || currentValue.length() == 0 || !currentValue.equals(newValue) && (oldValue == null || oldValue.length() == 0 || oldValue.equals(currentValue));
    }
}

