/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.CreateElementInCUOperation;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.soa.sca.sca1_1.model.sca.util.ScaSwitch;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.tools.models.switchyard1_0.switchyard.DocumentRoot;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.util.SwitchyardResourceFactoryImpl;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.M2EUtils;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.common.ISwitchYardTestMixInExtension;
import org.switchyard.tools.ui.common.InterfaceControl;
import org.switchyard.tools.ui.common.SwitchYardComponentExtensionManager;
import org.switchyard.tools.ui.common.SwitchYardTestMixInExtensionManager;
import org.switchyard.tools.ui.explorer.ISwitchYardNode;
import org.switchyard.tools.ui.explorer.impl.ComponentService;
import org.switchyard.tools.ui.i18n.Messages;

public class NewServiceTestClassWizardPage
extends NewTypeWizardPage {
    private static final String SERVICE_INTERFACE = "SERVICE_INTERFACE";
    private ComboDialogField _serviceDialogField;
    private InterfaceControl _interfaceControl;
    private StatusInfo _serviceInterfaceStatus;
    private StatusInfo _rootStatus;
    private Map<String, Contract> _configuredServices;
    private Map<File, Map<String, Contract>> _servicesCache = new HashMap<File, Map<String, Contract>>();
    private Set<Resource> _loadedResources = new HashSet<Resource>();
    private IMavenProjectFacade _mavenProjectFacade;
    private IProject _project;
    private String _oldTypeName;
    private CheckboxTableViewer _componentsTable;
    private Object[] _checkedMixins = new Object[0];

    public NewServiceTestClassWizardPage() {
        super(true, NewServiceTestClassWizardPage.class.getSimpleName());
        this.setTitle(Messages.NewServiceTestClassWizardPage_wizardPageTitle);
        this.setDescription(Messages.NewServiceTestClassWizardPage_wizardPageDescription);
        this._serviceDialogField = new ComboDialogField(12);
        this._serviceDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                NewServiceTestClassWizardPage.this.handleFieldChanged(NewServiceTestClassWizardPage.SERVICE_INTERFACE);
            }
        });
        this._serviceDialogField.setLabelText(Messages.NewServiceTestClassWizardPage_labelService);
        this._interfaceControl = new InterfaceControl(this.getJavaProject());
    }

    public void init(IStructuredSelection selection) {
        IPath[] testSourcePaths;
        String simpleServiceInterfaceName;
        ICompilationUnit cu;
        IJavaElement elem = this.getInitialJavaElement(selection);
        ICompilationUnit iCompilationUnit = cu = elem == null ? null : (ICompilationUnit)elem.getAncestor(5);
        if (cu != null) {
            elem = cu.findPrimaryType();
        }
        this.initContainerPage(this.getInitialContainerElement(selection, elem));
        this.initTypePage(elem);
        this.setSuperClass("", true);
        this.setSuperInterfaces(Collections.emptyList(), true);
        this.setModifiers(1, false);
        if (this.getTypeName().length() == 0 && (simpleServiceInterfaceName = this.getSimpleServiceInterfaceName()).length() > 0) {
            this._oldTypeName = this.createDefaultClassName();
            this.setTypeName(this._oldTypeName, true);
        }
        if (this._mavenProjectFacade != null && (testSourcePaths = this._mavenProjectFacade.getTestCompileSourceLocations()) != null && testSourcePaths.length > 0) {
            this.setPackageFragmentRoot(this.getJavaProject().getPackageFragmentRoot((IResource)this._project.getFolder(testSourcePaths[0])), true);
        }
        this.setSuperInterfaces(Collections.emptyList(), false);
        this.doStatusUpdate();
    }

    public void createControl(org.eclipse.swt.widgets.Composite parent) {
        this.initializeDialogUnits((Control)parent);
        org.eclipse.swt.widgets.Composite composite = new org.eclipse.swt.widgets.Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createServiceInterfaceControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createMixInsTable(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    public void setServiceContract(Contract serviceContract, boolean canBeModified) {
        if (canBeModified) {
            if (!this._serviceDialogField.isEnabled()) {
                this.loadConfiguredServices();
                if (this._configuredServices.size() == 0 && serviceContract.getName() != null) {
                    this._configuredServices = Collections.singletonMap(serviceContract.getName(), serviceContract);
                }
                this.updateServicesList();
            }
        } else {
            this._configuredServices = serviceContract.getName() != null ? Collections.singletonMap(serviceContract.getName(), serviceContract) : Collections.emptyMap();
            this._serviceDialogField.setEnabled(false);
            this.updateServicesList();
        }
        this._serviceDialogField.selectItem(serviceContract.getName());
    }

    public void dispose() {
        super.dispose();
        this._configuredServices = Collections.emptyMap();
        for (Map<String, Contract> configuredServices : this._servicesCache.values()) {
            configuredServices.clear();
        }
        this._servicesCache.clear();
        for (Resource resource : this._loadedResources) {
            resource.unload();
        }
        this._loadedResources.clear();
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof ISwitchYardNode) {
            IResource javaInterface;
            ComponentService componentService;
            ComponentServiceModel service;
            if (selection.getFirstElement() instanceof ComponentService && (service = (componentService = (ComponentService)selection.getFirstElement()).getModel()).getInterface() != null && "java".equals(service.getInterface().getType()) && (javaInterface = SwitchYardModelUtils.getAssociatedResource(componentService.getRoot().getProject(), service.getInterface())) != null) {
                return super.getInitialJavaElement((IStructuredSelection)new StructuredSelection((Object)javaInterface));
            }
            return JavaUtil.getInitialJavaElementForResource((IResource)((ISwitchYardNode)selection.getFirstElement()).getRoot().getProject());
        }
        return super.getInitialJavaElement(selection);
    }

    private IJavaElement getInitialContainerElement(IStructuredSelection selection, IJavaElement initialElement) {
        if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof ISwitchYardNode) {
            ISwitchYardNode switchYardNode = (ISwitchYardNode)selection.getFirstElement();
            if (initialElement == null || initialElement.getJavaProject() == null || !initialElement.getJavaProject().getProject().equals((Object)switchYardNode.getRoot().getProject())) {
                return JavaCore.create((IProject)switchYardNode.getRoot().getProject());
            }
        }
        return initialElement;
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.addTypeAnnotations(type, imports, monitor);
        String lineDelimiter = this.getJavaProject().getJavaModel().findRecommendedLineSeparator();
        type.createField("private " + imports.addImport("org.switchyard.test.SwitchYardTestKit") + " testKit;", null, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        for (String mixin : this.getSelectedMixinClasses()) {
            type.createField("private " + imports.addImport(mixin) + " " + this.getFieldNameForType(mixin) + ";", null, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        type.createField("@" + imports.addImport("org.switchyard.test.ServiceOperation") + "(\"" + this.getSimpleServiceInterfaceName() + "\")" + lineDelimiter + "private " + imports.addImport(Messages.NewServiceTestClassWizardPage_16) + " service;", null, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ServiceInterface serviceTypeBinding = this.resolveServiceType();
        if (serviceTypeBinding == null) {
            return;
        }
        this.createTestMethodsForType(type, serviceTypeBinding, type.getCompilationUnit(), imports, lineDelimiter, monitor);
        if (monitor != null) {
            monitor.done();
        }
    }

    private String getFieldNameForType(String mixin) {
        int lastDot = mixin.lastIndexOf(46);
        StringBuffer simpleName = new StringBuffer();
        if (lastDot > 0) {
            simpleName.append(mixin.substring(lastDot + 1));
        } else {
            simpleName.append(mixin);
        }
        int lastUpper = 0;
        int nextUpper = 1;
        int length = simpleName.length();
        while (lastUpper < length && Character.isUpperCase(simpleName.charAt(lastUpper)) && (nextUpper == length || Character.isUpperCase(simpleName.charAt(nextUpper)))) {
            simpleName.setCharAt(lastUpper, Character.toLowerCase(simpleName.charAt(lastUpper)));
            ++lastUpper;
            ++nextUpper;
        }
        return simpleName.toString();
    }

    private void addTypeAnnotations(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws JavaModelException {
        new CreateSwitchYardTestAnnotationOperation(type, imports).runOperation(monitor);
        new CreateRunWithAnnotationOperation(type, imports).runOperation(monitor);
    }

    private void createTestMethodsForType(IType type, ServiceInterface interfaceType, ICompilationUnit cu, NewTypeWizardPage.ImportsManager imports, String lineDelimiter, IProgressMonitor monitor) throws CoreException {
        String typeName = type.getFullyQualifiedName();
        for (ServiceOperation method : interfaceType.getOperations()) {
            if (method.getOutputType() == null || "void".equals(method.getOutputType())) {
                type.createMethod(this.createInOnlyTestMethodContents(method, typeName, cu, imports, lineDelimiter), null, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                continue;
            }
            type.createMethod(this.createInOutTestMethodContents(method, typeName, cu, imports, lineDelimiter), null, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private String getTestMethodName(String name) {
        return "test" + (name == null || name.length() == 0 ? "Process" : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1));
    }

    private StringBuffer getTestMethodPreface(String testMethodName, NewTypeWizardPage.ImportsManager imports, String lineDelimiter) {
        StringBuffer sb = new StringBuffer();
        sb.append("@").append(imports.addImport("org.junit.Test")).append(lineDelimiter);
        sb.append("public void ").append(testMethodName).append("() throws Exception {").append(lineDelimiter);
        return sb;
    }

    private String createInOutTestMethodContents(ServiceOperation method, String typeName, ICompilationUnit cu, NewTypeWizardPage.ImportsManager imports, String lineDelimiter) {
        String contentCastType;
        String resultType;
        String methodName = method.getName();
        String testMethodName = this.getTestMethodName(methodName);
        BindingKey returnTypeBinding = this.getBindingForQName(method.getOutputType());
        StringBuffer body = this.getBodyStart(method, imports, lineDelimiter);
        if (returnTypeBinding.isParameterizedType()) {
            String signature = returnTypeBinding.toSignature();
            resultType = imports.addImport(Signature.toString((String)signature));
            String[] stringArray = returnTypeBinding.getTypeArguments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String parameterType = stringArray[n2];
                imports.addImport(Signature.toString((String)parameterType));
                ++n2;
            }
            contentCastType = imports.addImport(Signature.toString((String)Signature.getTypeErasure((String)signature)));
            body.append("@SuppressWarnings(\"unchecked\")").append(lineDelimiter);
        } else {
            contentCastType = resultType = imports.addImport(Signature.toString((String)returnTypeBinding.toSignature()));
        }
        body.append(resultType).append(" result = service.operation(\"").append(methodName).append("\").sendInOut(message).getContent(").append(contentCastType).append(".class);").append(lineDelimiter).append(lineDelimiter);
        body.append(this.getBodyEnd(imports, lineDelimiter));
        StringBuffer sb = this.getTestMethodPreface(testMethodName, imports, lineDelimiter);
        try {
            sb.append(CodeGeneration.getMethodBodyContent((ICompilationUnit)cu, (String)typeName, (String)testMethodName, (boolean)false, (String)body.toString(), (String)lineDelimiter));
        }
        catch (CoreException coreException) {
            sb.append(body);
        }
        sb.append("}");
        return sb.toString();
    }

    private String createInOnlyTestMethodContents(ServiceOperation method, String typeName, ICompilationUnit cu, NewTypeWizardPage.ImportsManager imports, String lineDelimiter) {
        String methodName = method.getName();
        String testMethodName = this.getTestMethodName(methodName);
        StringBuffer body = this.getBodyStart(method, imports, lineDelimiter);
        body.append("service.operation(\"").append(methodName).append("\").sendInOnly(message);").append(lineDelimiter).append(lineDelimiter);
        body.append(this.getBodyEnd(imports, lineDelimiter));
        StringBuffer sb = this.getTestMethodPreface(testMethodName, imports, lineDelimiter);
        try {
            sb.append(CodeGeneration.getMethodBodyContent((ICompilationUnit)cu, (String)typeName, (String)testMethodName, (boolean)false, (String)body.toString(), (String)lineDelimiter));
        }
        catch (CoreException coreException) {
            sb.append(body);
        }
        sb.append("}");
        return sb.toString();
    }

    private StringBuffer getBodyStart(ServiceOperation method, NewTypeWizardPage.ImportsManager imports, String lineDelimiter) {
        BindingKey parameterType = this.getBindingForQName(method.getInputType());
        StringBuffer sb = new StringBuffer();
        sb.append("// initialize your test message").append(lineDelimiter);
        sb.append(parameterType == null ? "Object" : imports.addImport(Signature.toString((String)parameterType.toSignature()))).append(" message = null;").append(lineDelimiter);
        return sb;
    }

    private StringBuffer getBodyEnd(NewTypeWizardPage.ImportsManager imports, String lineDelimiter) {
        StringBuffer sb = new StringBuffer();
        sb.append("// validate the results").append(lineDelimiter);
        sb.append(imports.addImport("org.junit.Assert")).append(".assertTrue(\"Implement me\", false);").append(lineDelimiter);
        return sb;
    }

    private BindingKey getBindingForQName(QName typeName) {
        if (typeName == null) {
            return null;
        }
        String typeString = Object.class.getCanonicalName();
        if (typeName.getNamespaceURI() == "" && typeName.getLocalPart() != null && typeName.getLocalPart().startsWith("java:")) {
            typeString = typeName.getLocalPart().substring(5);
        }
        return new BindingKey(BindingKey.createTypeBindingKey((String)typeString));
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.checkPackageRoot();
        } else if (fieldName == SERVICE_INTERFACE) {
            this.serviceInterfaceChanged();
        }
        this.doStatusUpdate();
    }

    private void checkPackageRoot() {
        this._rootStatus = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null || this._mavenProjectFacade == null) {
            return;
        }
        if (!Arrays.asList(this._mavenProjectFacade.getTestCompileSourceLocations()).contains(root.getPath())) {
            this._rootStatus.setWarning(Messages.NewServiceTestClassWizardPage_warningMessage_sourceFolderNotConfiguredForTestSource);
        }
    }

    protected IStatus containerChanged() {
        IJavaProject newProject = this.getJavaProject();
        if (this._project == null) {
            if (newProject != null) {
                this._project = newProject.getProject();
                this.updateMavenProjectFacade();
                this.loadConfiguredServices();
                this.updateServicesList();
            }
        } else if (newProject == null) {
            this._project = null;
            this._configuredServices = Collections.emptyMap();
            this.updateMavenProjectFacade();
            this.updateServicesList();
        } else if (!this._project.equals((Object)newProject.getProject())) {
            this._project = newProject.getProject();
            this.updateMavenProjectFacade();
            this.loadConfiguredServices();
            this.updateServicesList();
        }
        return super.containerChanged();
    }

    protected IStatus typeNameChanged() {
        IStatus status = super.typeNameChanged();
        if (status.isOK() && !this.getTypeName().endsWith("Test")) {
            return new StatusInfo(4, Messages.NewServiceTestClassWizardPage_statusMessage_classNameMustEndWithTest);
        }
        return status;
    }

    private void updateMavenProjectFacade() {
        if (this._project == null) {
            this._mavenProjectFacade = null;
            return;
        }
        this._mavenProjectFacade = MavenPlugin.getMavenProjectRegistry().create(this._project, (IProgressMonitor)new NullProgressMonitor());
    }

    private void updateServicesList() {
        Set<String> services = this._configuredServices.keySet();
        String serviceInterfaceName = this.getSimpleServiceInterfaceName();
        this._serviceDialogField.setItems(services.toArray(new String[services.size()]));
        if (serviceInterfaceName != null && serviceInterfaceName.length() > 0) {
            this._serviceDialogField.selectItem(serviceInterfaceName);
        } else if (this._serviceDialogField.getSelectionIndex() < 0 && services.size() > 0) {
            this._serviceDialogField.selectItem(0);
        }
    }

    private void loadConfiguredServices() {
        Composite composite;
        Resource resource;
        File switchYardOutputFile;
        block20: {
            block19: {
                if (!this._serviceDialogField.isEnabled()) {
                    return;
                }
                this._configuredServices = Collections.emptyMap();
                if (this._mavenProjectFacade == null) {
                    return;
                }
                try {
                    switchYardOutputFile = M2EUtils.getSwitchYardOutputFile(this._mavenProjectFacade.getMavenProject((IProgressMonitor)new NullProgressMonitor()));
                }
                catch (CoreException coreException) {
                    switchYardOutputFile = null;
                }
                if (switchYardOutputFile == null) {
                    return;
                }
                if (this._servicesCache.containsKey(switchYardOutputFile)) {
                    this._configuredServices = this._servicesCache.get(switchYardOutputFile);
                    return;
                }
                resource = null;
                ResourceSetImpl rs = new ResourceSetImpl();
                rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new SwitchyardResourceFactoryImpl());
                try {
                    resource = rs.getResource(URI.createPlatformResourceURI((String)MavenProjectUtils.getFullPath((IProject)this._mavenProjectFacade.getProject(), (File)switchYardOutputFile).toString(), (boolean)true), true);
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
                if (resource != null && resource.getContents().size() != 0 && resource.getContents().get(0) instanceof DocumentRoot) break block19;
                this._servicesCache.put(switchYardOutputFile, this._configuredServices);
                if (resource != null) {
                    this._loadedResources.add(resource);
                }
                return;
            }
            DocumentRoot document = (DocumentRoot)resource.getContents().get(0);
            SwitchYardType switchYard = document.getSwitchyard();
            composite = switchYard.getComposite();
            if (composite != null) break block20;
            this._servicesCache.put(switchYardOutputFile, this._configuredServices);
            if (resource != null) {
                this._loadedResources.add(resource);
            }
            return;
        }
        try {
            this._configuredServices = new TreeMap<String, Contract>();
            for (Contract contract : composite.getService()) {
                if (contract.getName() == null) continue;
                this._configuredServices.put(contract.getName(), contract);
            }
            for (Component component : composite.getComponent()) {
                for (Contract contract : component.getService()) {
                    if (contract.getName() == null) continue;
                    this._configuredServices.put(contract.getName(), contract);
                }
            }
            this._configuredServices.put("", null);
        }
        catch (Throwable throwable) {
            this._servicesCache.put(switchYardOutputFile, this._configuredServices);
            if (resource != null) {
                this._loadedResources.add(resource);
            }
            throw throwable;
        }
        this._servicesCache.put(switchYardOutputFile, this._configuredServices);
        if (resource != null) {
            this._loadedResources.add(resource);
        }
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus, this._serviceInterfaceStatus};
        this.updateStatus(status);
    }

    private Contract getServiceContract() {
        String serviceName = this.getSimpleServiceInterfaceName();
        if (serviceName == null || serviceName.length() == 0 || !this._configuredServices.containsKey(serviceName)) {
            return null;
        }
        return this._configuredServices.get(serviceName);
    }

    private String getSimpleServiceInterfaceName() {
        int selection = this._serviceDialogField.getSelectionIndex();
        String[] items = this._serviceDialogField.getItems();
        if (selection < 0 || selection > items.length) {
            return "";
        }
        return items[selection];
    }

    private void createServiceInterfaceControls(org.eclipse.swt.widgets.Composite composite, int nColumns) {
        this._serviceDialogField.doFillIntoGrid(composite, nColumns);
        this._interfaceControl.createControl(composite, nColumns);
        this._interfaceControl.setEnabled(false);
        this.serviceInterfaceChanged();
    }

    private void serviceInterfaceChanged() {
        this._serviceInterfaceStatus = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this._serviceDialogField.setEnabled(root != null);
        Contract contract = this.getServiceContract();
        Interface intf = this.getContractInterface(contract);
        if (contract == null) {
            this._serviceInterfaceStatus.setWarning(Messages.NewServiceTestClassWizardPage_warningStatus_noServiceSpecifiedStubWillBeCreated);
        } else if (intf == null) {
            this._serviceInterfaceStatus.setWarning(Messages.NewServiceTestClassWizardPage_warningStatus_selectedServiceDoesNotDefineInterface);
        }
        this._interfaceControl.init(contract == null ? null : intf, null);
        String newName = this.createDefaultClassName();
        if (this.updateDefault(this._oldTypeName, newName, this.getTypeName())) {
            this.setTypeName(newName, true);
        }
        this._oldTypeName = newName;
    }

    private Interface getContractInterface(Contract contract) {
        return contract == null ? null : (Interface)new ScaSwitch<Interface>(){

            public Interface caseReference(Reference object) {
                Interface intf = object.getInterface();
                if (intf == null && object.getPromote() != null) {
                    for (ComponentReference promoted : object.getPromote()) {
                        if (promoted.getInterface() == null) continue;
                        intf = promoted.getInterface();
                        break;
                    }
                }
                return intf;
            }

            public Interface caseService(Service object) {
                Interface intf = object.getInterface();
                if (intf == null && object.getPromote() != null) {
                    intf = object.getPromote().getInterface();
                }
                return intf;
            }

            public Interface caseContract(Contract object) {
                return object.getInterface();
            }
        }.doSwitch((EObject)contract);
    }

    private String createDefaultClassName() {
        String serviceName = this.getSimpleServiceInterfaceName();
        if (serviceName == null) {
            return "";
        }
        return String.valueOf(serviceName) + "Test";
    }

    private ServiceInterface resolveServiceType() throws CoreException {
        Contract contract = this.getServiceContract();
        if (contract == null || contract.getInterface() == null) {
            return null;
        }
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = JavaUtil.getProjectClassLoader(this.getJavaProject(), null);
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            ServiceInterface serviceInterface = SwitchYardModelUtils.getServiceInterface(contract.getInterface());
            Thread.currentThread().setContextClassLoader(oldTCCL);
            return serviceInterface;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(oldTCCL);
                throw throwable;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.NewServiceTestClassWizardPage_exceptionMessage_errorResolvingServiceInterface, (Throwable)e));
            }
        }
    }

    private boolean updateDefault(String oldValue, String newValue, String currentValue) {
        return currentValue == null || currentValue.length() == 0 || !currentValue.equals(newValue) && (oldValue == null || oldValue.length() == 0 || oldValue.equals(currentValue));
    }

    private void createMixInsTable(org.eclipse.swt.widgets.Composite parent, int nColumns) {
        Label label = new Label(parent, 0);
        label.setText(Messages.NewServiceTestClassWizardPage_labelTestMixIns);
        label.setLayoutData((Object)new GridData(4, 1, false, false));
        this._componentsTable = CheckboxTableViewer.newCheckList((org.eclipse.swt.widgets.Composite)parent, (int)2564);
        this._componentsTable.setLabelProvider((IBaseLabelProvider)new MixInsLabelProvider());
        this._componentsTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._componentsTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true, nColumns - 2, 1));
        this._componentsTable.setComparator((ViewerComparator)new ViewerSorter());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this._componentsTable, (int)2);
        TableLayout layout = new TableLayout();
        this._componentsTable.getTable().setLayout((Layout)layout);
        TableViewerColumn column = new TableViewerColumn((TableViewer)this._componentsTable, 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ISwitchYardTestMixInExtension) {
                    return ((ISwitchYardTestMixInExtension)element).getName();
                }
                return super.getText(element);
            }

            public String getToolTipText(Object element) {
                if (element instanceof ISwitchYardTestMixInExtension) {
                    ISwitchYardTestMixInExtension extension = (ISwitchYardTestMixInExtension)element;
                    if (extension.getDescription() == null) {
                        if (extension.getMixInClass() == null) {
                            return extension.getName();
                        }
                        return extension.getMixInClass();
                    }
                    return extension.getDescription();
                }
                return super.getToolTipText(element);
            }
        });
        this._componentsTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                NewServiceTestClassWizardPage.this._checkedMixins = NewServiceTestClassWizardPage.this._componentsTable.getCheckedElements();
            }
        });
        this._componentsTable.setInput(SwitchYardTestMixInExtensionManager.instance().getExtensions());
        new Label(parent, 0);
    }

    private Collection<String> getSelectedMixinClasses() {
        LinkedHashSet<String> mixins = new LinkedHashSet<String>();
        mixins.add("org.switchyard.component.test.mixins.cdi.CDIMixIn");
        Object[] objectArray = this._checkedMixins;
        int n = this._checkedMixins.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            String mixin = ((ISwitchYardTestMixInExtension)o).getMixInClass();
            if (mixin != null) {
                mixins.add(mixin);
            }
            ++n2;
        }
        return mixins;
    }

    public Collection<ISwitchYardComponentExtension> getSelectedMixInComponents() {
        LinkedHashSet<ISwitchYardComponentExtension> retValue = new LinkedHashSet<ISwitchYardComponentExtension>();
        retValue.add(SwitchYardComponentExtensionManager.instance().getRuntimeComponentExtension());
        Object[] objectArray = this._checkedMixins;
        int n = this._checkedMixins.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ISwitchYardComponentExtension component = ((ISwitchYardTestMixInExtension)o).getRequiredComponent();
            if (component != null) {
                retValue.add(component);
            }
            ++n2;
        }
        return retValue;
    }

    private static final class CreateRunWithAnnotationOperation
    extends CreateElementInCUOperation {
        private final NewTypeWizardPage.ImportsManager _imports;

        private CreateRunWithAnnotationOperation(IType type, NewTypeWizardPage.ImportsManager imports) {
            super((IJavaElement)type);
            this._imports = imports;
        }

        protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode parent) {
            return TypeDeclaration.MODIFIERS2_PROPERTY;
        }

        protected ASTNode generateElementAST(ASTRewrite rewriter, ICompilationUnit cu) throws JavaModelException {
            AST ast = this.cuAST.getAST();
            SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
            TypeLiteral value = ast.newTypeLiteral();
            value.setType((Type)ast.newSimpleType(this.createTypeName(ast, "org.switchyard.test.SwitchYardRunner")));
            annotation.setTypeName(this.createTypeName(ast, "org.junit.runner.RunWith"));
            annotation.setValue((Expression)value);
            return annotation;
        }

        protected IJavaElement generateResultHandle() {
            return this.getType().getAnnotation(this._imports.addImport("org.junit.runner.RunWith"));
        }

        public String getMainTaskName() {
            return Messages.NewServiceTestClassWizardPage_taskName_creatingAnnotation;
        }

        protected void insertASTNode(ASTRewrite rewriter, ASTNode parent, ASTNode child) throws JavaModelException {
            ChildListPropertyDescriptor childListPropertyDescriptor = (ChildListPropertyDescriptor)this.getChildPropertyDescriptor(parent);
            rewriter.getListRewrite(parent, childListPropertyDescriptor).insertFirst(child, null);
        }

        private IType getType() {
            return (IType)this.getParentElement();
        }

        private Name createTypeName(AST ast, String qualifiedName) {
            String simpleName = this._imports.addImport(qualifiedName);
            if (simpleName.equals(qualifiedName)) {
                return ast.newName(qualifiedName);
            }
            return ast.newSimpleName(simpleName);
        }
    }

    private final class CreateSwitchYardTestAnnotationOperation
    extends CreateElementInCUOperation {
        private final NewTypeWizardPage.ImportsManager _imports;

        private CreateSwitchYardTestAnnotationOperation(IType type, NewTypeWizardPage.ImportsManager imports) {
            super((IJavaElement)type);
            this._imports = imports;
        }

        protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode parent) {
            return TypeDeclaration.MODIFIERS2_PROPERTY;
        }

        protected ASTNode generateElementAST(ASTRewrite rewriter, ICompilationUnit cu) throws JavaModelException {
            AST ast = this.cuAST.getAST();
            NormalAnnotation annotation = ast.newNormalAnnotation();
            annotation.setTypeName(this.createTypeName(ast, "org.switchyard.test.SwitchYardTestCaseConfig"));
            annotation.values().add(this.createConfigValue(ast));
            annotation.values().add(this.createMixInsValue(ast));
            return annotation;
        }

        private Object createConfigValue(AST ast) {
            MemberValuePair pair = ast.newMemberValuePair();
            QualifiedName value = ast.newQualifiedName(this.createTypeName(ast, "org.switchyard.test.SwitchYardTestCaseConfig"), ast.newSimpleName("SWITCHYARD_XML"));
            pair.setName(ast.newSimpleName("config"));
            pair.setValue((Expression)value);
            return pair;
        }

        private Object createMixInsValue(AST ast) {
            MemberValuePair pair = ast.newMemberValuePair();
            ArrayInitializer value = ast.newArrayInitializer();
            pair.setName(ast.newSimpleName("mixins"));
            for (String mixin : NewServiceTestClassWizardPage.this.getSelectedMixinClasses()) {
                TypeLiteral mixinType = ast.newTypeLiteral();
                mixinType.setType((Type)ast.newSimpleType(this.createTypeName(ast, mixin)));
                value.expressions().add(mixinType);
            }
            pair.setValue((Expression)value);
            return pair;
        }

        protected IJavaElement generateResultHandle() {
            return this.getType().getAnnotation(this._imports.addImport("org.switchyard.test.SwitchYardTestCaseConfig"));
        }

        public String getMainTaskName() {
            return Messages.NewServiceTestClassWizardPage_taskName_creatingAnnotation;
        }

        protected void insertASTNode(ASTRewrite rewriter, ASTNode parent, ASTNode child) throws JavaModelException {
            ChildListPropertyDescriptor childListPropertyDescriptor = (ChildListPropertyDescriptor)this.getChildPropertyDescriptor(parent);
            rewriter.getListRewrite(parent, childListPropertyDescriptor).insertFirst(child, null);
        }

        private IType getType() {
            return (IType)this.getParentElement();
        }

        private Name createTypeName(AST ast, String qualifiedName) {
            String simpleName = this._imports.addImport(qualifiedName);
            if (simpleName.equals(qualifiedName)) {
                return ast.newName(qualifiedName);
            }
            return ast.newSimpleName(simpleName);
        }
    }

    private static final class MixInsLabelProvider
    extends LabelProvider {
        private MixInsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ISwitchYardTestMixInExtension) {
                return ((ISwitchYardTestMixInExtension)element).getName();
            }
            return super.getText(element);
        }
    }
}

