/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.commons.views.messages;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.ide.foundation.core.functions.Function1;
import org.fusesource.ide.foundation.core.functions.FunctionLong;
import org.fusesource.ide.foundation.ui.config.TableConfiguration;
import org.fusesource.ide.foundation.ui.util.Viewers;
import org.fusesource.ide.foundation.ui.views.TableViewSupport;
import org.fusesource.ide.jmx.commons.messages.Exchange;
import org.fusesource.ide.jmx.commons.messages.Exchanges;
import org.fusesource.ide.jmx.commons.messages.IExchange;
import org.fusesource.ide.jmx.commons.messages.IExchangeBrowser;
import org.fusesource.ide.jmx.commons.messages.IMessage;
import org.fusesource.ide.jmx.commons.messages.ITraceExchangeBrowser;
import org.fusesource.ide.jmx.commons.views.messages.MessageDetailView;
import org.fusesource.ide.jmx.commons.views.messages.MessageDragListener;
import org.fusesource.ide.jmx.commons.views.messages.MessageUIHelper;
import org.fusesource.ide.jmx.commons.views.messages.SelectionListenerForMessageView;

public class MessagesView
extends TableViewSupport {
    public static final String ID = "org.fusesource.ide.fabric.views.MessagesView";
    IExchangeBrowser browser;
    List<IExchange> exchanges = new ArrayList<IExchange>();
    private boolean showBody = true;
    private boolean showTimestamp = true;
    private boolean showRelativeTime = true;
    private boolean showToNode = true;
    private boolean showTraceExchangeId = true;
    private boolean showElapsedTime = true;
    private ISelectionListener selectionListener = new SelectionListenerForMessageView(this);

    protected String getHelpID() {
        return ID;
    }

    public String getColumnConfigurationId() {
        String key = ID;
        if (this.browser instanceof ITraceExchangeBrowser) {
            key = String.valueOf(key) + "_tracing";
        }
        return key;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            Object o;
            ISelection selection = this.viewer.getSelection();
            MessageDetailView view = new MessageDetailView();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof Exchange) {
                view.setSelectedExchange((Exchange)o);
            }
            return view;
        }
        return super.getAdapter(adapter);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        if (site != null) {
            site.getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
        }
    }

    public List<String> getColumns() {
        TableConfiguration tc = this.getConfiguration();
        if (tc == null || !tc.hasColumns()) {
            return super.getColumns();
        }
        tc.reload();
        ArrayList<String> cols = new ArrayList<String>(tc.getColumnMap().keySet());
        tc.sortDefaultColumnNames(cols);
        return cols;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.aboutToBeShown();
    }

    public void dispose() {
        IViewSite site = this.getViewSite();
        if (site != null) {
            site.getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
        }
        super.dispose();
    }

    protected void createViewer() {
        super.createViewer();
        this.getComparator().setDescending(false);
    }

    public void refresh() {
        if (this.browser != null) {
            List<IExchange> list = this.browser.browseExchanges();
            if (list != null) {
                this.exchanges = list;
                this.viewer.setInput(this.exchanges);
            }
        } else {
            this.exchanges.clear();
            this.viewer.refresh();
        }
        this.setConfiguration(null);
        this.updateColumnConfiguration(this.getConfiguration());
        Viewers.refresh((Viewer)this.getViewer());
    }

    protected void createColumns() {
        Object function;
        int bounds = 100;
        int column = 0;
        this.clearColumns();
        if (this.browser instanceof ITraceExchangeBrowser) {
            function = new Function1<Object, Object>(){

                public Object apply(Object element) {
                    Exchange exchange = Exchanges.asExchange(element);
                    if (exchange != null) {
                        return exchange.getExchangeIndex();
                    }
                    return null;
                }
            };
            column = this.addColumnFunction(bounds, column, (Function1)function, "Trace ID");
        }
        if (this.showTraceExchangeId && this.browser instanceof ITraceExchangeBrowser) {
            function = new Function1<Object, Object>(){

                public Object apply(Object element) {
                    Exchange exchange = Exchanges.asExchange(element);
                    if (exchange != null) {
                        return exchange.getId();
                    }
                    return null;
                }
            };
            column = this.addColumnFunction(bounds, column, (Function1)function, "Exchange ID");
        }
        if (this.showBody) {
            function = new Function1<Object, Object>(){

                public Object apply(Object element) {
                    IExchange exchange;
                    String answer;
                    if (element instanceof IExchange && (answer = MessageUIHelper.getBody(exchange = (IExchange)element)) != null) {
                        return answer.replace('\n', ' ');
                    }
                    return null;
                }
            };
            column = this.addColumnFunction(bounds, column, (Function1)function, "Message Body");
        }
        TreeSet<String> headers = new TreeSet<String>();
        for (IExchange exchange : this.exchanges) {
            IMessage in = exchange.getIn();
            if (in == null) continue;
            headers.addAll(in.getHeaders().keySet());
        }
        for (final String header : headers) {
            Function1<Object, Object> function2 = new Function1<Object, Object>(){

                public Object apply(Object element) {
                    IExchange exchange;
                    IMessage in;
                    if (element instanceof IExchange && (in = (exchange = (IExchange)element).getIn()) != null) {
                        return in.getHeaders().get(header);
                    }
                    return null;
                }
            };
            column = this.addColumnFunction(bounds, column, (Function1)function2, header);
        }
        if (this.browser instanceof ITraceExchangeBrowser) {
            Object function3;
            if (this.showToNode) {
                function3 = new Function1<Object, Object>(){

                    public Object apply(Object element) {
                        IMessage message = Exchanges.asMessage(element);
                        if (message != null) {
                            return message.getToNode();
                        }
                        return null;
                    }
                };
                column = this.addColumnFunction(bounds, column, (Function1)function3, "Trace Node Id");
            }
            if (this.showTimestamp) {
                function3 = new Function1<Object, Object>(){

                    public Object apply(Object element) {
                        IMessage message = Exchanges.asMessage(element);
                        if (message != null) {
                            return message.getTimestamp();
                        }
                        return null;
                    }
                };
                column = this.addColumnFunction(bounds, column, (Function1)function3, "Trace Timestamp");
            }
            if (this.showRelativeTime) {
                function3 = new FunctionLong<Object>(){

                    public Long apply(Object element) {
                        IMessage message = Exchanges.asMessage(element);
                        if (message != null) {
                            return message.getRelativeTime();
                        }
                        return null;
                    }
                };
                column = this.addColumnFunction(bounds, column, (Function1)function3, "Relative Time (ms)");
            }
            if (this.showElapsedTime) {
                function3 = new FunctionLong<Object>(){

                    public Long apply(Object element) {
                        IMessage message = Exchanges.asMessage(element);
                        if (message != null) {
                            return message.getElapsedTime();
                        }
                        return null;
                    }
                };
                column = this.addColumnFunction(bounds, column, (Function1)function3, "Elapsed Time (ms)");
            }
        }
    }

    protected void configureViewer() {
        this.viewer.setInput(this.exchanges);
        new MessageDragListener(this.viewer).register();
    }

    protected IStructuredContentProvider createContentProvider() {
        return ArrayContentProvider.getInstance();
    }

    public void setExchangeBrowser(IExchangeBrowser browser) {
        this.browser = browser;
        this.refresh();
    }
}

