/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.builder.execution;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.metamodels.builder.ModelBuilder;
import org.teiid.designer.metamodels.builder.ModelRecord;
import org.teiid.designer.metamodels.builder.execution.MetamodelBuilderConstants;
import org.teiid.designer.metamodels.builder.execution.MetamodelBuilderExecutionPlugin;
import org.teiid.designer.metamodels.builder.execution.util.MetamodelBuilderUtil;
import org.teiid.designer.metamodels.core.CorePackage;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.core.extension.XPackage;

public class ModelBuilderImpl
implements ModelBuilder,
MetamodelBuilderConstants {
    private final ResourceSet eResourceSet;
    private final MultiStatus status;
    private boolean builderDebugEnabled = false;
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ModelBuilderImpl.class);

    private static String getString(String id, Object param1, Object param2) {
        return UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[]{param1, param2});
    }

    public ModelBuilderImpl(MultiStatus status, ResourceSet resourceSet) {
        CoreArgCheck.isNotNull((Object)resourceSet);
        CoreArgCheck.isNotNull((Object)status);
        this.eResourceSet = resourceSet;
        this.status = status;
    }

    public Resource create(ModelRecord record) {
        CoreArgCheck.isNotNull((Object)record);
        String absoluteModelPath = this.getModelAbsolutePath(record);
        URI uri = URI.createFileURI((String)absoluteModelPath);
        if (this.eResourceSet.getResource(uri, false) != null) {
            return this.eResourceSet.getResource(uri, false);
        }
        Resource eResource = this.eResourceSet.createResource(uri);
        this.initModelResource(eResource, record);
        this.eResourceSet.getResources().add((Object)eResource);
        return eResource;
    }

    public List create(List records) {
        CoreArgCheck.isNotNull((Object)records);
        ArrayList<Resource> resources = new ArrayList<Resource>(records.size());
        Iterator iter = records.iterator();
        while (iter.hasNext()) {
            Resource resource = this.create((ModelRecord)iter.next());
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources;
    }

    private String getModelAbsolutePath(ModelRecord record) {
        String locationPath = record.getLocationPath();
        String modelName = record.getModelName();
        String absolutePath = String.valueOf(locationPath) + "\\" + modelName + ".xmi";
        return absolutePath;
    }

    private void initModelResource(Resource modelResource, ModelRecord record) {
        String modelType = record.getModelType();
        String modelSubType = record.getModelSubType();
        String modelNameInSource = record.getModelNameInSource();
        String modelDescription = record.getModelDescription();
        String extensionPackage = record.getExtensionPackage();
        EFactory factory = CorePackage.eINSTANCE.getEFactoryInstance();
        ModelAnnotation annot = (ModelAnnotation)factory.create(CorePackage.eINSTANCE.getModelAnnotation());
        if ("Relational".equalsIgnoreCase(modelType)) {
            annot.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            if ("Physical".equalsIgnoreCase(modelSubType)) {
                annot.setModelType(ModelType.PHYSICAL_LITERAL);
            } else if ("Virtual".equalsIgnoreCase(modelSubType)) {
                annot.setModelType(ModelType.VIRTUAL_LITERAL);
            }
        } else if ("Extension".equalsIgnoreCase(modelType)) {
            annot.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Extension");
            annot.setModelType(ModelType.EXTENSION_LITERAL);
        }
        annot.setNameInSource(modelNameInSource);
        annot.setDescription(modelDescription);
        if (extensionPackage != null) {
            Object xPkg = MetamodelBuilderUtil.findEObjectByPath(this.eResourceSet, extensionPackage, null, this.status);
            if (xPkg != null && xPkg instanceof XPackage) {
                annot.setExtensionPackage((XPackage)xPkg);
            } else {
                String msg = ModelBuilderImpl.getString("noXPkg", extensionPackage, modelResource.getURI().lastSegment());
                MetamodelBuilderUtil.addStatus(this.status, 4, msg);
                if (this.builderDebugEnabled) {
                    MetamodelBuilderExecutionPlugin.Util.log(4, msg);
                }
            }
        }
        modelResource.getContents().add((Object)annot);
    }
}

