/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.builder.execution.processor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.metamodels.builder.MetamodelEntityBuilder;
import org.teiid.designer.metamodels.builder.MetamodelEntityRecord;
import org.teiid.designer.metamodels.builder.execution.MetamodelBuilderConstants;
import org.teiid.designer.metamodels.builder.execution.processor.AbstractProcessor;
import org.teiid.designer.metamodels.builder.execution.util.MetamodelBuilderUtil;
import org.teiid.designer.metamodels.builder.translator.RecordGenerator;
import org.teiid.designer.metamodels.builder.translator.ResultSetTranslator;

public class EntityProcessor
extends AbstractProcessor
implements MetamodelBuilderConstants {
    private final MetamodelEntityBuilder entityBuilder;
    private final String[] processingOrder;
    private final MultiStatus status;

    public EntityProcessor(Connection sqlConnection, MetamodelEntityBuilder entityBuilder, int modelType, String modelAndSchemaName, MultiStatus status) {
        super(sqlConnection, modelAndSchemaName);
        CoreArgCheck.isNotNull((Object)status);
        CoreArgCheck.isNotNull((Object)entityBuilder);
        this.status = status;
        this.entityBuilder = entityBuilder;
        this.processingOrder = modelType == 1 ? RELATIONAL_PROCESSING_ORDER : (modelType == 2 ? EXTENSIONS_PROCESSING_ORDER : new String[0]);
    }

    public int getRecordCount() {
        int totalRows = 0;
        List tableNames = null;
        try {
            tableNames = this.getSchemaTables();
        }
        catch (SQLException e) {
            String msg = "Error retrieving the tables for " + this.modelAndSchemaName;
            MetamodelBuilderUtil.addStatus(this.status, 4, msg, e);
            return totalRows;
        }
        if (tableNames != null) {
            int i = 0;
            while (i < this.processingOrder.length) {
                if (tableNames.contains(this.processingOrder[i])) {
                    int tableRows = this.countTableRows(this.processingOrder[i]);
                    if (tableRows > 0) {
                        totalRows += tableRows;
                    }
                    if (this.status.getSeverity() == 4) {
                        return totalRows;
                    }
                }
                ++i;
            }
        }
        return totalRows;
    }

    public IStatus process(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.subTask("Processing Entities for " + this.modelAndSchemaName);
        }
        List tableNames = null;
        try {
            tableNames = this.getSchemaTables();
        }
        catch (SQLException e) {
            String msg = "Error retrieving the tables for " + this.modelAndSchemaName;
            MetamodelBuilderUtil.addStatus(this.status, 4, msg, e);
            return this.status;
        }
        if (tableNames != null) {
            int i = 0;
            while (i < this.processingOrder.length) {
                if (tableNames.contains(this.processingOrder[i])) {
                    this.processTable(this.processingOrder[i], monitor);
                    if (this.status.getSeverity() == 4) {
                        return this.status;
                    }
                }
                ++i;
            }
        }
        if (monitor != null && monitor.isCanceled()) {
            MetamodelBuilderUtil.addStatus(this.status, 8, "Entity Processing Cancelled");
            return this.status;
        }
        return this.status;
    }

    private void processTable(String tableName, IProgressMonitor monitor) {
        if (this.isValidTable(tableName)) {
            ResultSet rs = null;
            try {
                rs = this.executeTableQuery(tableName);
                List entityRecords = RecordGenerator.generateEntityRecords((ResultSet)rs, (MultiStatus)this.status, (IProgressMonitor)monitor);
                Iterator iter = entityRecords.iterator();
                while (iter.hasNext()) {
                    this.entityBuilder.create((MetamodelEntityRecord)iter.next(), monitor);
                }
                rs.close();
            }
            catch (SQLException e) {
                String msg = "Error Processing Table " + this.modelAndSchemaName + "." + tableName;
                MetamodelBuilderUtil.addStatus(this.status, 4, msg, e);
                return;
            }
            return;
        }
        String msg = "Table not found: " + this.modelAndSchemaName + "." + tableName;
        MetamodelBuilderUtil.addStatus(this.status, 2, msg);
    }

    private int countTableRows(String tableName) {
        int tableRows = 0;
        if (this.isValidTable(tableName)) {
            ResultSet rs = null;
            try {
                rs = this.executeTableQuery(tableName);
                int rsRowCount = ResultSetTranslator.getRowCount((ResultSet)rs);
                if (rsRowCount > 0) {
                    tableRows += rsRowCount;
                }
                rs.close();
            }
            catch (SQLException e) {
                String msg = "Error doing rowCount on table " + this.modelAndSchemaName + "." + tableName;
                MetamodelBuilderUtil.addStatus(this.status, 2, msg, e);
                return tableRows;
            }
            return tableRows;
        }
        String msg = "Table not found when counting rows: " + this.modelAndSchemaName + "." + tableName;
        MetamodelBuilderUtil.addStatus(this.status, 2, msg);
        return tableRows;
    }

    private boolean isValidTable(String tableName) {
        boolean isValid = false;
        int i = 0;
        while (i < this.processingOrder.length) {
            if (this.processingOrder[i].equalsIgnoreCase(tableName)) {
                isValid = true;
                break;
            }
            ++i;
        }
        return isValid;
    }
}

