/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ResourceAnnotationHelper;
import org.teiid.designer.datatools.DatatoolsPlugin;
import org.teiid.designer.datatools.connection.ConnectionProfileFactory;
import org.teiid.designer.datatools.connection.DataSourceConnectionConstants;
import org.teiid.designer.datatools.connection.IConnectionInfoHelper;
import org.teiid.designer.datatools.connection.ITranslatorOverridesProvider;
import org.teiid.designer.type.IDataTypeManagerService;

public class ConnectionInfoHelper
implements IConnectionInfoHelper,
ITranslatorOverridesProvider {
    private ResourceAnnotationHelper resourceAnnotationHelper;
    private ConnectionProfileFactory connectionProfileFactory;

    public ConnectionInfoHelper() {
    }

    public ConnectionInfoHelper(ResourceAnnotationHelper resourceAnnotationHelper, ConnectionProfileFactory connectionProfileFactory) {
        CoreArgCheck.isNotNull((Object)resourceAnnotationHelper, (String)"resourceAnnotationHelper");
        CoreArgCheck.isNotNull((Object)connectionProfileFactory, (String)"connectionProfileFactory");
        this.resourceAnnotationHelper = resourceAnnotationHelper;
        this.connectionProfileFactory = connectionProfileFactory;
    }

    protected ResourceAnnotationHelper getHelper() {
        if (this.resourceAnnotationHelper == null) {
            this.resourceAnnotationHelper = new ResourceAnnotationHelper();
        }
        return this.resourceAnnotationHelper;
    }

    @Override
    public IConnectionProfile getConnectionProfile(ModelResource modelResource) {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        Properties connectionProps = null;
        Properties profileProps = null;
        try {
            profileProps = this.getHelper().getProperties(modelResource, "connectionProfile:");
            connectionProps = this.getHelper().getProperties(modelResource, "connection:");
        }
        catch (Exception e) {
            DatatoolsPlugin.Util.log(4, (Throwable)e, DatatoolsPlugin.Util.getString("errorFindingConnectionProfilePropertiesForModelResource", (Object)modelResource.getItemName()));
        }
        if (connectionProps == null || connectionProps.isEmpty() || profileProps == null || profileProps.isEmpty()) {
            return null;
        }
        String name = profileProps.getProperty("connectionProfile:connectionProfileName");
        String desc = profileProps.getProperty("connectionProfile:connectionProfileDescription");
        String id = profileProps.getProperty("connectionProfile:connectionProfileProviderId");
        Properties baseProps = new Properties();
        Set<Object> keys = connectionProps.keySet();
        for (Object nextKey : keys) {
            baseProps.put(this.removeNamespace((String)nextKey), connectionProps.getProperty((String)nextKey));
        }
        return this.createConnectionProfile(name, desc, id, baseProps);
    }

    @Override
    public ConnectionProfile createConnectionProfile(String name, String description, String id, Properties props) {
        if (this.connectionProfileFactory == null) {
            this.connectionProfileFactory = new ConnectionProfileFactory();
        }
        return this.connectionProfileFactory.createConnectionProfile(name, description, id, props);
    }

    protected String removeNamespace(String str) {
        int semiColonIndex = str.indexOf(58) + 1;
        if (semiColonIndex > 0) {
            return str.substring(semiColonIndex, str.length());
        }
        return str;
    }

    protected Properties removeNamespaces(Properties props) {
        Properties result = new Properties();
        Set<Object> keys = props.keySet();
        for (Object nextKey : keys) {
            result.put(this.removeNamespace((String)nextKey), props.getProperty((String)nextKey));
        }
        return result;
    }

    @Override
    public boolean hasConnectionInfo(ModelResource modelResource) {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        Properties props = null;
        try {
            props = this.getHelper().getProperties(modelResource, "connection:");
        }
        catch (Exception e) {
            DatatoolsPlugin.Util.log(4, (Throwable)e, DatatoolsPlugin.Util.getString("errorFindingConnectionProfilePropertiesForModelResource", (Object)modelResource.getItemName()));
        }
        return props != null && !props.isEmpty();
    }

    @Override
    public String getJndiProperty(ModelResource modelResource) {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        Properties props = null;
        try {
            props = this.getHelper().getProperties(modelResource, "connection:");
        }
        catch (Exception e) {
            DatatoolsPlugin.Util.log(4, (Throwable)e, DatatoolsPlugin.Util.getString("errorFindingConnectionProfilePropertiesForModelResource", (Object)modelResource.getItemName()));
        }
        if (props != null && !props.isEmpty()) {
            return props.getProperty("connection:JBossDsJndi");
        }
        return null;
    }

    @Override
    public Properties getProperties(IConnectionProfile connectionProfile) {
        CoreArgCheck.isNotNull((Object)connectionProfile, (String)"connectionProfile");
        if (this.connectionProfileFactory == null) {
            this.connectionProfileFactory = new ConnectionProfileFactory();
        }
        return this.connectionProfileFactory.getNamespacedProperties(connectionProfile);
    }

    @Override
    public Properties getCommonProfileProperties(IConnectionProfile profile) {
        Properties commonProps = new Properties();
        commonProps.put("connectionProfile:connectionProfileName", profile.getName());
        commonProps.put("connectionProfile:connectionProfileDescription", profile.getDescription());
        commonProps.put("connectionProfile:connectionProfileProviderId", profile.getProviderId());
        commonProps.put("connectionProfile:connectionProfileInstanceID", profile.getInstanceID());
        commonProps.put("connectionProfile:connectionProfileCategory", profile.getCategory().getId());
        return commonProps;
    }

    @Override
    public Properties getConnectionProperties(ModelResource modelResource) throws ModelWorkspaceException {
        return this.removeNamespaces(this.getHelper().getProperties(modelResource, "connection:"));
    }

    @Override
    public Properties getProfileProperties(ModelResource modelResource) throws ModelWorkspaceException {
        return this.removeNamespaces(this.getHelper().getProperties(modelResource, "connectionProfile:"));
    }

    @Override
    public Properties getTranslatorProperties(ModelResource modelResource) {
        CoreArgCheck.isNotNull((Object)modelResource);
        Properties props = null;
        try {
            props = this.removeNamespaces(this.getHelper().getProperties(modelResource, "translator:"));
        }
        catch (Exception e) {
            DatatoolsPlugin.Util.log(4, (Throwable)e, DatatoolsPlugin.Util.getString("errorFindingConnectionProfilePropertiesForModelResource", (Object)modelResource.getItemName()));
        }
        return props;
    }

    @Override
    public String getTranslatorName(ModelResource modelResource) {
        if (modelResource == null) {
            return "";
        }
        Properties props = null;
        try {
            props = this.getHelper().getProperties(modelResource, "translator:");
        }
        catch (Exception e) {
            DatatoolsPlugin.Util.log(4, (Throwable)e, DatatoolsPlugin.Util.getString("errorFindingConnectionProfilePropertiesForModelResource", (Object)modelResource.getItemName()));
        }
        return props.getProperty("translator:name", "");
    }

    public void setTranslatorName(ModelResource modelResource, String translatorName) {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        CoreArgCheck.isNotEmpty((String)translatorName, (String)"translatorName");
        try {
            this.getHelper().setProperty(modelResource, "translator:name", (Object)translatorName);
        }
        catch (Exception e) {
            DatatoolsPlugin.Util.log(4, (Throwable)e, DatatoolsPlugin.Util.getString("errorFindingConnectionProfilePropertiesForModelResource", (Object)modelResource.getItemName()));
        }
    }

    public void setJNDIName(ModelResource modelResource, String jndiName) {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        CoreArgCheck.isNotEmpty((String)jndiName, (String)"jndiName");
        try {
            this.getHelper().setProperty(modelResource, "connection:JBossDsJndi", (Object)jndiName);
        }
        catch (Exception e) {
            DatatoolsPlugin.Util.log(4, (Throwable)e, DatatoolsPlugin.Util.getString("errorFindingConnectionProfilePropertiesForModelResource", (Object)modelResource.getItemName()));
        }
    }

    public String generateUniqueConnectionJndiName(IFile model, String uuid) {
        return this.generateUniqueConnectionJndiName(model.getFullPath().removeFileExtension().lastSegment(), model.getFullPath(), ModelerCore.workspaceUuid().toString());
    }

    @Override
    public String generateUniqueConnectionJndiName(ModelResource modelResource, String uuid) {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        CoreArgCheck.isNotEmpty((String)uuid, (String)"uuid");
        return this.generateUniqueConnectionJndiName(modelResource.getItemName(), modelResource.getPath(), ModelerCore.workspaceUuid().toString());
    }

    @Override
    public String generateUniqueConnectionJndiName(String name, IPath path, String uuid) {
        CoreArgCheck.isNotEmpty((String)name, (String)"name");
        CoreArgCheck.isNotNull((Object)path, (String)"path");
        CoreArgCheck.isNotEmpty((String)uuid, (String)"uuid");
        StringBuilder builder = new StringBuilder(String.valueOf(uuid) + '_');
        String[] stringArray = path.removeLastSegments(1).segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            builder.append(segment).append('_');
            ++n2;
        }
        return builder.append(name).toString();
    }

    public String findTranslatorName(ModelResource modelResource) {
        String translator = this.getTranslatorName(modelResource);
        String[] stringArray = DataSourceConnectionConstants.Translators.JDBC_TRANSLATORS;
        int n = DataSourceConnectionConstants.Translators.JDBC_TRANSLATORS.length;
        int n2 = 0;
        while (n2 < n) {
            String translatorName = stringArray[n2];
            if (translator.toUpperCase().contains(translatorName.toUpperCase())) {
                return translatorName;
            }
            ++n2;
        }
        return null;
    }

    public String findTranslatorName(Properties properties) {
        ArrayList<String> matchableStrings = new ArrayList<String>();
        matchableStrings.add(properties.getProperty("name"));
        String[] stringArray = DataSourceConnectionConstants.Translators.ALL_TRANSLATORS;
        int n = DataSourceConnectionConstants.Translators.ALL_TRANSLATORS.length;
        int n2 = 0;
        while (n2 < n) {
            String translatorName = stringArray[n2];
            for (String keyword : matchableStrings) {
                if (!keyword.toUpperCase().contains(translatorName.toUpperCase())) continue;
                return translatorName;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String findMatchingDataSourceTypeName(Collection<String> matchableStrings, Set<String> dataSourceTypeNames) {
        for (String dsTypeName : dataSourceTypeNames) {
            for (String keyword : matchableStrings) {
                if (!keyword.toUpperCase().contains(dsTypeName.toUpperCase())) continue;
                return dsTypeName;
            }
        }
        return "unknown";
    }

    @Override
    public String findMatchingDataSourceTypeName(ModelResource modelResource) throws ModelWorkspaceException {
        ResourceAnnotationHelper helper = new ResourceAnnotationHelper();
        Properties properties = helper.getProperties(modelResource, "translator:");
        return this.findMatchingDataSourceTypeName(properties);
    }

    @Override
    public String findMatchingDataSourceTypeName(Properties properties) {
        String[] stringArray = DataSourceConnectionConstants.Translators.ALL_TRANSLATORS;
        int n = DataSourceConnectionConstants.Translators.ALL_TRANSLATORS.length;
        int n2 = 0;
        while (n2 < n) {
            String translatorName = stringArray[n2];
            String translator = properties.getProperty("name");
            if (translator.toUpperCase().contains(translatorName.toUpperCase())) {
                return translator;
            }
            ++n2;
        }
        return ModelerCore.getTeiidDataTypeManagerService().getDataSourceType(IDataTypeManagerService.DataSourceTypes.UNKNOWN);
    }

    public void clearConnectionInfo(ModelResource modelResource) throws ModelWorkspaceException {
        this.getHelper().removeProperties(modelResource, "connectionProfile:");
        this.getHelper().removeProperties(modelResource, "connection:");
        this.getHelper().removeProperties(modelResource, "translator:");
    }

    public static String readEndPointProperty(Properties properties) {
        String endPointPropId = properties.getProperty("EndPoint");
        if (endPointPropId == null) {
            endPointPropId = properties.getProperty("wsdlURI");
        }
        return endPointPropId;
    }

    @Override
    public Properties getTranslatorOverrideProperties(ModelResource modelResource) {
        Properties props = new Properties();
        try {
            Properties rawProps = this.getHelper().getProperties(modelResource, "translator:");
            for (Object key : rawProps.keySet()) {
                String value = (String)rawProps.get(key);
                int loc = ((String)key).indexOf(58) + 1;
                String propID = ((String)key).substring(loc);
                props.put(propID, value);
            }
        }
        catch (ModelWorkspaceException e) {
            DatatoolsPlugin.Util.log(4, (Throwable)e, DatatoolsPlugin.Util.getString("ConnectionInfoHelper.errorFindingTranslatorOverrideProperties", (Object)modelResource.getItemName()));
        }
        return props;
    }

    @Override
    public void replaceTranlatorOverrideProperties(ModelResource modelResource, Properties properties) {
        if (properties.isEmpty()) {
            return;
        }
        this.clearTranslatorOverrideProperties(modelResource);
        Properties finalProps = new Properties();
        for (Object key : properties.keySet()) {
            String value = (String)properties.get(key);
            finalProps.put("translator:" + key, value);
        }
        try {
            this.getHelper().setProperties(modelResource, finalProps);
        }
        catch (ModelWorkspaceException e) {
            DatatoolsPlugin.Util.log(4, (Throwable)e, DatatoolsPlugin.Util.getString("ConnectionInfoHelper.errorReplacingTranslatorOverrideProperties", (Object)modelResource.getItemName()));
        }
    }

    @Override
    public void clearTranslatorOverrideProperties(ModelResource modelResource) {
        String translatorName = this.getTranslatorName(modelResource);
        try {
            this.getHelper().removeProperties(modelResource, "translator:");
            Properties props = new Properties();
            props.put("translator:name", translatorName);
            this.getHelper().setProperties(modelResource, props);
        }
        catch (ModelWorkspaceException e) {
            DatatoolsPlugin.Util.log(4, (Throwable)e, DatatoolsPlugin.Util.getString("ConnectionInfoHelper.errorClearingTranslatorOverrideProperties", (Object)modelResource.getItemName()));
        }
    }
}

