/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.connection;

import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.datatools.DatatoolsPlugin;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;

public class ConnectionInfoProviderFactory {
    private static final String EXTENSION = "org.teiid.designer.datatools.ConnectionInfoProvider";
    private static final String PROFILE_ATTRIBUTE = "profile";
    private static final String CATEGORY_ATTRIBUTE = "category";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final ConnectionInfoProviderFactory INSTANCE = new ConnectionInfoProviderFactory();
    private IConnectionInfoHelper helper = new ConnectionInfoHelper();

    public static ConnectionInfoProviderFactory getInstance() {
        return INSTANCE;
    }

    public IConnectionInfoProvider getProvider(IConnectionProfile profile) {
        IConnectionProfile parent;
        String instanceID = profile.getProviderId();
        IConnectionInfoProvider result = this.getProviderFromProfileID(instanceID);
        if (result == null && (parent = profile.getParentProfile()) != null) {
            return this.getProvider(parent);
        }
        if (result == null) {
            result = this.getProvider(profile.getCategory());
        }
        return result;
    }

    public IConnectionInfoProvider getProviderFromProfileID(String instanceID) {
        IConnectionInfoProvider helper = null;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor(EXTENSION);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = extensions[i];
            if (instanceID.equals(element.getAttribute(PROFILE_ATTRIBUTE))) {
                try {
                    helper = (IConnectionInfoProvider)element.createExecutableExtension(CLASS_ATTRIBUTE);
                    break;
                }
                catch (Exception e) {
                    DatatoolsPlugin.Util.log(4, e.getMessage());
                }
            }
            ++i;
        }
        return helper;
    }

    private IConnectionInfoProvider getProvider(ICategory category) {
        ICategory parent;
        String instanceID = category.getId();
        IConnectionInfoProvider result = this.getProviderFromCategoryID(instanceID);
        if (result == null && (parent = category.getParent()) != null) {
            return this.getProvider(parent);
        }
        return result;
    }

    private IConnectionInfoProvider getProviderFromCategoryID(String categoryId) {
        IConnectionInfoProvider helper = null;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor(EXTENSION);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = extensions[i];
            if (categoryId.equals(element.getAttribute(CATEGORY_ATTRIBUTE))) {
                try {
                    helper = (IConnectionInfoProvider)element.createExecutableExtension(CLASS_ATTRIBUTE);
                    break;
                }
                catch (Exception e) {
                    DatatoolsPlugin.Util.log(4, e.getMessage());
                }
            }
            ++i;
        }
        return helper;
    }

    public IConnectionInfoProvider getProvider(ModelResource modelResource) throws Exception {
        IConnectionInfoProvider result = null;
        if (!this.helper.hasConnectionInfo(modelResource)) {
            throw new Exception(DatatoolsPlugin.Util.getString("ConnectionInfoProviderFactory.noConnectionInfoInModel", (Object)modelResource.getItemName()));
        }
        IConnectionProfile profile = this.helper.getConnectionProfile(modelResource);
        if (profile == null) {
            throw new Exception(DatatoolsPlugin.Util.getString("ConnectionInfoProviderFactory.noConnectionProfileInModel", (Object)modelResource.getItemName()));
        }
        result = this.getProvider(profile);
        if (result == null) {
            ICategory category = profile.getCategory();
            if (category == null) {
                throw new Exception(DatatoolsPlugin.Util.getString("ConnectionInfoProviderFactory.noCategoryForProfile", (Object)profile.getName()));
            }
            result = this.getProvider(category);
        }
        return result;
    }

    public boolean hasProvider(ModelResource modelResource) throws Exception {
        if (!this.helper.hasConnectionInfo(modelResource)) {
            return false;
        }
        IConnectionProfile profile = this.helper.getConnectionProfile(modelResource);
        if (profile == null) {
            return false;
        }
        IConnectionInfoProvider result = this.getProvider(profile);
        if (result == null) {
            ICategory category = profile.getCategory();
            if (category == null) {
                return false;
            }
            result = this.getProvider(category);
        }
        return result != null;
    }

    public IConnectionInfoProvider getProvider(Properties props) {
        IConnectionInfoProvider result = null;
        String providerID = props.getProperty("connectionProfile:connectionProfileProviderId");
        result = this.getProviderFromProfileID(providerID);
        if (result == null) {
            String categoryID = props.getProperty("connectionProfile:connectionProfileCategory");
            result = this.getProviderFromCategoryID(categoryID);
        }
        return result;
    }
}

