/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.connection;

import java.util.Properties;
import java.util.Set;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.teiid.core.designer.util.CoreArgCheck;

public class ConnectionProfileFactory {
    public ConnectionProfile createConnectionProfile(String name, String description, String id, Properties props) {
        CoreArgCheck.isNotEmpty((String)name, (String)"name");
        CoreArgCheck.isNotEmpty((String)id, (String)"id");
        CoreArgCheck.isNotEmpty((Properties)props, (String)"props");
        ConnectionProfile profile = new ConnectionProfile(name, description, id);
        profile.setProperties(id, props);
        return profile;
    }

    public Properties getNamespacedProperties(IConnectionProfile connectionProfile) {
        CoreArgCheck.isNotNull((Object)connectionProfile, (String)"connectionProfile");
        Properties baseProps = connectionProfile.getBaseProperties();
        Properties connProps = new Properties();
        connProps.put("connectionProfile:connectionProfileName", connectionProfile.getName());
        connProps.put("connectionProfile:connectionProfileDescription", connectionProfile.getDescription());
        connProps.put("connectionProfile:connectionProfileProviderId", connectionProfile.getProviderId());
        Set<Object> keys = baseProps.keySet();
        for (Object nextKey : keys) {
            connProps.put("connectionProfile:" + nextKey, baseProps.get(nextKey));
        }
        return connProps;
    }
}

