/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.connection;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.datatools.connection.ConnectionInfoProviderFactory;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.runtime.spi.ITeiidServer;

public class DataSourceConnectionHelper {
    final ModelResource mr;
    final IConnectionProfile cp;

    public DataSourceConnectionHelper(ModelResource mr, IConnectionProfile connectionProfile) {
        this.mr = mr;
        this.cp = connectionProfile;
    }

    public Properties getModelConnectionProperties() {
        Properties properties;
        IConnectionInfoProvider provider = null;
        try {
            provider = this.getProvider();
        }
        catch (Exception exception) {}
        if (provider != null && (properties = provider.getTeiidRelatedProperties(this.cp)) != null && !properties.isEmpty()) {
            return properties;
        }
        return null;
    }

    public String getDataSourceType() {
        IConnectionInfoProvider provider = null;
        try {
            provider = this.getProvider();
        }
        catch (Exception exception) {}
        if (provider != null) {
            return provider.getDataSourceType();
        }
        return null;
    }

    public String getTranslatorType() {
        IConnectionInfoProvider provider = null;
        try {
            provider = this.getProvider();
        }
        catch (Exception exception) {}
        if (provider != null) {
            return provider.getTranslatorName(this.mr);
        }
        return null;
    }

    private IConnectionInfoProvider getProvider() throws Exception {
        ConnectionInfoProviderFactory providerFactory = new ConnectionInfoProviderFactory();
        return providerFactory.getProvider(this.mr);
    }

    public static boolean isServerDefined() {
        ITeiidServer server = ModelerCore.getTeiidServerManager().getDefaultServer();
        return server != null;
    }

    public static boolean isServerConnected() {
        ITeiidServer server = ModelerCore.getTeiidServerManager().getDefaultServer();
        return server != null && server.isConnected();
    }

    public static ITeiidServer getServer() {
        return ModelerCore.getTeiidServerManager().getDefaultServer();
    }
}

