/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.flatfile;

import java.io.File;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.DatatoolsPlugin;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.type.IDataTypeManagerService;

public class FlatFileConnectionInfoProvider
extends ConnectionInfoHelper
implements IConnectionInfoProvider {
    public static final String FILE_CLASSNAME = "class-name";
    public static final String FILE_CONNECTION_FACTORY = "org.teiid.resource.adapter.file.FileManagedConnectionFactory";

    @Override
    public String getDataSourcePasswordPropertyKey() {
        return null;
    }

    @Override
    public String getDataSourceType() {
        return ModelerCore.getTeiidDataTypeManagerService().getDataSourceType(IDataTypeManagerService.DataSourceTypes.FILE);
    }

    @Override
    public String getPasswordPropertyKey() {
        return "bogus_xxxx";
    }

    @Override
    public Properties getTeiidRelatedProperties(IConnectionProfile connectionProfile) {
        String uri;
        String parentPath;
        Properties connectionProps = new Properties();
        Properties baseProps = connectionProfile.getBaseProperties();
        if (baseProps.getProperty("FlatFileHomeUrl") != null) {
            connectionProps.put("ParentDirectory", baseProps.get("FlatFileHomeUrl"));
        } else if (baseProps.getProperty("HOME") != null) {
            connectionProps.put("ParentDirectory", baseProps.get("HOME"));
        } else if (baseProps.getProperty("URI") != null && (parentPath = this.getFileParentDir(uri = baseProps.getProperty("URI"))) != null) {
            connectionProps.put("ParentDirectory", parentPath);
        }
        connectionProps.setProperty(FILE_CLASSNAME, FILE_CONNECTION_FACTORY);
        return connectionProps;
    }

    @Override
    public void setConnectionInfo(ModelResource modelResource, IConnectionProfile connectionProfile) throws ModelWorkspaceException {
        Properties connectionProps = this.getCommonProfileProperties(connectionProfile);
        Properties props = connectionProfile.getBaseProperties();
        String result = props.getProperty("HOME");
        if (result != null) {
            connectionProps.setProperty("connection:FlatFileHomeUrl", result);
        } else {
            String parentPath;
            result = props.getProperty("URI");
            if (result != null && (parentPath = this.getFileParentDir(result)) != null) {
                connectionProps.setProperty("connection:FlatFileHomeUrl", parentPath);
            }
        }
        result = props.getProperty("DELIMTYPE");
        if (result != null) {
            connectionProps.setProperty("connection:FlatFileDelimeter", result);
        }
        if ((result = props.getProperty("CHARSET")) != null) {
            connectionProps.setProperty("connection:FlatFileCharSet", result);
        }
        if ((result = props.getProperty("INCLCOLUMNNAME")) != null) {
            connectionProps.setProperty("connection:FlatFileFirstLineColumnName", result);
        }
        if ((result = props.getProperty("INCLTYPELINE")) != null) {
            connectionProps.setProperty("connection:FlatFileSecondLineDataType", result);
        }
        this.getHelper().removeProperties(modelResource, "connectionProfile:");
        this.getHelper().removeProperties(modelResource, "translator:");
        this.getHelper().removeProperties(modelResource, "connection:");
        connectionProps.put("translator:name", "file");
        this.getHelper().setProperties(modelResource, connectionProps);
    }

    private String getFileParentDir(String filePath) {
        File dirFile;
        File aFile;
        String dirPath = null;
        if (filePath != null && (aFile = new File(filePath)).exists() && aFile.isFile() && (dirFile = aFile.getParentFile()) != null && dirFile.exists() && dirFile.isDirectory()) {
            dirPath = dirFile.getAbsolutePath();
        }
        return dirPath;
    }

    @Override
    public Properties getCommonProfileProperties(IConnectionProfile profile) {
        return super.getCommonProfileProperties(profile);
    }

    @Override
    public IConnectionProfile getConnectionProfile(ModelResource modelResource) {
        IConnectionProfile profile = super.getConnectionProfile(modelResource);
        Properties baseProps = profile.getBaseProperties();
        Properties flatFileProps = new Properties();
        try {
            flatFileProps = this.getConnectionProperties(modelResource);
        }
        catch (ModelWorkspaceException e) {
            DatatoolsPlugin.Util.log((Throwable)e);
        }
        String result = flatFileProps.getProperty("FlatFileHomeUrl");
        if (result != null) {
            baseProps.put("HOME", result);
        }
        if ((result = flatFileProps.getProperty("FlatFileCharSet")) != null) {
            baseProps.put("CHARSET", result);
        }
        if ((result = flatFileProps.getProperty("FlatFileDelimeter")) != null) {
            baseProps.put("DELIMTYPE", result);
        }
        if ((result = flatFileProps.getProperty("FlatFileFirstLineColumnName")) != null) {
            baseProps.put("INCLCOLUMNNAME", result);
        }
        if ((result = flatFileProps.getProperty("FlatFileSecondLineDataType")) != null) {
            baseProps.put("INCLTYPELINE", result);
        }
        return profile;
    }

    @Override
    public Properties getConnectionProperties(ModelResource modelResource) throws ModelWorkspaceException {
        Properties modelProps = super.getConnectionProperties(modelResource);
        Properties connProps = new Properties();
        String home = modelProps.getProperty("FlatFileHomeUrl");
        if (home != null) {
            connProps.put("ParentDirectory", home);
        }
        return connProps;
    }

    @Override
    public String getTranslatorName(ModelResource modelResource) {
        return "file";
    }

    @Override
    public boolean requiresPassword(IConnectionProfile connectionProfile) {
        return false;
    }
}

