/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.flatfile;

import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.type.IDataTypeManagerService;

public class FlatFileUrlConnectionInfoProvider
extends ConnectionInfoHelper
implements IConnectionInfoProvider {
    public static final String WS_CLASSNAME = "class-name";
    public static final String WS_CONNECTION_FACTORY = "org.teiid.resource.adapter.ws.WSManagedConnectionFactory";

    @Override
    public String getDataSourcePasswordPropertyKey() {
        return null;
    }

    @Override
    public String getDataSourceType() {
        return ModelerCore.getTeiidDataTypeManagerService().getDataSourceType(IDataTypeManagerService.DataSourceTypes.WS);
    }

    @Override
    public String getPasswordPropertyKey() {
        return "bogus_xxxx";
    }

    @Override
    public Properties getTeiidRelatedProperties(IConnectionProfile connectionProfile) {
        Properties connectionProps = new Properties();
        Properties props = connectionProfile.getBaseProperties();
        String fileUrl = props.getProperty("URL");
        if (fileUrl != null) {
            Path fullPath = new Path(fileUrl);
            String fileURL = fullPath.toString();
            connectionProps.setProperty("EndPoint", fileURL);
        }
        connectionProps.setProperty(WS_CLASSNAME, WS_CONNECTION_FACTORY);
        return connectionProps;
    }

    @Override
    public void setConnectionInfo(ModelResource modelResource, IConnectionProfile connectionProfile) throws ModelWorkspaceException {
        Properties connectionProps = this.getCommonProfileProperties(connectionProfile);
        Properties props = connectionProfile.getBaseProperties();
        String result = props.getProperty("URL");
        if (result != null) {
            connectionProps.setProperty("connection:URL", result);
        }
        this.getHelper().removeProperties(modelResource, "connectionProfile:");
        this.getHelper().removeProperties(modelResource, "translator:");
        this.getHelper().removeProperties(modelResource, "connection:");
        connectionProps.put("translator:name", "ws");
        this.getHelper().setProperties(modelResource, connectionProps);
    }

    @Override
    public Properties getCommonProfileProperties(IConnectionProfile profile) {
        return super.getCommonProfileProperties(profile);
    }

    @Override
    public String getTranslatorName(ModelResource modelResource) {
        return "ws";
    }

    @Override
    public boolean requiresPassword(IConnectionProfile connectionProfile) {
        return false;
    }
}

