/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ldap;

import java.util.Properties;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionFactory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.datatools.profiles.ldap.ILdapProfileConstants;
import org.teiid.designer.datatools.profiles.ldap.JndiLdapConnection;
import org.teiid.designer.datatools.profiles.ldap.LDAPUrl;

public class LDAPConnectionFactory
implements IConnectionFactory,
ILdapProfileConstants,
StringConstants {
    public IConnection createConnection(IConnectionProfile profile) {
        JndiLdapConnection connection = new JndiLdapConnection(profile, this.getClass());
        connection.open();
        return connection;
    }

    public IConnection createConnection(IConnectionProfile profile, String uid, String pwd) {
        return this.createConnection(profile);
    }

    public Connection convert(IConnectionProfile profile) {
        ConnectionParameter parameter = new ConnectionParameter();
        parameter.setExtendedBoolProperty("ldapbrowser.fetchBaseDns", true);
        parameter.setExtendedIntProperty("ldapbrowser.countLimit", 1000);
        parameter.setExtendedIntProperty("ldapbrowser.timeLimit", 0);
        parameter.setExtendedIntProperty("ldapbrowser.referralsHandlingMethod", Connection.ReferralHandlingMethod.FOLLOW_MANUALLY.ordinal());
        parameter.setExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod", Connection.AliasDereferencingMethod.ALWAYS.ordinal());
        Properties properties = profile.getBaseProperties();
        String baseDN = properties.getProperty("baseDN");
        parameter.setExtendedProperty("ldapbrowser.baseDn", baseDN != null ? baseDN : "");
        String scheme = properties.getProperty("LdapScheme");
        String host = properties.getProperty("LdapHost");
        Integer port = null;
        try {
            port = Integer.valueOf(properties.getProperty("LdapPort"));
        }
        catch (NumberFormatException numberFormatException) {}
        if (scheme == null || host == null || port == null) {
            String url = properties.getProperty("LdapUrl");
            try {
                LDAPUrl ldapUrl = new LDAPUrl(url);
                scheme = ldapUrl.getScheme();
                host = ldapUrl.getHost();
                port = ldapUrl.getPort();
            }
            catch (Exception exception) {}
        }
        parameter.setHost(host);
        parameter.setPort(port.intValue());
        if ("ldap://".equals(scheme)) {
            parameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.NONE);
        } else if ("ldap://".equals(scheme)) {
            parameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.LDAPS);
        }
        if ("none".equals(properties.getProperty("LdapAuthenticationMethod"))) {
            parameter.setAuthMethod(ConnectionParameter.AuthenticationMethod.NONE);
        } else if ("simple".equals(properties.getProperty("LdapAuthenticationMethod"))) {
            parameter.setAuthMethod(ConnectionParameter.AuthenticationMethod.SIMPLE);
        }
        parameter.setBindPrincipal(properties.getProperty("LdapAdminUserDN"));
        parameter.setBindPassword(properties.getProperty("LdapAdminUserPassword"));
        parameter.setNetworkProvider(ConnectionParameter.NetworkProvider.JNDI);
        Connection connection = new Connection(parameter);
        return connection;
    }

    public static String getDefaultLdapContextFactory() {
        String defaultLdapContextFactory = "";
        try {
            String sun = "com.sun.jndi.ldap.LdapCtxFactory";
            Class.forName(sun);
            defaultLdapContextFactory = sun;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return defaultLdapContextFactory;
    }
}

