/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ldap;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.type.IDataTypeManagerService;

public class LDAPConnectionInfoProvider
extends ConnectionInfoHelper
implements IConnectionInfoProvider {
    @Override
    public void setConnectionInfo(ModelResource modelResource, IConnectionProfile connectionProfile) throws ModelWorkspaceException {
        String contextFactory;
        String user;
        String authMethod;
        Properties connectionProps = this.getCommonProfileProperties(connectionProfile);
        Properties props = connectionProfile.getBaseProperties();
        String url = props.getProperty("LdapUrl");
        if (url != null) {
            connectionProps.setProperty("connection:LdapUrl", url);
        }
        if ((authMethod = props.getProperty("LdapAuthenticationMethod")) != null) {
            connectionProps.setProperty("connection:LdapAuthenticationMethod", authMethod);
        }
        if ((user = props.getProperty("LdapAdminUserDN")) != null) {
            connectionProps.setProperty("connection:LdapAdminUserDN", user);
        }
        if ((contextFactory = props.getProperty("LdapContextFactory")) != null) {
            connectionProps.setProperty("connection:LdapContextFactory", contextFactory);
        }
        this.getHelper().removeProperties(modelResource, "connectionProfile:");
        this.getHelper().removeProperties(modelResource, "translator:");
        this.getHelper().removeProperties(modelResource, "connection:");
        connectionProps.put("translator:name", "ldap");
        this.getHelper().setProperties(modelResource, connectionProps);
    }

    @Override
    public String getPasswordPropertyKey() {
        return "LdapAdminUserPassword";
    }

    @Override
    public String getDataSourcePasswordPropertyKey() {
        return "LdapAdminUserPassword";
    }

    @Override
    public String getDataSourceType() {
        return ModelerCore.getTeiidDataTypeManagerService().getDataSourceType(IDataTypeManagerService.DataSourceTypes.LDAP);
    }

    @Override
    public Properties getTeiidRelatedProperties(IConnectionProfile connectionProfile) {
        String contextFactory;
        String user;
        String url;
        Properties connectionProps = new Properties();
        Properties props = connectionProfile.getBaseProperties();
        String password = props.getProperty("LdapAdminUserPassword");
        if (password != null) {
            connectionProps.setProperty("LdapAdminUserPassword", password);
        }
        if ((url = props.getProperty("LdapUrl")) != null) {
            connectionProps.setProperty("LdapUrl", url);
        }
        if ((user = props.getProperty("LdapAdminUserDN")) != null) {
            connectionProps.setProperty("LdapAdminUserDN", user);
        }
        if ((contextFactory = props.getProperty("LdapContextFactory")) != null) {
            connectionProps.setProperty("LdapContextFactory", contextFactory);
        }
        connectionProps.setProperty("class-name", "org.teiid.resource.adapter.ldap.LDAPManagedConnectionFactory");
        return connectionProps;
    }

    @Override
    public boolean requiresPassword(IConnectionProfile connectionProfile) {
        Properties props = connectionProfile.getBaseProperties();
        String authMethod = props.getProperty("LdapAuthenticationMethod");
        return "simple".equals(authMethod);
    }
}

