/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ldap;

import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.datatools.profiles.ldap.ILdapProfileConstants;

public class LDAPUrl
implements ILdapProfileConstants,
StringConstants {
    private String url;
    private String scheme;
    private String host;
    private int port;

    public LDAPUrl(String url) throws Exception {
        CoreArgCheck.isNotNull((Object)url);
        this.url = url;
        String portString = null;
        if (url.startsWith("ldaps://")) {
            this.scheme = "ldaps://";
            int lastColon = url.lastIndexOf(":");
            this.host = url.substring("ldaps://".length(), lastColon);
            portString = url.substring(lastColon + 1);
        } else if (url.startsWith("ldap://")) {
            this.scheme = "ldap://";
            int lastColon = url.lastIndexOf(":");
            this.host = url.substring("ldap://".length(), lastColon);
            portString = url.substring(lastColon + 1);
        }
        CoreArgCheck.isNotNull((Object)this.scheme);
        CoreArgCheck.isNotNull((Object)this.host);
        CoreArgCheck.isNotNull(portString);
        this.port = Integer.valueOf(portString);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

