/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.modeshape;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;

public class RestUtils {
    public List<String> getRepositoryList(URL url, String user, String pass) throws Exception {
        BasicAuthenticator basicAuth = new BasicAuthenticator(user, pass);
        Authenticator.setDefault(basicAuth);
        String jsonResponse = RestUtils.getRepositories(url);
        Authenticator.setDefault(null);
        return RestUtils.parseRepositories(jsonResponse);
    }

    private static String getRepositories(URL url) throws Exception {
        String line;
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("Accept", "application/json");
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer sb = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            sb.append(line);
        }
        rd.close();
        return sb.toString();
    }

    private static List<String> parseRepositories(String jsonResponse) throws Exception {
        JsonFactory jsonFactory;
        JsonParser jp;
        ObjectMapper mapper;
        JsonNode rootNode;
        if (!jsonResponse.isEmpty() && (rootNode = (mapper = new ObjectMapper()).readTree(jp = (jsonFactory = new JsonFactory()).createJsonParser(jsonResponse))) != null && rootNode.size() == 1) {
            JsonNode repositoriesNode = (JsonNode)rootNode.iterator().next();
            ArrayList<String> result = new ArrayList<String>(repositoriesNode.size());
            for (JsonNode repoNode : repositoriesNode) {
                result.add(repoNode.path("name").getTextValue());
            }
            return result;
        }
        return Collections.emptyList();
    }

    private class BasicAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        public BasicAuthenticator(String user, String pass) {
            this.username = user;
            this.password = pass;
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }
}

