/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.mongodb;

import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.DatatoolsPlugin;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.type.IDataTypeManagerService;

public class MongoDbConnectionInfoProvider
extends ConnectionInfoHelper
implements IConnectionInfoProvider {
    public static final String MONGODB_CLASSNAME = "class-name";
    public static final String MONGODB_CONNECTION_FACTORY = "org.teiid.resource.adapter.mongodb.MongoDBManagedConnectionFactory";

    @Override
    public String getDataSourcePasswordPropertyKey() {
        return null;
    }

    @Override
    public String getDataSourceType() {
        return ModelerCore.getTeiidDataTypeManagerService().getDataSourceType(IDataTypeManagerService.DataSourceTypes.MONGODB);
    }

    @Override
    public String getPasswordPropertyKey() {
        return "bogus_xxxx";
    }

    @Override
    public Properties getTeiidRelatedProperties(IConnectionProfile connectionProfile) {
        Properties connectionProps = new Properties();
        Properties baseProps = connectionProfile.getBaseProperties();
        if (!CoreStringUtil.isEmpty((String)baseProps.getProperty("Database"))) {
            connectionProps.put("Database", baseProps.get("Database"));
        } else if (!CoreStringUtil.isEmpty((String)baseProps.getProperty("databaseName"))) {
            connectionProps.put("Database", baseProps.get("databaseName"));
        }
        if (!CoreStringUtil.isEmpty((String)baseProps.getProperty("Username"))) {
            connectionProps.put("Username", baseProps.get("Username"));
        } else if (!CoreStringUtil.isEmpty((String)baseProps.getProperty("userName"))) {
            connectionProps.put("Username", baseProps.get("userName"));
        }
        if (!CoreStringUtil.isEmpty((String)baseProps.getProperty("Password"))) {
            connectionProps.put("Password", baseProps.get("Password"));
        } else if (!CoreStringUtil.isEmpty((String)baseProps.getProperty("password"))) {
            connectionProps.put("Password", baseProps.get("password"));
        }
        if (!CoreStringUtil.isEmpty((String)baseProps.getProperty("RemoteServerList"))) {
            connectionProps.put("RemoteServerList", baseProps.get("RemoteServerList"));
        } else if (!CoreStringUtil.isEmpty((String)baseProps.getProperty("serverHost")) && !CoreStringUtil.isEmpty((String)baseProps.getProperty("serverPort"))) {
            String host = baseProps.getProperty("serverHost");
            String port = baseProps.getProperty("serverHost");
            connectionProps.put("RemoteServerList", String.valueOf(host) + ":" + port);
        }
        connectionProps.setProperty(MONGODB_CLASSNAME, MONGODB_CONNECTION_FACTORY);
        return connectionProps;
    }

    @Override
    public void setConnectionInfo(ModelResource modelResource, IConnectionProfile connectionProfile) throws ModelWorkspaceException {
        Properties connectionProps = this.getCommonProfileProperties(connectionProfile);
        Properties props = connectionProfile.getBaseProperties();
        String result = props.getProperty("databaseName");
        if (result != null) {
            connectionProps.setProperty("connection:Database", result);
        }
        if ((result = props.getProperty("userName")) != null) {
            connectionProps.setProperty("connection:Username", result);
        }
        if ((result = props.getProperty("password")) != null) {
            connectionProps.setProperty("connection:Password", result);
        }
        String host = props.getProperty("serverHost");
        String port = props.getProperty("serverPort");
        if (host != null && port != null) {
            connectionProps.setProperty("connection:RemoteServerList", String.valueOf(host) + ":" + port);
        }
        this.getHelper().removeProperties(modelResource, "connectionProfile:");
        this.getHelper().removeProperties(modelResource, "translator:");
        this.getHelper().removeProperties(modelResource, "connection:");
        connectionProps.put("translator:name", "mongodb");
        this.getHelper().setProperties(modelResource, connectionProps);
    }

    @Override
    public Properties getCommonProfileProperties(IConnectionProfile profile) {
        return super.getCommonProfileProperties(profile);
    }

    @Override
    public IConnectionProfile getConnectionProfile(ModelResource modelResource) {
        String serverList;
        IConnectionProfile profile = super.getConnectionProfile(modelResource);
        Properties baseProps = profile.getBaseProperties();
        Properties mongoProps = new Properties();
        try {
            mongoProps = this.getConnectionProperties(modelResource);
        }
        catch (ModelWorkspaceException e) {
            DatatoolsPlugin.Util.log((Throwable)e);
        }
        String result = mongoProps.getProperty("Database");
        if (result != null) {
            baseProps.put("databaseName", result);
        }
        if ((result = mongoProps.getProperty("Username")) != null) {
            baseProps.put("userName", result);
        }
        if ((result = mongoProps.getProperty("Password")) != null) {
            baseProps.put("password", result);
        }
        if ((serverList = mongoProps.getProperty("RemoteServerList")) != null) {
            int i = 0;
            StringTokenizer iter = new StringTokenizer(serverList, ":");
            while (iter.hasMoreTokens()) {
                String token = iter.nextToken();
                if (i == 0) {
                    baseProps.put("serverHost", token);
                } else if (i == 1) {
                    baseProps.put("serverPort", token);
                }
                ++i;
            }
        }
        return profile;
    }

    @Override
    public String getTranslatorName(ModelResource modelResource) {
        return "mongodb";
    }

    @Override
    public boolean requiresPassword(IConnectionProfile connectionProfile) {
        return false;
    }
}

