/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.common.ICredentialsCommon;

public class WSConnectionInfoProvider
extends ConnectionInfoHelper
implements IConnectionInfoProvider {
    public static final String WS_CLASSNAME = "class-name";
    public static final String WS_CONNECTION_FACTORY = "org.teiid.resource.adapter.ws.WSManagedConnectionFactory";
    public static final String HEADER_PARAMETER = "header_param";

    @Override
    public void setConnectionInfo(ModelResource modelResource, IConnectionProfile connectionProfile) throws ModelWorkspaceException {
        String security;
        String user;
        Properties connectionProps = this.getCommonProfileProperties(connectionProfile);
        Properties props = connectionProfile.getBaseProperties();
        this.removeHeaderParameters(props);
        String url = WSConnectionInfoProvider.readEndPointProperty(props);
        if (url != null) {
            connectionProps.setProperty("connection:EndPoint", url);
        }
        if ((user = props.getProperty("AuthUserName")) != null && !user.isEmpty()) {
            connectionProps.setProperty("connection:AuthUserName", user);
        }
        if ((security = props.getProperty("SecurityType")) == null) {
            security = ICredentialsCommon.SecurityType.None.name();
        } else if (security.equals(ICredentialsCommon.SecurityType.Digest.toString())) {
            security = "Digest";
        }
        connectionProps.setProperty("connection:SecurityType", security);
        this.getHelper().removeProperties(modelResource, "connectionProfile:");
        this.getHelper().removeProperties(modelResource, "translator:");
        this.getHelper().removeProperties(modelResource, "connection:");
        connectionProps.put("translator:name", "ws");
        this.getHelper().setProperties(modelResource, connectionProps);
    }

    private void removeHeaderParameters(Properties props) {
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(HEADER_PARAMETER)) continue;
            props.remove(key);
        }
    }

    @Override
    public String getPasswordPropertyKey() {
        return "AuthPassword";
    }

    @Override
    public String getDataSourcePasswordPropertyKey() {
        return "AuthPassword";
    }

    @Override
    public String getDataSourceType() {
        return ModelerCore.getTeiidDataTypeManagerService().getDataSourceType(IDataTypeManagerService.DataSourceTypes.WS);
    }

    @Override
    public Properties getTeiidRelatedProperties(IConnectionProfile connectionProfile) {
        String contextFactory;
        Properties connectionProps = new Properties();
        Properties props = connectionProfile.getBaseProperties();
        String url = WSConnectionInfoProvider.readEndPointProperty(props);
        if (url != null) {
            connectionProps.setProperty("EndPoint", url);
        }
        if ((contextFactory = props.getProperty("SecurityType")) != null && !contextFactory.isEmpty()) {
            connectionProps.setProperty("SecurityType", contextFactory);
        } else {
            connectionProps.setProperty("SecurityType", ICredentialsCommon.SecurityType.None.name());
        }
        if (!connectionProps.getProperty("SecurityType").equals(ICredentialsCommon.SecurityType.None.name())) {
            String password;
            String user = props.getProperty("AuthUserName");
            if (user != null && !user.equals("")) {
                connectionProps.setProperty("AuthUserName", user);
            }
            if ((password = props.getProperty("AuthPassword")) != null) {
                connectionProps.setProperty("AuthPassword", password);
            }
        }
        connectionProps.setProperty(WS_CLASSNAME, WS_CONNECTION_FACTORY);
        return connectionProps;
    }

    @Override
    public boolean requiresPassword(IConnectionProfile connectionProfile) {
        Properties props = connectionProfile.getBaseProperties();
        String contextFactory = props.getProperty("SecurityType");
        if (contextFactory != null && !contextFactory.isEmpty() && !contextFactory.equalsIgnoreCase(ICredentialsCommon.SecurityType.None.name())) {
            props.remove("AuthUserName");
            return true;
        }
        return false;
    }
}

