/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.ui.ConnectionParameterPage;
import org.apache.directory.studio.connection.ui.ConnectionParameterPageManager;
import org.apache.directory.studio.connection.ui.actions.Messages;
import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.apache.directory.studio.connection.ui.actions.StudioActionProxy;
import org.apache.directory.studio.connection.ui.dnd.ConnectionTransfer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CopyAction
extends StudioAction {
    private StudioActionProxy pasteActionProxy;

    public CopyAction(StudioActionProxy pasteActionProxy) {
        this.pasteActionProxy = pasteActionProxy;
    }

    @Override
    public String getText() {
        Connection[] connections = this.getSelectedConnections();
        ConnectionFolder[] connectionFolders = this.getSelectedConnectionFolders();
        if (connections.length > 0 && connectionFolders.length == 0) {
            return connections.length > 1 ? Messages.getString("CopyAction.CopyConnections") : Messages.getString("CopyAction.CopyConnection");
        }
        if (connectionFolders.length > 0 && connections.length == 0) {
            return connectionFolders.length > 1 ? Messages.getString("CopyAction.CopyFolders") : Messages.getString("CopyAction.CopyFolder");
        }
        return Messages.getString("CopyAction.Copy");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY");
    }

    @Override
    public String getCommandId() {
        return "org.eclipse.ui.edit.copy";
    }

    @Override
    public void run() {
        Connection[] connections = this.getSelectedConnections();
        ConnectionFolder[] connectionFolders = this.getSelectedConnectionFolders();
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.addAll(Arrays.asList(connections));
        objects.addAll(Arrays.asList(connectionFolders));
        String urls = this.getSelectedConnectionUrls();
        if (objects != null) {
            if (urls != null && urls.length() > 0) {
                CopyAction.copyToClipboard(new Object[]{objects.toArray(), urls}, new Transfer[]{ConnectionTransfer.getInstance(), TextTransfer.getInstance()});
            } else {
                CopyAction.copyToClipboard(new Object[]{objects.toArray()}, new Transfer[]{ConnectionTransfer.getInstance()});
            }
        }
        if (this.pasteActionProxy != null) {
            this.pasteActionProxy.updateAction();
        }
    }

    public static void copyToClipboard(Object[] data, Transfer[] dataTypes) {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(Display.getCurrent());
            clipboard.setContents(data, dataTypes);
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getSelectedConnections().length + this.getSelectedConnectionFolders().length > 0;
    }

    private String getSelectedConnectionUrls() {
        StringBuilder sb = new StringBuilder();
        Connection[] connections = this.getSelectedConnections();
        ConnectionParameterPage[] connectionParameterPages = ConnectionParameterPageManager.getConnectionParameterPages();
        Connection[] connectionArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            Connection connection = connectionArray[n2];
            ConnectionParameter parameter = connection.getConnectionParameter();
            LdapUrl ldapUrl = new LdapUrl();
            ldapUrl.setDn(Dn.EMPTY_DN);
            ConnectionParameterPage[] connectionParameterPageArray = connectionParameterPages;
            int n3 = connectionParameterPages.length;
            int n4 = 0;
            while (n4 < n3) {
                ConnectionParameterPage connectionParameterPage = connectionParameterPageArray[n4];
                connectionParameterPage.mergeParametersToLdapURL(parameter, ldapUrl);
                ++n4;
            }
            sb.append(ldapUrl.toString());
            sb.append(ConnectionCoreConstants.LINE_SEPARATOR);
            ++n2;
        }
        return sb.toString();
    }
}

