/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.jobs.CloseConnectionsRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionJob;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.actions.Messages;
import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteAction
extends StudioAction {
    @Override
    public String getText() {
        Connection[] connections = this.getSelectedConnections();
        ConnectionFolder[] connectionFolders = this.getSelectedConnectionFolders();
        if (connections.length > 0 && connectionFolders.length == 0) {
            return connections.length > 1 ? Messages.getString("DeleteAction.DeleteConnections") : Messages.getString("DeleteAction.DeleteConnection");
        }
        if (connectionFolders.length > 0 && connections.length == 0) {
            return connectionFolders.length > 1 ? Messages.getString("DeleteAction.DeleteConnectionFolders") : Messages.getString("DeleteAction.DeleteConnectionFolder");
        }
        return Messages.getString("DeleteAction.Delete");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
    }

    @Override
    public String getCommandId() {
        return "org.eclipse.ui.edit.delete";
    }

    @Override
    public void run() {
        int i;
        Connection[] connections = this.getSelectedConnections();
        ConnectionFolder[] connectionFolders = this.getSelectedConnectionFolders();
        StringBuffer message = new StringBuffer();
        if (connections.length > 0) {
            if (connections.length <= 5) {
                message.append(connections.length == 1 ? Messages.getString("DeleteAction.SureDeleteFollowingConnection") : Messages.getString("DeleteAction.SureDeleteFollowingConnections"));
                i = 0;
                while (i < connections.length) {
                    message.append(ConnectionCoreConstants.LINE_SEPARATOR);
                    message.append("  - ");
                    message.append(connections[i].getName());
                    ++i;
                }
            } else {
                message.append(Messages.getString("DeleteAction.SureDeleteSelectedConnections"));
            }
            message.append(ConnectionCoreConstants.LINE_SEPARATOR);
            message.append(ConnectionCoreConstants.LINE_SEPARATOR);
        }
        if (connectionFolders.length > 0) {
            if (connectionFolders.length <= 5) {
                message.append(connectionFolders.length == 1 ? Messages.getString("DeleteAction.SureDeleteFollowingFolder") : Messages.getString("DeleteAction.SureDeleteFollowingFolders"));
                i = 0;
                while (i < connectionFolders.length) {
                    message.append(ConnectionCoreConstants.LINE_SEPARATOR);
                    message.append("  - ");
                    message.append(connectionFolders[i].getName());
                    ++i;
                }
            } else {
                message.append(Messages.getString("DeleteAction.SureDeleteSelectedConnectionFolders"));
            }
            message.append(ConnectionCoreConstants.LINE_SEPARATOR);
            message.append(ConnectionCoreConstants.LINE_SEPARATOR);
        }
        if (message.length() == 0 || MessageDialog.openConfirm((Shell)this.getShell(), (String)this.getText(), (String)message.toString())) {
            List<Connection> connectionsToDelete = this.getConnectionsToDelete();
            List<ConnectionFolder> connectionsFoldersToDelete = this.getConnectionsFoldersToDelete();
            if (!connectionsToDelete.isEmpty()) {
                this.deleteConnections(connectionsToDelete);
            }
            if (!connectionsFoldersToDelete.isEmpty()) {
                this.deleteConnectionFolders(connectionsFoldersToDelete);
            }
        }
    }

    private List<ConnectionFolder> getConnectionsFoldersToDelete() {
        ArrayList<ConnectionFolder> selectedFolders = new ArrayList<ConnectionFolder>(Arrays.asList(this.getSelectedConnectionFolders()));
        ArrayList<ConnectionFolder> foldersToDelete = new ArrayList<ConnectionFolder>();
        while (!selectedFolders.isEmpty()) {
            ConnectionFolder folder = (ConnectionFolder)selectedFolders.get(0);
            List subFolderIds = folder.getSubFolderIds();
            for (String subFolderId : subFolderIds) {
                ConnectionFolder subFolder = ConnectionCorePlugin.getDefault().getConnectionFolderManager().getConnectionFolderById(subFolderId);
                if (subFolder == null) continue;
                selectedFolders.add(subFolder);
            }
            if (!foldersToDelete.contains(folder)) {
                foldersToDelete.add(folder);
            }
            selectedFolders.remove(folder);
        }
        return foldersToDelete;
    }

    private List<Connection> getConnectionsToDelete() {
        ArrayList<ConnectionFolder> selectedFolders = new ArrayList<ConnectionFolder>(Arrays.asList(this.getSelectedConnectionFolders()));
        ArrayList<Connection> selectedConnections = new ArrayList<Connection>(Arrays.asList(this.getSelectedConnections()));
        ArrayList<Connection> connectionsToDelete = new ArrayList<Connection>(selectedConnections);
        while (!selectedFolders.isEmpty()) {
            ConnectionFolder folder = (ConnectionFolder)selectedFolders.get(0);
            List subFolderIds = folder.getSubFolderIds();
            for (String subFolderId : subFolderIds) {
                ConnectionFolder subFolder = ConnectionCorePlugin.getDefault().getConnectionFolderManager().getConnectionFolderById(subFolderId);
                if (subFolder == null) continue;
                selectedFolders.add(subFolder);
            }
            List connectionIds = folder.getConnectionIds();
            for (String connectionId : connectionIds) {
                Connection connection = ConnectionCorePlugin.getDefault().getConnectionManager().getConnectionById(connectionId);
                if (connection == null || connectionsToDelete.contains(connection)) continue;
                connectionsToDelete.add(connection);
            }
            selectedFolders.remove(folder);
        }
        return connectionsToDelete;
    }

    @Override
    public boolean isEnabled() {
        return this.getSelectedConnections().length + this.getSelectedConnectionFolders().length > 0;
    }

    private void deleteConnections(List<Connection> connectionsToDelete) {
        new StudioConnectionJob(new StudioConnectionRunnableWithProgress[]{new CloseConnectionsRunnable(connectionsToDelete)}).execute();
        for (Connection connection : connectionsToDelete) {
            ConnectionCorePlugin.getDefault().getConnectionManager().removeConnection(connection);
        }
    }

    private void deleteConnectionFolders(List<ConnectionFolder> connectionsFoldersToDelete) {
        for (ConnectionFolder connectionFolder : connectionsFoldersToDelete) {
            ConnectionCorePlugin.getDefault().getConnectionFolderManager().removeConnectionFolder(connectionFolder);
        }
    }
}

