/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.ConnectionFolderManager;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.ui.ConnectionParameterPage;
import org.apache.directory.studio.connection.ui.ConnectionParameterPageManager;
import org.apache.directory.studio.connection.ui.actions.Messages;
import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.apache.directory.studio.connection.ui.dnd.ConnectionTransfer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class PasteAction
extends StudioAction {
    @Override
    public String getText() {
        List<Connection> connections = this.getConnectionsToPaste();
        List<ConnectionFolder> connectionFolders = this.getConnectionFoldersToPaste();
        if (connections.size() > 0 && connectionFolders.size() == 0) {
            return connections.size() > 1 ? Messages.getString("PasteAction.PasteConnections") : Messages.getString("PasteAction.PasteConnection");
        }
        if (connectionFolders.size() > 0 && connections.size() == 0) {
            return connectionFolders.size() > 1 ? Messages.getString("PasteAction.PasteConnectionFolders") : Messages.getString("PasteAction.PasteConnectionFolder");
        }
        return Messages.getString("PasteAction.Paste");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE");
    }

    @Override
    public String getCommandId() {
        return "org.eclipse.ui.edit.paste";
    }

    @Override
    public boolean isEnabled() {
        return this.getFromClipboard((Transfer)ConnectionTransfer.getInstance()) != null || !this.getConnectionsByLdapUrl().isEmpty();
    }

    @Override
    public void run() {
        ConnectionFolderManager connectionFolderManager = ConnectionCorePlugin.getDefault().getConnectionFolderManager();
        ConnectionManager connectionManager = ConnectionCorePlugin.getDefault().getConnectionManager();
        ConnectionFolder[] selectedFolders = this.getSelectedConnectionFolders();
        Connection[] selectedConnections = this.getSelectedConnections();
        ConnectionFolder targetFolder = null;
        if (selectedFolders.length > 0) {
            targetFolder = selectedFolders[0];
        } else if (selectedConnections.length > 0) {
            targetFolder = connectionFolderManager.getParentConnectionFolder(selectedConnections[0]);
        }
        if (targetFolder == null) {
            targetFolder = connectionFolderManager.getRootConnectionFolder();
        }
        List<Connection> connections = this.getConnectionsToPaste();
        for (Connection connection : connections) {
            Connection newConnection = (Connection)connection.clone();
            connectionManager.addConnection(newConnection);
            targetFolder.addConnectionId(newConnection.getId());
        }
        List<ConnectionFolder> connectionFolders = this.getConnectionFoldersToPaste();
        for (ConnectionFolder connectionFolder : connectionFolders) {
            ConnectionFolder newConnectionFolder = (ConnectionFolder)connectionFolder.clone();
            connectionFolderManager.addConnectionFolder(newConnectionFolder);
            targetFolder.addSubFolderId(newConnectionFolder.getId());
        }
    }

    private List<Connection> getConnectionsToPaste() {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        Object content = this.getFromClipboard((Transfer)ConnectionTransfer.getInstance());
        if (content != null && content instanceof Object[]) {
            Object[] objects;
            Object[] objectArray = objects = (Object[])content;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof Connection) {
                    connections.add((Connection)object);
                }
                ++n2;
            }
        }
        if (connections.isEmpty()) {
            List<Connection> connectionByLdapUrl = this.getConnectionsByLdapUrl();
            connections.addAll(connectionByLdapUrl);
        }
        return connections;
    }

    private List<Connection> getConnectionsByLdapUrl() {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        Object content = this.getFromClipboard((Transfer)TextTransfer.getInstance());
        if (content != null && content instanceof String) {
            String[] lines;
            ConnectionParameterPage[] connectionParameterPages = ConnectionParameterPageManager.getConnectionParameterPages();
            String[] stringArray = lines = ((String)content).split(ConnectionCoreConstants.LINE_SEPARATOR);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (StringUtils.isNotEmpty((String)(line = line.trim()))) {
                    try {
                        LdapUrl ldapUrl = new LdapUrl(line);
                        ConnectionParameter parameter = new ConnectionParameter();
                        ConnectionParameterPage[] connectionParameterPageArray = connectionParameterPages;
                        int n3 = connectionParameterPages.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ConnectionParameterPage connectionParameterPage = connectionParameterPageArray[n4];
                            connectionParameterPage.mergeLdapUrlToParameters(ldapUrl, parameter);
                            ++n4;
                        }
                        Connection connection = new Connection(parameter);
                        connections.add(connection);
                    }
                    catch (LdapURLEncodingException ldapURLEncodingException) {}
                }
                ++n2;
            }
        }
        return connections;
    }

    private List<ConnectionFolder> getConnectionFoldersToPaste() {
        ArrayList<ConnectionFolder> folders = new ArrayList<ConnectionFolder>();
        Object content = this.getFromClipboard((Transfer)ConnectionTransfer.getInstance());
        if (content != null && content instanceof Object[]) {
            Object[] objects;
            Object[] objectArray = objects = (Object[])content;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ConnectionFolder) {
                    folders.add((ConnectionFolder)object);
                }
                ++n2;
            }
        }
        return folders;
    }

    protected Object getFromClipboard(Transfer dataType) {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(Display.getCurrent());
            Object object = clipboard.getContents(dataType);
            return object;
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }
}

