/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.studio.connection.ui.ConnectionUIConstants;
import org.apache.directory.studio.connection.ui.actions.ActionHandlerManager;
import org.apache.directory.studio.connection.ui.actions.CloseConnectionAction;
import org.apache.directory.studio.connection.ui.actions.CollapseAllAction;
import org.apache.directory.studio.connection.ui.actions.ConnectionViewActionProxy;
import org.apache.directory.studio.connection.ui.actions.CopyAction;
import org.apache.directory.studio.connection.ui.actions.DeleteAction;
import org.apache.directory.studio.connection.ui.actions.ExpandAllAction;
import org.apache.directory.studio.connection.ui.actions.NewConnectionAction;
import org.apache.directory.studio.connection.ui.actions.NewConnectionFolderAction;
import org.apache.directory.studio.connection.ui.actions.OpenConnectionAction;
import org.apache.directory.studio.connection.ui.actions.PasteAction;
import org.apache.directory.studio.connection.ui.actions.PropertiesAction;
import org.apache.directory.studio.connection.ui.actions.RenameAction;
import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.apache.directory.studio.connection.ui.dnd.ConnectionTransfer;
import org.apache.directory.studio.connection.ui.dnd.DragConnectionListener;
import org.apache.directory.studio.connection.ui.dnd.DropConnectionListener;
import org.apache.directory.studio.connection.ui.widgets.ConnectionConfiguration;
import org.apache.directory.studio.connection.ui.widgets.ConnectionWidget;
import org.apache.directory.studio.utils.ActionUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class ConnectionActionGroup
implements ActionHandlerManager,
IMenuListener {
    private CollapseAllAction collapseAllAction;
    private ExpandAllAction expandAllAction;
    protected static final String newConnectionAction = "newConnectionAction";
    protected static final String newConnectionFolderAction = "newConnectionFolderAction";
    protected static final String openConnectionAction = "openConnectionAction";
    protected static final String closeConnectionAction = "closeConnectionAction";
    protected static final String copyConnectionAction = "copyConnectionAction";
    protected static final String pasteConnectionAction = "pasteConnectionAction";
    protected static final String deleteConnectionAction = "deleteConnectionAction";
    protected static final String renameConnectionAction = "renameConnectionAction";
    protected static final String propertyDialogAction = "propertyDialogAction";
    private DragConnectionListener dragConnectionListener;
    private DropConnectionListener dropConnectionListener;
    protected Map<String, ConnectionViewActionProxy> connectionActionMap;
    protected IActionBars actionBars;
    protected ConnectionWidget mainWidget;

    public ConnectionActionGroup(ConnectionWidget mainWidget, ConnectionConfiguration configuration) {
        this.mainWidget = mainWidget;
        TreeViewer viewer = mainWidget.getViewer();
        this.collapseAllAction = new CollapseAllAction(viewer);
        this.expandAllAction = new ExpandAllAction(viewer);
        this.connectionActionMap = new HashMap<String, ConnectionViewActionProxy>();
        this.connectionActionMap.put(newConnectionAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new NewConnectionAction()));
        this.connectionActionMap.put(newConnectionFolderAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new NewConnectionFolderAction()));
        this.connectionActionMap.put(openConnectionAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new OpenConnectionAction()));
        this.connectionActionMap.put(closeConnectionAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new CloseConnectionAction()));
        this.connectionActionMap.put(pasteConnectionAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new PasteAction()));
        this.connectionActionMap.put(copyConnectionAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new CopyAction(this.connectionActionMap.get(pasteConnectionAction))));
        this.connectionActionMap.put(deleteConnectionAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new DeleteAction()));
        this.connectionActionMap.put(renameConnectionAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new RenameAction()));
        this.connectionActionMap.put(propertyDialogAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new PropertiesAction()));
        this.dropConnectionListener = new DropConnectionListener();
        this.dragConnectionListener = new DragConnectionListener(viewer);
        int ops = 3;
        Transfer[] transfers = new Transfer[]{ConnectionTransfer.getInstance()};
        viewer.addDragSupport(ops, transfers, (DragSourceListener)this.dragConnectionListener);
        viewer.addDropSupport(ops, transfers, (DropTargetListener)this.dropConnectionListener);
    }

    public void dispose() {
        if (this.mainWidget != null) {
            Iterator<String> it = this.connectionActionMap.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                ConnectionViewActionProxy action = this.connectionActionMap.get(key);
                action.dispose();
                action = null;
                it.remove();
            }
            this.collapseAllAction.dispose();
            this.collapseAllAction = null;
            this.expandAllAction.dispose();
            this.expandAllAction = null;
            this.connectionActionMap.clear();
            this.connectionActionMap = null;
            this.actionBars = null;
            this.mainWidget = null;
            this.dragConnectionListener = null;
            this.dropConnectionListener = null;
        }
    }

    public void enableGlobalActionHandlers(IActionBars actionBars) {
        this.actionBars = actionBars;
        this.activateGlobalActionHandlers();
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.connectionActionMap.get(newConnectionAction));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.connectionActionMap.get(openConnectionAction));
        toolBarManager.add((IAction)this.connectionActionMap.get(closeConnectionAction));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.expandAllAction);
        toolBarManager.add((IAction)this.collapseAllAction);
        toolBarManager.update(true);
    }

    public void fillMenu(IMenuManager menuManager) {
    }

    public void fillContextMenu(IMenuManager menuManager) {
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)this.connectionActionMap.get(newConnectionAction));
        menuManager.add((IAction)this.connectionActionMap.get(newConnectionFolderAction));
        menuManager.add((IContributionItem)new Separator());
        if (((IAction)this.connectionActionMap.get(closeConnectionAction)).isEnabled()) {
            menuManager.add((IAction)this.connectionActionMap.get(closeConnectionAction));
        } else if (((IAction)this.connectionActionMap.get(openConnectionAction)).isEnabled()) {
            menuManager.add((IAction)this.connectionActionMap.get(openConnectionAction));
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.connectionActionMap.get(copyConnectionAction));
        menuManager.add((IAction)this.connectionActionMap.get(pasteConnectionAction));
        menuManager.add((IAction)this.connectionActionMap.get(deleteConnectionAction));
        menuManager.add((IAction)this.connectionActionMap.get(renameConnectionAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.connectionActionMap.get(propertyDialogAction));
    }

    @Override
    public void activateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.connectionActionMap.get(copyConnectionAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.connectionActionMap.get(pasteConnectionAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.connectionActionMap.get(deleteConnectionAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.connectionActionMap.get(renameConnectionAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.connectionActionMap.get(propertyDialogAction));
            this.actionBars.updateActionBars();
        } else {
            IAction ca = (IAction)this.connectionActionMap.get(copyConnectionAction);
            ca.setActionDefinitionId(ConnectionUIConstants.CMD_COPY);
            ActionUtils.activateActionHandler(ca);
            IAction pa = (IAction)this.connectionActionMap.get(pasteConnectionAction);
            pa.setActionDefinitionId(ConnectionUIConstants.CMD_PASTE);
            ActionUtils.activateActionHandler(pa);
            IAction da = (IAction)this.connectionActionMap.get(deleteConnectionAction);
            da.setActionDefinitionId(ConnectionUIConstants.CMD_DELETE);
            ActionUtils.activateActionHandler(da);
            IAction pda = (IAction)this.connectionActionMap.get(propertyDialogAction);
            pda.setActionDefinitionId(ConnectionUIConstants.CMD_PROPERTIES);
            ActionUtils.activateActionHandler(pda);
        }
    }

    @Override
    public void deactivateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), null);
            this.actionBars.updateActionBars();
        } else {
            IAction ca = (IAction)this.connectionActionMap.get(copyConnectionAction);
            ActionUtils.deactivateActionHandler(ca);
            IAction pa = (IAction)this.connectionActionMap.get(pasteConnectionAction);
            ActionUtils.deactivateActionHandler(pa);
            IAction da = (IAction)this.connectionActionMap.get(deleteConnectionAction);
            ActionUtils.deactivateActionHandler(da);
            IAction pda = (IAction)this.connectionActionMap.get(propertyDialogAction);
            ActionUtils.deactivateActionHandler(pda);
        }
    }
}

